<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\ExcelImport;
use \App\Imports\CoursPromotionImport;
use \App\Imports\CoteImport;
use \App\Exports\EleveExport;
use \App\Exports\MsPromotionExport;
use \App\Exports\GrilleSynthFeuilExport;
use \App\Exports\ClasseEleveExport;
use \App\Exports\GrilleVideEleveExport;
use \App\Exports\GrilleSynthAllClassExport;
use \Excel;
use \App\Masomwetu\School\Personnel;
use \App\Masomwetu\Scholar\MsClasse;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Masomwetu\Scholar\MsPromotion;
use \App\Masomwetu\Report\MrCours;
use \App\Masomwetu\Report\MrCoursPromotion;

class ExcelImportController extends Controller
{
		public function promotion(Request $request){
			$this->validate($request,[
				'select_file' => 'required|mimes:xls,xlsx'
			]);
			
			Excel::import(new CoursPromotionImport, $request->file('select_file'));
		}
		
		// permet d'aligner tous les cours de toutes les classes d'une promotion
		public function aligner_tous_les_cours_dela_promotion($id_promo){
			$personnel = Personnel::all()->first();
			if(!$personnel){
				$datas = [
					'noms'=>'Enseignant par DEFAUT',
					'genre'=>'M',
					'adresse'=>'',
					'telephone'=>'243243243',
					'mc_fonction_id'=>'',
					'login'=>'log-prof',
					'password'=>'pwd-prof',
				];
				$personnel = Personnel::create($datas);
			}
			
			$mrcourspromotions = MrCoursPromotion::where('ms_promotion_id',$id_promo)->get();
			$msclasses = MsClasse::where('ms_promotion_id',$id_promo)->get();			
			
			foreach($msclasses as $cl){
				foreach($mrcourspromotions as $cr){
					$datas = [
					'mr_cours_promotion_id'=>$cr->id,
					'ms_classe_id'=>$cl->id,
					'personnel_id'=>$personnel->id,
					'aligne_cette_annee'=>1,
					'actif'=>1,
					];
					MrCours::create($datas);				
				}
			}
		}
		
		// telecharge un model de grille execel permettant l'importation des eleves		
		public function fiche_excel_import_eleve($id){
			$cl = MsClasse::with('msPromotion.section')->find($id);
			$nom = $cl->classe.'_'.$cl->msPromotion->section->nom_sec.'_'.$cl->id;
			
			return Excel::download((new ClasseEleveExport)->forClasse($cl->id), $nom.'.xlsx');
			
		}
		
		public function import_export(Request $request){
			// dd($request->file('select_file'));
			
			if($request->action=="import"){
				// $this->validate($request,['select_file' => 'required|mimes:xls,xlsx']);
				
				if($request->table=="cours"){
					$file = $request->file('select_file')[0];
					$this->validate($request,['ms_classe_id' => 'required','action' => 'required']);
					$classe = MsClasse::find($request->ms_classe_id);
					
					$id = $classe->ms_promotion_id;
					Excel::import( new CoursPromotionImport($id), $file); // on importe
					$this->aligner_tous_les_cours_dela_promotion($id); // on importe tous les cours de la promotion dans toutes les classes de la promotion
					return redirect()->route('report.cours');// on retourne les cours de la promotion
				}
				
				/* if($request->table=="cotes"){
					$tabErreur = [];
					foreach($request->file('select_file') as $file){
						$nomFicher = $file->getClientOriginalName();
						$tab = explode('_',$nomFicher);
						
						if(count($tab)>=3)
							$id = $tab[ count($tab)-2 ];
						else $id = $request->mr_cours_id;
						$coteImport = new CoteImport($id)
						Excel::import($coteImport , $file);
						// retourner les message d'erreur dans une grille excel
						if(count($t=$coteImport->getErreur()))
							$tabErreur[$nomFicher] = $t;
					}
					if(count($tabErreur))
						return (new ImportErrorExport($tabErreur))->download('ImportError.xlsx');
					return redirect()->route('report.cours.cote',['id'=>$id]);// on retourne les cours de la promotion
				} */
				
				if($request->table=="eleves"){
					$this->validate($request,['ms_classe_id' => 'required','action' => 'required']);
					$classe = MsClasse::find($request->ms_classe_id);
					// $id = $request->mr_cours_id;
					Excel::import( new EleveImport($classe), $file); // on importe
					
					return redirect()->route('report.cours.cote',['id'=>$id]);// on retourne les cours de la promotion
				}
			}			
			if($request->action=="export"){
				if($request->table=="eleve"){
					$this->validate($request,['ms_classe_id' => 'required','action' => 'required']);
					$classe = MsClasse::find($request->ms_classe_id);
					
					// foreach($classe->mrCourss as $c)
					$id_cours = 1;
					return Excel::download((new EleveExport)->forClasse($request->ms_classe_id), $classe->classe.'_'.$id_cours.'.xlsx');
				}
			}
			// action
			// ms_classe_id
			
			// Excel::import(new CoteImport, $request->file('select_file'));
			
			return redirect()->route('report.cotes');
		}
		
		public function export_grille_cote($id_cours){
			$cr = MrCours::find($id_cours);
			$classe = $cr->msClasse->classe;
			$cours = str_replace("/",'-', $cr->mrCoursPromotion->intitule_cours);
			$cours = str_replace("&",'-', $cours);
			
			$max = $cr->mrCoursPromotion->max_periode;
			// dd($cr,$id_cours);
					
			// foreach($classe->mrCourss as $c)
			return Excel::download((new EleveExport)->forClasse($cr->ms_classe_id), $classe.'_'.$cours.'_'.$id_cours.'_'.$max.'.xlsx');
			
		}
		
		public function export_grille_cours($id_pro){
			// dd($cr,$id_cours);
			$pr = MsPromotion::with('section')->find($id_pro);
			$filename = 'GC_'.$pr->section->nom_sec.'_'.$pr->promotion.'_'.$pr->id.'_MS.xlsx';
			return 	Excel::download((new MsPromotionExport)->forPromotion($pr->id), $filename );
			
		}
		
		public function export_grille_synth($id_classe,$aveCote=false,$travail=false){
			// dd($cr,$id_cours);
			$travail = explode('-',$travail);
			if($id_classe=='all'){
				$id_annee = \App\Config::getIdAnnee();
				$msClasses = MsClasse::with('msPromotion')
							->whereHas('msPromotion', function($q) use($id_annee){								
								$q->where("ms_annee_scolaire_id",$id_annee);									
							})->get();
				$classe_ids = [];
				foreach($msClasses as $cls)
					$classe_ids[$cls->id] = $cls->classe;
					
				$filename = 'Grille-Synth-All-Classes';
				$exp = (new GrilleSynthAllClassExport($classe_ids,$travail[0]));
			}
			else{
				$cl = MsClasse::find($id_classe);
				$filename = 'Grille-Synth-'.$cl->classe;	
				
				$exp = (new GrilleSynthFeuilExport($cl->id,$travail));			
			}
			$filename .= '.xlsx';
			return 	Excel::download($exp, $filename );
				
			
		}
		
		public function export_grille_vide_eleves($id_classe){
			// dd($cr,$id_cours);
			$cl = MsClasse::find($id_classe);
			
			$nom = mb_ereg_replace("([^\w\s\d\-_~,;\[\]\(\).])", '', $cl->classe);
			// Remove any runs of periods (thanks falstro!)
			$nom = mb_ereg_replace("([\.]{2,})", '', $nom);
			$nom = str_replace("\\",'-',$nom);
		
			$filename = 'ELEVES de '.$nom.'_'.$cl->id.'.xlsx';
			// $filename = 'Grille-Synth.xlsx';
			$exp = (new GrilleVideEleveExport)->forClasse($cl->id);
			return 	Excel::download($exp, $filename );
			
		}
}
