<?php

namespace App;
use App\Masomwetu\Sys\SysUserRole;
use App\Masomwetu\Sys\SmsConfig;
use App\Masomwetu\Sys\Parametre;
use App\Masomwetu\School\Ecole;
use App\Masomwetu\Scholar\MsAnneeScolaire;
use App\Masomwetu\Disciplinary\Periode;
class Config
{
	public static $sysUserRole = null;
	public static $ecole = null;
	public static $annee = null;
	
	public static function initUser(){
		if(!self::$sysUserRole){
			if (session()->has('sys_user_role_id')) {
				self::$sysUserRole = SysUserRole::with('user','sysRole','ecole')->find(session('sys_user_role_id'));
				//dd(self::$sysUserRole,\DB::connection()->getDataBaseName());
			}
			else return false;
		}
		return self::$sysUserRole;
	}
    
    public static function getAnnee(){
		if(!self::$annee){
		    if((!session()->has('annee_id')) )
			self::$annee = MsAnneeScolaire::where('etat', 1 )->first();
			else self::$annee = MsAnneeScolaire::where('id', session('annee_id'))->first();
		}
		return self::$annee->annee;
	}

    public static function getEcole(){
       
		if (!session()->has('ecole_id'))  return 'ECOLE';
		if(!self::$ecole)
			self::$ecole = Ecole::find(session('ecole_id'));
		return self::$ecole->nom_ecole;
	}

    public static function getEcoleId(){
		if (!session()->has('ecole_id'))  return false;
		if(!self::$ecole)
			self::$ecole = Ecole::find(session('ecole_id'));
		if(self::$ecole)
		    return self::$ecole->id;
		else {
		    self::$ecole = Ecole::find(session('ecole_id'));
		    return session('ecole_id');
		    return 0;
		}
	}
		
	public static function getIdAnnee(){
		if(!self::$annee){
		    if((!session()->has('annee_id')) )
			self::$annee = MsAnneeScolaire::where('etat', 1 )->first();
			else self::$annee = MsAnneeScolaire::where('id', session('annee_id'))->first();
		}
		return self::$annee->id;
	}
	
	public static function getLogo(){
		if (!session()->has('ecole_id'))  return false;
		if(!self::$ecole)
			self::$ecole = Ecole::find(session('ecole_id'));
		return self::$ecole->logo_ecole;
	}
	
	public static function getIp(){
		return "192.168.1.100";
	}
	
	public static function getActiveSms($num){
		$pays = substr($num,0,3);
		if($pays=='243')
			$reseau = substr($num,3,2);
		else $reseau = substr($num,0,2);
		if($reseau=="99" or $reseau=="97")
			$reseau = "AIRTEL";
		else if($reseau=="89" or $reseau=="85" or $reseau=="84" or $reseau=="80")
			$reseau = "ORANGE";
		else if($reseau=="81" or $reseau=="82")
			$reseau = "VODACOM";
		else if($reseau=="90" or $reseau=="91")
			$reseau = "AFRICELL";
		else $reseau = "TOUT";
		 // dd($reseau);
		
		$sms = SmsConfig::where('active',true)->where('reseau',$reseau)->first();
		//dd($sms ,$reseau,$pays);
		if($sms){
			return $sms;
		}
		else return SmsConfig::where('active',true)->first();;
	}
	public static function getPeriode(){
		$p = Periode::where('etat','Active')->first();
		if($p){
			return $p->id;
		}
		else return false;
	}
	
	public static function getParamVal($param){
		$p = Parametre::where('name',$param)->where('active',1)->first();
		if($p)
			return $p->value;
		return null;
	}
}
