<?php

namespace App\Exports;

use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

use Maatwebsite\Excel\Concerns\WithTitle;

class ExportEleve extends ExportTitle implements FromView, WithTitle,ShouldAutoSize
{
    use Exportable;
	public function __construct($classe_id,$classe)
	{
		$this->title = $this->classe = $classe;
		$this->classe_id = $classe_id;
	}
    
	public function view(): View
	{
		$id_annee = \App\Config::getIdAnnee();
		$mseleves = MsEleve::with('enfant')
		->where('ms_annee_scolaire_id', $id_annee)
		->where('ms_classe_id', $this->classe_id)->get();
		
		return view('exports.model_import_eleve',['eleves'=>$mseleves]);
	}
	
	
}
