<?php

namespace App\Exports;

use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\Report\MrCoursPromotion;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\Exportable;

use Maatwebsite\Excel\Concerns\WithTitle;
// use Maatwebsite\Excel\Concerns\ShouldAutoSize;

// use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

// class GrilleSynthExport implements FromQuery
class GrilleSynthExport implements FromView, WithTitle/* , WithEvents, ShouldAutoSize */
{
    use Exportable;
	public $with_cote = false;
	public $nomPeriode = '';
	public $name = 'MS-Grille';
    public function forNomPeriode($n)
    {
        $this->nomPeriode = $n;
        
        return $this;
    } 
    public function forName($n)
    {
        $this->name = $n;
        
        return $this;
    }  
    public function forClasse(int $id)
    {
        $this->classe_id = $id;
        
        return $this;
    } 
    public function withCote($true)
    {
        $this->with_cote = $true;
        
        return $this;
    } 
    public function forTravail($travail)
    {
        $this->travail = $travail;
        
        return $this;
    } 
	public function view(): View
	{
		$eleves = MsEleve::with('enfant')->where('ms_classe_id', $this->classe_id)->get();
		$mrcourss = MrCours::with('mrCoursPromotion')->where('ms_classe_id', $this->classe_id);
		if($this->travail%3==0){
			$mrcourss = $mrcourss->whereHas('mrCoursPromotion', function($q){								
								$q->where("coter_examen",true);									
							});
		}
		$mrcourss = $mrcourss->get();
		
		if($this->with_cote)
			return view('exports.grille_deliberation', [ 'travail' => $this->travail ,'nomPeriode' => $this->nomPeriode , 'mseleves' => $eleves , 'mrcourss' => $mrcourss ]);
		return view('exports.grille_synth', [ 'mseleves' => $eleves , 'mrcourss' => $mrcourss ]);
	}
	
    public function query()
    {
        return MsEleve::query()->where('ms_classe_id', $this->classe_id);
    }
	
	public function title(): string
	{
		$n = $this->name;
		if(strlen($n)>30)
			$n = substr($n,0,27);
		return $n;
	}
}
