<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Validator;

// tente de valider les règles reçues sur les données reçues et retourne true ou les message d'erreur

class AjaxValidator 
{
		public static function validate($datas,$rules){
			$data = [];
			foreach($datas as $input=>$tabValRules){
				if( !is_array($tabValRules) )
					$data[$input] = $tabValRules;
				else{
					if( isset($tabValRules['value']) )
						$data[$input] = $tabValRules['value'];
					if( isset($tabValRules['rules']) )
						$rules[$input] = $tabValRules['rules'];
				}
			}
			$validation = Validator::make($data,$rules);
			if ($validation->fails()){
				$message = "";
				$errors = $validation->messages()->messages();
				foreach($errors as $error=>$errors_msg){
					foreach($errors_msg as $msg)
						$message .= $msg.'</br>';
				}
				$result = "fail";
				return compact('result','message');
			}
			return true;
		}
		
		// crée un tableau de donnée 
		public static function request_data($tab, $request){
			$data = [];
			if( !is_array($tab) )
				$tab = explode(",",$tab);
			
			foreach($tab as $input){
				$data[$input] = $request->get($input);
			}
			return $data;
		}
}