<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\McOperationSurSalaire;
use App\Masomwetu\Cash\CashSuiviPiece;
use App\Masomwetu\Cash\CashCategorie;
use App\Masomwetu\Cash\CashSuivi;
use App\Masomwetu\Comptabilite\Compte;
use App\Masomwetu\Comptabilite\MouvementCompte;
use App\Masomwetu\Comptabilite\MouvementComptePiece;
use App\Masomwetu\Comptabilite\TauxChange;
use App\Masomwetu\Comptabilite\RapportJournalier;
use App\Masomwetu\Comptabilite\RapportMensuel;
use App\Masomwetu\Comptabilite\CategorieCompte;
use App\Masomwetu\Comptabilite\CompteEtUser;
use App\Masomwetu\Comptabilite\CptComptable;
use App\Masomwetu\Comptabilite\CptSecteur;
use App\Masomwetu\Comptabilite\CptPrevisionsBudgetaire;
use App\Masomwetu\Comptabilite\CptCompteBudgetiser;

use App\Masomwetu\Sys\User; 

use \App\Masomwetu\Payment\MpFraisPaiement;
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpTypeFrais;
use \App\Masomwetu\Payment\MpFraisClasse;
use Mail;
 

use Illuminate\Support\Facades\Auth; 

class ComptaController extends Controller
{
	public function login(Request $req){
		if($req->method()=='GET')
			return view('os.login');
		
		$credentials = $req->only('email','password');
		if(Auth::attempt($credentials)){
			$this->envoyer_tocken();
			//session(['sys_user_role_id' => 4]);
			session(['type_user' => 'compta']);
			return redirect()->route('compta.login.tocken');
		}
		my_flash("Coordonnéés Incorrectes!!","danger");
		return redirect()->route('compta.login');
	}
	
	private function envoyer_tocken(){
		$hr = date('H:i:s');
		$user = \Auth::user();
		User::find($user->id)->update(['email_verified_at'=>date('Y-m-d '.$hr)]);
		$code = str_replace(':','',$hr);

		$data["email"] = $user->email;//"chad@esisalama.org";
		$data["title"] = "CODE SECRET COMPTABILITE ". \App\Config::getEcole();
		$data["code"] = $code;
		try{
			Mail::send('emails.code_secret', $data, function($message)use($data) {
					$message->to($data["email"], $data["email"])
							->subject($data["title"]);
					
				}); 
		}catch(\Exception $e){
			dd($e->getMessage());
		}
		
		ms_sms($user->telephone,$code);
		//ms_sms('243898920046',str_replace(':','',$hr));
	}
	
	public function login_tocken(Request $req){
		if($req->method()=='GET')
			return view('os.login_tocken');
		
		if($req->btn_resend_tocken){
			$this->envoyer_tocken();
			return redirect()->route('compta.login.tocken');
		}
		$user = User::find(\Auth::user()->id);
		$date = explode(' ',$user->email_verified_at);
		$cle = str_replace(':','',$date[1]);
		
		$debut = strtotime($user->email_verified_at);
		$fin = time();
		if(($fin-$debut)>5*60)
			my_flash("Votre a déjà expirée!!","danger");
		else if($req->cle == $cle){
			session(['tocken-verifier' => 'ok']);
			return redirect()->route('compta.index');			
		}
		else my_flash("Clé Incorrecte!!","danger");
		return redirect()->route('compta.login.tocken');
	}
	
	public function prevision(Request $req){
		$data=$keys=[];
		if($req->method()=='POST' and $req->btn_budgetiser){
			$data = $req->only('montant_limit','compte_id','cpt_previsions_budgetaire_id');
			$keys['compte_id'] = $req->compte_id;
			$keys['cpt_secteur_id'] = $req->cpt_secteur_id;
			$keys['cpt_previsions_budgetaire_id'] = $req->cpt_previsions_budgetaire_id;
			$rules = ['montant_limit'=>'required','compte_id'=>'required','cpt_previsions_budgetaire_id'=>'required'];
			\Validator::make($data,$rules)->validate();
			$c = CptCompteBudgetiser::firstOrCreate($keys,$data);
			//dd($c);
			$c->update($data);
			my_flash("Enregistrement effectée avec succès");
			return redirect()->route('compta.prevision');
		}
		else if($req->method()=='POST' and $req->btn_prevoir){
			$data = $req->only('annee','date_debut','date_fin','observation');
			$keys['annee'] = $req->annee;
			$rules = ['annee'=>'required','date_debut'=>'required','date_fin'=>'required','observation'=>''];
			\Validator::make($data,$rules)->validate();
			$p = CptPrevisionsBudgetaire::firstOrCreate($keys,$data);
			$p->update($data);
			my_flash("Enregistrement effectée avec succès");
			return redirect()->route('compta.prevision');
		}
		
		$user = User::with('cptComptables.cptSecteur')->find(\Auth::user()->id);
		$cptPrevisionsBudgetaires = CptPrevisionsBudgetaire::all();
		$comptes = Compte::with('categorieCompte')->get();
		$cptCompteBudgetisers = $date_debut = $date_fin = $annee = false;
		if($id = $req->cpt_previsions_budgetaire_id){
			$cptPrevisionsBudgetaire = CptPrevisionsBudgetaire::with(
			'cptCompteBudgetisers.compte.categorieCompte',
			'cptCompteBudgetisers.compte.mpFraisPaiements',
			'cptCompteBudgetisers.compte.mouvementComptes')
			->find($id);
			$date_debut = $cptPrevisionsBudgetaire->date_debut;
			$date_fin = $cptPrevisionsBudgetaire->date_fin;
			$annee = $cptPrevisionsBudgetaire->annee;
			$secteur_ids = $user->cptComptables->map(function($v,$k){return $v->cpt_secteur_id;})->toArray();
			$cptCompteBudgetisers = $cptPrevisionsBudgetaire->cptCompteBudgetisers
			->whereIn('cpt_secteur_id',$secteur_ids)
			->map(function($v,$k) use($annee,$date_debut,$date_fin,$secteur_ids){
				$cpt = $v->compte;
				$som = 0;
				if($cpt->mpFraisPaiements->count()){
					$som = $cpt->mpFraisPaiements->sum(function($v) use($date_debut,$date_fin){
						return ($date_debut <= $v->payer_le and $date_fin >= $v->payer_le)?$v->montant_payer:0;
					});
				}
				else if($cpt->mouvementComptes->count()){
					$som = $cpt->mouvementComptes->sum(function($v) use($date_debut,$date_fin,$secteur_ids){
						return ($date_debut <= $v->date_mouv and $date_fin >= $v->date_mouv and in_array($v->cpt_secteur_id,$secteur_ids))?$v->montant:0;
					});
				}
				return [
				'code'=>$cpt->code,'libelle'=>$cpt->libelle,
				'categorie'=>$cpt->categorieCompte->categorie,
				'entree'=>$cpt->categorieCompte->entree,
				'limit'=>$v->montant_limit,'som'=>$som,'marge'=>$v->montant_limit-$som,
				'annee'=>$annee,'pourcentage'=>$cpt->pourcentage,
				'pcode'=>$cpt->compte->code??'','plibelle'=>$cpt->compte->libelle??''];
			})->sortBy('libelle')->groupBy('entree');
		}
		
		//my_flash("Coordonnéés Incorrectes!!","danger");
		return view('os.previsionbudgetaire',compact('cptCompteBudgetisers','comptes','cptPrevisionsBudgetaires','annee','date_debut','date_fin','user'));
	}
	
	public function logout(Request $req){
		Auth::logout();
		return redirect()->route('compta.login');
		
	}
	
	public function rapport_journalier(Request $req){
		$c = new \App\Http\Controllers\MCashController();
		return $c->rapport_journalier($req);
	}
	
	public function rapport_mensuel(Request $req){
		$c = new \App\Http\Controllers\MCashController();
		return $c->rapport_mensuel($req);
	}
	
	public function rapport_global(Request $req){
		$c = new \App\Http\Controllers\MCashController();
		return $c->rapport_journalier_global($req);
	}
	
	public function index(){
		
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$compte = new Compte;
		$ids = $user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray();
		$comptes = Compte::with('compte','categorieCompte')->whereIn('id',$ids)
		->get();
		return view('os.mouvement',compact('comptes','user'));
	}
	
	public function entree_sorties(){
		
		$user_id = \Auth::user()->id;
		$comptes = Compte::with('compte')->get();
		$users = User::all();
		$mes_comptes = User::with('compteEtUsers.compte')->find($user_id)->compteEtUsers;
		$CompteEtUsers=null;
		// dd($user_id,$CompteEtUsers);
		return view('os.entre_sortie',compact('CompteEtUsers','users','comptes','mes_comptes'));
		//return view('',compact('comptes','user'));
	}
	
	public function codification(){
		
		$categorieComptes = CategorieCompte::all();
			$user_id = \Auth::user()->id;
		$users = User::all();
		$cpt_secteurs = CptSecteur::all();
		$cptcomptables = CptComptable::with('user','cptSecteur')->get();
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$compte = new Compte;
		$ids = $user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray();
		$comptes = Compte::with('compte','categorieCompte')
		//->whereIn('id',$ids)
		->get();
		
				
		return view('os.codification',compact('cptcomptables','cpt_secteurs','categorieComptes','comptes','users','compte','user'));
	}
}
