<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

use \App\Config;
class Controller extends BaseController
{
    // function __construct()
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
	public function __construct()
    {
        if(session( 'test_db') == 'yes' ){
            \DB::setDefaultConnection('mysql2');
        }
    }
    // function that generate a session flash message
    protected function flash($message, $type = 'success'){
        session()->flash('notification.message', $message);
        session()->flash('notification.type', $type);
    }

	public function addUser($path,$tab=[]){
		
		$sysUserRole = Config::initUser() ;
		$userInterface = true;
		return view($path, array_merge( $tab,compact('sysUserRole','userInterface')) );
	}
	
}
