<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\McOperationSurSalaire;
use App\Masomwetu\Cash\CashSuiviPiece;
use App\Masomwetu\Cash\CashCategorie;
use App\Masomwetu\Cash\CashSuivi;
use \App\Masomwetu\Scholar\MsClasse;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Masomwetu\Scholar\MsPromotion;
use \App\Masomwetu\Scholar\MsAnneeScolaire;
use \App\Masomwetu\Scholar\MsInscription;
use \App\Masomwetu\Scholar\Tuteur;
use \App\Masomwetu\Scholar\Enfant;
use \App\Masomwetu\Scholar\ParentEnfant;
use \App\Masomwetu\School\Section;
use \App\Masomwetu\School\ElementDossierEleve;
use \App\Masomwetu\School\DossierEnfant;
use \App\Masomwetu\School\ImgDossierEnfant;
use \App\Masomwetu\School\Religion;

use App\Masomwetu\Sys\User; 

use \App\Masomwetu\Payment\MpFraisPaiement;
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpTypeFrais;
use \App\Masomwetu\Payment\MpFraisClasse;

use Illuminate\Support\Facades\Auth; 

class EleveController extends Controller
{
	public function index(Request $req){
		if($req->method()=='GET')
			return view('profile_eleve.index');
		
		
	}
	
	
	public function infos_eleve(Request $request){
		$data = MsEleve::with(
			'msClasse',
			'mpFraisPaiementExpetionnels',
			'empruntMateriels.materiel',
			'msEleveDerogers.mpFraisClasse.mpFrais',
			'msEleveDerogers.msDerogation',
			'msInscription.tuteur'
			,'msInscription.msPromotion.msAnneeScolaire.ecole'
			)->find($request->ms_eleve_id);
			
		return $data;
	}
	
	public function choisir_section(Request $req){
		$id = session()->get('idIns');
		$ins = MsInscription::find($id);
		$ins->choix_section = $req->choix1.', '.$req->choix2.', '.$req->choix3;
		$ins->save();
		return $ins;
	}
	
	
	public function voir_cote_coursdoption(Request $req){
		$id = session()->get('idIns');
		$ins = MsInscription::find($id);
		$promo_id = $req->promo_id;
		$start = 26; $last = 30;
		$cours_3electri = "(76,78,80,82,83,401)";// id des cours dans la promo de 3electri (la promotion du cote bulletin)
		$cours_8iem = "(26,27,28,29,30)";// id des cours dans la promo de 8iem (la promotion du cote bulletin)
		$cours_4mg = "(187,189,192,193)";// id des cours dans la promo de 4mg (la promotion du cote bulletin)
		$cours_opt = $cours_8iem;
		if($promo_id==1)$cours_opt = $cours_3electri;
		else if($promo_id==10)$cours_opt = $cours_4mg;

		$matricule = $ins->enfant->matricule;
		$tab = \DB::select("SELECT ef.nom, cr.intitule_cours,cr.coter_examen,cr.max_periode, cote_1,cote_2,cote_3,cote_4,cote_5,cote_6 
		FROM `bulletin_mr_cotes` co 
		INNER JOIN bulletin_mr_cours cr on cr.id=co.mr_cours_id 
		INNER JOIN bulletin_ms_eleves el on el.id=co.ms_eleve_id 
		INNER JOIN enfants ef on ef.id = el.enfant_id 
		WHERE co.mr_cours_id IN ($cours_opt) and ef.matricule='$matricule' 
		order by cr.num_bulletin ");
		
		return view('profile_eleve._cotes_choix',compact('tab'));// $ins;
	}

	public function infos_conduite(Request $request){
		$ctrl = new MDisciplinaryController;
		return $ctrl->dossier( $request ,$request->ms_eleve_id);
	}
	
	
	public function infos_frais(Request $request){
		$msEleve = $this->infos_eleve($request);
		$taux = $montant_total_payer = $montant_total_a_payer = '';
		$groupFrais = [];
		$mpFraisClasses = (\App\Masomwetu\Scholar\MsClasse::with('mpFraisClasses.mpFrais.mpTypeFrais')
													->find($msEleve->ms_classe_id));
		$mpFraisClasses = $mpFraisClasses->mpFraisClasses;
		$groupFrais = $mpFraisClasses->groupBy(function($v,$k){ return $v->mpFrais->mpTypeFrais->type; });
		$montant_total_a_payer 	= $mpFraisClasses->sum(function($it){
														if($it->mpFrais->mpTypeFrais->argent)
															return $it->montant;
														return 0;
													});
		$montant_total_payer 		= $msEleve->mpFraisPaiements->sum(function($it){
														if($it->mpFraisClasse->mpFrais->mpTypeFrais->argent)
															return $it->montant_payer;
														return 0;
													});
		$dette 									= $montant_total_a_payer - $montant_total_payer;
				
		
		return view("mes_vues.Payment.partials._dossier_liste_frais",['groupFrais'=>$groupFrais,'msEleve'=>$msEleve,'cest_la_fiche'=>true]);
	}

	public function infos_inscription(Request $request){
		$data = MsInscription::with(
			'tuteur',
			'msPromotion.msAnneeScolaire.ecole'
			)->find($request->ms_inscription_id);
			
		return $data;
	}
	
	public function fiche_reseignement(Request $request){
		if($request->has('frais'))
			return $this->infos_frais($request);
		if($request->has('conduite'))
			return $this->infos_conduite($request);
		if($request->has('ms_eleve_id'))
			return $this->infos_eleve($request);
		if($request->has('ms_inscription_id'))
			return $this->infos_inscription($request);

		$enfant = Enfant::with(
			'parentEnfant',
			'msInscriptions.msEleves.msClasse'
			,'msInscriptions.msPromotion.msAnneeScolaire.ecole'
			)->where('matricule',$request->matricule)->first();
			//dd($enfant->msInscriptions, $enfant->msInscriptions->where('code',$request->code));

		if($enfant and $enfant->msInscriptions->where('code_secret',$request->code)->count())
		{	
			session(['idIns'=>$enfant->msInscriptions->first()->id]);
			return $enfant;
		}
		else return ['erreur'=>"CODE OU MATRICULE INCORRECT"];

	}
}
