<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\SysUserRole;
use App\MsEleve;
use App\Config;
use App\Personnel;
use App\McOperationSurSalaire;
use App\Masomwetu\Cash\CashSuiviPiece;
use App\Masomwetu\Cash\CashCategorie;
use App\Masomwetu\Cash\CashSuivi;
use App\Masomwetu\Comptabilite\Compte;
use App\Masomwetu\Comptabilite\MouvementCompte;
use App\Masomwetu\Comptabilite\MouvementComptePiece;
use App\Masomwetu\Comptabilite\MouvementCpteUtilise;
use App\Masomwetu\Comptabilite\TauxChange;
use App\Masomwetu\Comptabilite\RapportJournalier;
use App\Masomwetu\Comptabilite\RapportMensuel;
use App\Masomwetu\Comptabilite\CategorieCompte;
use App\Masomwetu\Comptabilite\CompteEtUser;
use App\Masomwetu\Comptabilite\CptComptable;
use App\Masomwetu\Comptabilite\CptSecteur;
use App\Masomwetu\Comptabilite\CptCompteAsuivre;

use \App\Exports\RapportFinExport;
use \Excel;
use Mail;
 

use App\Masomwetu\Sys\User; 

use \App\Masomwetu\Payment\MpFraisPaiement;
use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpTypeFrais;
use \App\Masomwetu\Payment\MpFraisClasse;
// le controlleur qui gère l'entrée à toutes les sous applications
class MCashController extends Controller
{
	private $v_path = 'mes_vues.Cash.';
	
	public function cpt_secteur_ids(){
		$user = User::with('cptComptables.cptSecteur')->find(\Auth::user()->id);
		// tous les secteurs ou intervient le comptable
		if($user)
		return $user->cptComptables->map(function ($item, $key) {
			return $item->cpt_secteur_id;
		})->toArray();
		return [];
	}

	public function index(Request $request){
		
		return $this->sortie($request);
	}
	
	public function salaires(){
		// get all the mcoperationsursalaires
		$mcoperationsursalaires = McOperationSurSalaire::all();

		// load the view and pass the personnels
		return $this->addUser($this->v_path.'salaires',compact('mcoperationsursalaires'));

	}
	public function indicateurs(){
		// get all the mcoperationsursalaires
		
		// load the view and pass the personnels
		return $this->addUser($this->v_path.'indicateurs');

	}
	public function voir_les_previsions(){
		// get all the mcoperationsursalaires
		
		// load the view and pass the personnels
		return $this->addUser($this->v_path.'previsions');

	}
	public function datatable_configs(Request $request){
	    $table_name = $request->table_name??'comptes';
		return $this->addUser($this->v_path.'edit_crud',compact('table_name'));
	}
	
	public function datatable(Request $request){
		$id_annee = Config::getIdAnnee();
		$id_ecole = Config::getEcoleId();
		
		$user_id = \Auth::user()->id;
		
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$compte = new Compte;
		$mes_compte_ids = $user?$user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray():[];
		
		$val = trim($_GET["search"]['value']);
		$cles = str_replace(' ','%', $val);
		$w = '';
		if($cles){
			$cles="%$cles%";
			$w = "and (mc.montant_cdf like '$cles' 
			or mc.montant_usd like '$cles' 
			or ci.code like '$cles' 
			or ci.libelle like '$cles' 
			or cf.code like '$cles' 
			or cf.libelle like '$cles' 
			or mc.libelle like '$cles'
			or demander_par like '$cles' 
			or date_mouv = '$val' ) ";
		}
		else $cle=1;
		$implode = implode(",",(count($mes_compte_ids)?$mes_compte_ids:[0]));
		$fromAll = "from mouvement_comptes mc
		inner join mouvement_cpte_utilises cu on cu.mouvement_compte_id=mc.id
		left join comptes ci on ci.id = cu.compte_initial
		left join comptes cf on cf.id = cu.compte_final
		-- inner join categorie_comptes cat on cat.id = c.categorie_compte_id
		-- inner join users u on u.id = mc.user_id
		-- inner join cpt_comptables ct on u.id = ct.user_id	
		left join cpt_secteurs s on s.id = mc.cpt_secteur_id	
		where mc.cpt_secteur_id in (".implode(",",(($f=$this->cpt_secteur_ids())?$f:[0])).")
		and (ci.ecole_id =$id_ecole or cf.ecole_id=$id_ecole )
		and (ci.id in ($implode) or cf.id in ($implode) )
		 ";
		
		$selectAllReq = " select count(*) total  $fromAll ";
		$count = \DB::select($selectAllReq);
		
		$countV = \DB::select($selectAllReq . " $w ");

		$req = "select mc.id, s.nom secteur,mc.date_mouv,cu.montant_cdf,cu.montant_usd,
		ci.code codei, ci.libelle libellei,
		cf.code codef, cf.libelle libellef,
		mc.libelle m_libelle,demander_par,cu.id cu_id
		$fromAll $w order by mc.date_mouv desc,mc.id desc
		limit $_GET[start],$_GET[length]";
		$data = \DB::select($req);
		$dataOk = [];
		$id=1;
		//echo $req;
		//dd($selectAllReq,$req);
		foreach($data as $e){
			$t = [];
			$t[]=$id++;
			$t[]=$e->date_mouv;
			$t[]=$e->m_libelle;
			$t[]=$e->codei.' '.$e->libellei;
			$t[]=$e->montant_cdf;
			$t[]=$e->montant_usd;
			$t[]=$e->codef.' '.$e->libellef;
			//$t[]=$e->demander_par;
			$t[]=$e->secteur;

			$t[]=route('cash.fiche.detail',['id'=>$e->id]);
			$t[]=route('mouvementcomptes.destroy',$e->id);
			//$t[]=$e->entree?'true':'false';
			$t[]=$e->id;
			$t[]=$e->cu_id;
			$dataOk[] = $t;
		}
		//dd($dataOk);
		return array(  
			"draw"                    =>     intval($_GET["draw"]),  
			"recordsTotal"          =>      $count[0]->total,  
			"recordsFiltered"     =>     $countV[0]->total,  
			"data"                    =>     $dataOk 
	   );
	}

	public function sortiee(Request $request){
		$_GET['page'] = 'tab_1';
		$categorieComptes = CategorieCompte::all();
		$date = $request->date_mouv??date('Y-m-d');
		$date1 = $request->date_mouv1??date('Y-m-d');
		//
		$mouvementcomptes = MouvementCompte::with('mouvementCpteUtilises.compteFinal.compte','mouvementCpteUtilises.compteInitial.compte','user.cptComptables')->whereIn('cpt_secteur_id',$this->cpt_secteur_ids());
		if($request->has('btn_liste_mouv') ){
			$_GET['page'] = 'tab_3';
			
			$mouvementcomptes = $mouvementcomptes->where("date_mouv",'>=',$date)->where("date_mouv",'<=',$date1);
		}
		else{// dd($_GET);
			$mouvementcomptes = $mouvementcomptes->where('date_mouv',$date);
		}
		$mouvementcomptes = $mouvementcomptes->get()->sortByDesc('id');
		// tous les secteurs ou travaille le comptable
		//$mouvementcomptes = $mouvementcomptes->whereHas('user.cptComptables',function($q) use($secteurs){
		//	return $q->whereIn('cpt_secteur_id',$secteurs);
		//});
		//dd($mouvementcomptes->toSql());
		
		$mouvementcompte = new MouvementCompte;
		$mouvementcompte->date_mouv = session('date_mouv');
		$mouvementcompte->compte_id = session('compte_id');
		
		$user_id = \Auth::user()->id;
		
		$users = $this->les_users(); 
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$compte = new Compte;
		$ids = $user?$user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray():[];
		$comptes = Compte::with('compte','categorieCompte')->whereIn('id',$ids)
		// ->whereHas('categorieCompte', function($q) {
			// $q->where('categorie', 'B. AUTRES ENCAISSEMENTS');
			// $q->orWhere('categorie', 'C. CHARGES');
			// $q->orWhere('categorie', 'D. AUTRES DECAISSEMENTS');
		// })		
		// ->orWhere('code','A9')
		->get();
		//dd($comptes);
		
				
		return $this->addUser($this->v_path.'sortie',compact('mouvementcomptes','categorieComptes','mouvementcompte','comptes','users','compte','date','date1','user'));
	}

	public function sortie(Request $request){
		$id_annee = Config::getIdAnnee();
		$id_ecole = Config::getEcoleId();
		
		$_GET['page'] = 'tab_1';
		$categorieComptes = CategorieCompte::all();
		$date = $request->date_mouv??date('Y-m-d');
		$date1 = $request->date_mouv1??date('Y-m-d');
		
		$user_id = \Auth::user()->id;
		$users = $this->les_users(); 
		// les ids des tous les utilisateur de l'école
		$mes_users_ids = $users->map(function($e,$k){return $e->id;})->toArray();
		
		//
		// on prend les mouvements faits par les utilisateurs de l'école
		$mouvementcomptes = MouvementCompte::with('mouvementCpteUtilises.compteFinal.compte','mouvementCpteUtilises.compteInitial.compte','user.cptComptables')
		->whereIn('cpt_secteur_id',$this->cpt_secteur_ids())
		->whereIn('user_id',$mes_users_ids);
		if($request->has('btn_liste_mouv') ){
			$_GET['page'] = 'tab_3';
			
			$mouvementcomptes = $mouvementcomptes->where("date_mouv",'>=',$date)->where("date_mouv",'<=',$date1);
		}
		else{// dd($_GET);
			$mouvementcomptes = $mouvementcomptes->where('date_mouv',$date);
		}
		$mouvementcomptes = $mouvementcomptes->get()->sortByDesc('id');
		
		// tous les secteurs ou travaille le comptable
		//$mouvementcomptes = $mouvementcomptes->whereHas('user.cptComptables',function($q) use($secteurs){
		//	return $q->whereIn('cpt_secteur_id',$secteurs);
		//});
		//dd($mouvementcomptes->toSql());
		
		$mouvementcompte = new MouvementCompte;
		$mouvementcompte->date_mouv = session('date_mouv');
		$mouvementcompte->compte_id = session('compte_id');
		
		$user_id = \Auth::user()->id;
		
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$compte = new Compte;
		$ids = $user?$user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray():[];
		$comptes = Compte::with('compte','categorieCompte')->whereIn('id',$ids)
		// ->whereHas('categorieCompte', function($q) {
			// $q->where('categorie', 'B. AUTRES ENCAISSEMENTS');
			// $q->orWhere('categorie', 'C. CHARGES');
			// $q->orWhere('categorie', 'D. AUTRES DECAISSEMENTS');
		// })		
		// ->orWhere('code','A9')
		->get();
		//dd($comptes);
		
				
		return $this->addUser($this->v_path.'sortie',compact('mouvementcomptes','categorieComptes','mouvementcompte','comptes','users','compte','date','date1','user'));
	}


	public function assoc_user_secteur(Request $req){
		$idu = $req->user_id;
		foreach($req->cpt_secteur_id as $id)
			CptComptable::firstOrCreate(['user_id'=>$idu,'cpt_secteur_id'=>$id],[]);
		return redirect()->back();//route('cash.sortie');
	}
	 
	public function fiche_detail($id){
		$mouvementcompte = MouvementCompte::with('compte.categorieCompte','cashSuivis.cashSuiviPieces','mouvementComptePieces')->find($id);


		return $this->addUser($this->v_path.'sortie_detail',compact('mouvementcompte'));
	}
	
	public function fiche_add_piece(Request $request){
		
		if($request->mouvement_compte_id and $request->add){
			foreach(request()->file("images") as $i=>$file){
				$datas = [
					'mouvement_compte_id'=>$request->mouvement_compte_id,
					'piece'=>'-'
				];
				$p = MouvementComptePiece::create($datas);
				$p->piece = chado_saveFileData('public/mouvementcomptepiece/piece/',$file, $p->id);
				$p->save();
			}
		}
		else if($request->mouvement_compte_piece_id ){
			$p = MouvementComptePiece::Find($request->mouvement_compte_piece_id);
			$path = public_path('storage').'/mouvementcomptepiece/piece/'.$p->piece;
			// $path = 'storage/mouvementcomptepiece/piece/'.$p->piece;

			chown($path, 666);

			if (file_exists($path) and unlink($path)) {
				//dd("partie");
			} else {
				//dd("fail");
			}
			MouvementComptePiece::destroy($request->mouvement_compte_piece_id);
		}
		my_flash("Operation bien faite ");
		return redirect()->back();
	}
	
	public function fiche_compte_init_final_save(Request $request){
				
		// $uploadedFile = request()->file('pieces');
		// dd($uploadedFile);
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		$montant = ($request->montant_usd??0) * $taux + $request->montant_cdf;
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur')->find($user_id);
		$secteur_id = $user->cptComptables->count()==1?$user->cptComptables->first()->cpt_secteur_id:$request->cpt_secteur_id;
		$datas = [
			'montant'=>$montant?$montant:'',
			'montant_usd'=>$request->montant_usd,
			'montant_cdf'=>$request->montant_cdf,
			'taux'=>$taux,
			//'user_id'=>$user_id,
			//'cpt_secteur_id'=>$secteur_id,
			'compte_initial'=>$request->compte_initial, 
			'compte_final'=>$request->compte_final, 
			'mouvement_compte_id'=>$request->mouvement_compte_id
		];
		$rules = [
			'montant'=>'required',
			'montant_usd'=>'',
			'montant_cdf'=>'',
			'taux'=>'',
			//'user_id'=>'required',
			//'cpt_secteur_id'=>'',
			'compte_initial'=>'', 
			'compte_final'=>'', 
			'mouvement_compte_id'=>'required'
		];
		if(!$request->compte_final and !$request->compte_initial)
			$rules['compte']='required';
		
		$result = AjaxValidator::validate($datas,$rules);
		if($result!==true)
			return $result;
		
		//dd($result);
		return MouvementCpteUtilise::create($datas);
	}
	
	public function fiche_save(Request $request){
		
		if(!request()->file("pieces") and ($request->faire_suivi and $request->tache and ($request->s_montant_cdf or $request->s_montant_usd))){
			my_flash("Vous n'avez indiquez aucun document pour le suivi","danger");
			return redirect()->route('cash.sortie');
		}
		
		
		// $uploadedFile = request()->file('pieces');
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		$montant = ($request->montant_usd??0) * $taux + $request->montant_cdf;
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur')->find($user_id);
		$secteur_id = $user->cptComptables->count()==1?$user->cptComptables->first()->cpt_secteur_id:$request->cpt_secteur_id;
		// dd($user,$secteur_id);
		$datas = [
			'libelle'=>$request->motif,
			'demander_par'=>$request->demander_par,
			'autoriser_par'=>$request->autoriser_par,
			'date_mouv'=>$request->date_mouv,
			'ms_annee_scolaire_id'=>\App\Config::getIdAnnee(),
			'description_mouv'=>$request->description_mouv,
			'faire_suivi'=>$request->faire_suivi,
			'user_id'=>$user_id,
			'cpt_secteur_id'=>$secteur_id,
		];
		$rules = [
			'libelle'=>'required',
			'demander_par'=>'',
			'autoriser_par'=>'',
			'date_mouv'=>'required',
			'ms_annee_scolaire_id'=>'required',
			'description_mouv'=>'',
			'faire_suivi'=>'',
			'user_id'=>'required',
			'cpt_secteur_id'=>'',
		];
		\Validator::make($datas,$rules)->validate();
		$datas_c = [
			'montant'=>$montant?$montant:'',
			'montant_usd'=>$request->montant_usd,
			'montant_cdf'=>$request->montant_cdf,
			'taux'=>$taux,
			//'user_id'=>$user_id,
			//'cpt_secteur_id'=>$secteur_id,
			'compte_initial'=>$request->compte_initial, 
			'compte_final'=>$request->compte_final, 
		];
		$rules_c = [
			'montant'=>'required',
			'montant_usd'=>'',
			'montant_cdf'=>'',
			'taux'=>'',
			//'user_id'=>'required',
			//'cpt_secteur_id'=>'',
			'compte_initial'=>'', 
			'compte_final'=>'', 
		];
		if(!$request->compte_final and !$request->compte_initial)
			$rules['compte']='required';
		\Validator::make($datas_c,$rules_c)->validate();
		
		$f = MouvementCompte::create($datas);

		$datas_c['mouvement_compte_id'] = $f->id;
		MouvementCpteUtilise::create($datas_c);

		// enregistrement des documents en rapport avec le mouvement
		if(request()->file("images") and is_array(request()->file("images")) ){
			foreach(request()->file("images") as $i=>$file){
				$datas = [
					'mouvement_compte_id'=>$f->id,
					'piece'=>'-'
				];
				$p = MouvementComptePiece::create($datas);
				$p->piece = chado_saveFileData('public/mouvementcomptepiece/piece/',$file, $p->id);
				$p->save();
			}
		}

		if($request->faire_suivi and $request->tache and ($request->s_montant_cdf or $request->s_montant_usd)){
			$datas = [
			'mouvement_compte_id'=>$f->id,
				'tache'=>$request->tache,
				'montant_cdf'=>$request->s_montant_cdf,
				'montant_usd'=>$request->s_montant_usd,
				'date_suivi'=>($request->date_suivi??''),
			];
			$cashsuivi = CashSuivi::create($datas);

			//enregistrement des images
			foreach(request()->file("pieces") as $i=>$file){
				$datas = [
					'cash_suivi_id'=>$cashsuivi->id,
					'titre'=>$request["piece_$i"],
				];
				$cashsuivipiece = CashSuiviPiece::create($datas);
				$cashsuivipiece->piece = chado_saveFileData('public/cashsuivipiece/piece/',$file, $cashsuivipiece->id);
				$cashsuivipiece->save();
			}
		}
		session(['date_mouv'=>$request->date_mouv,
		'compte_id'=>$request->compte_id]);
		my_flash("Enregistrement effecté avec succès");
		return redirect()->back();// route('cash.sortie');
	}

	public function fiche_add_suivi(Request $request){
		
		$datas = [
			'mouvement_compte_id'=>$request->mouvement_compte_id,
			'tache'=>$request->tache,
			'montant_cdf'=>$request->montant_cdf,
			'montant_usd'=>$request->montant_usd,
			'date_suivi'=>$request->date_suivi??date("Y-m-d"),
		];
		$rules = [
		'mouvement_compte_id'=>'required',
			'tache'=>'required',
			'montant_cdf'=>'',
			'montant_usd'=>'',
			'date_suivi'=>'required',
		];
		\Validator::make($datas,$rules)->validate();
		$cashsuivi = CashSuivi::create($datas);
		
		//enregistrement des images
		foreach(request()->file("pieces") as $i=>$file){
			$datas = [
				'cash_suivi_id'=>$cashsuivi->id,
				'titre'=>$request["piece_$i"],
			];
			$cashsuivipiece = CashSuiviPiece::create($datas);
			$cashsuivipiece->piece = chado_saveFileData('public/cashsuivipiece/piece/',$file, $cashsuivipiece->id);
			$cashsuivipiece->save();
			
		}		
		flash("Enregistrement effecté avec succès");
			
			
		return redirect()->route('cash.fiche.detail',['id'=>$request->mouvement_compte_id]);
	}
	
	public function rapport(){
		// $cashfichesorties = CashFicheSortie::all();
		$total_demande = 0; 
		$total_demande_cdf = 0; 
		$total_demande_usd = 0; 
		$total_demande_asuiv = 0; 
		$total_demande_asuiv_cdf = 0; 
		$total_demande_asuiv_usd = 0; 
		$total_justif_usd = 0;
		$total_justif_cdf = 0;
		$a_suivre = 0;$monnaie="";
		
		$mouvements = MouvementCompte::with('compte.categorieCompte','cashSuivis.cashSuiviPieces','user.cptComptables')
		->whereHas("compte.categorieCompte",function($q){return $q->where('categorie','C. CHARGES'); })
		->whereIn('cpt_secteur_id',$this->cpt_secteur_ids())
		->get();
		
		//$cashfichesorties = CashFicheSortie::with("cashSuivis","cashCategorie")->get();
		
		
		
		$MoisMouvementcompte = MouvementCompte::with('user.cptComptables','cashSuivis',"compte.categorieCompte")
		->whereHas("compte.categorieCompte",function($q){return $q->where('categorie','C. CHARGES'); })
		->whereHas('user.cptComptables',function($q) use($secteurs){
			return $q->whereIn('cpt_secteur_id',$secteurs);
		})
		->get()
		/* ->filter(function($p,$k) use($mp_type_frais_id){,categorie
			// dd($p,$k);
			$ok = ($p->mpFraisClasse->mpFrais)??false;
			if($ok)
				return in_array($p->mpFraisClasse->mpFrais->mp_type_frais_id, $mp_type_frais_id );
			return false;
			}) */
		->groupBy(function($d,$k){ return date("m", strtotime($d->date_mouv)); });
		// $taux = TauxChange::where(compact('ecole_id'))->first();
		// $taux = $taux?$taux->usd_cdf:2000;
		foreach($mouvements as $f){
			$monnaie = $f->devise;
			$total_demande+= $f->montant;
			$total_demande_cdf+= $f->montant_cdf;
			$total_demande_usd+= $f->montant_usd;
			if($f->faire_suivi){
				$total_demande_asuiv_cdf += $f->montant_cdf; 
				$total_demande_asuiv_usd += $f->montant_usd; 
				$total_demande_asuiv+= $f->montant;
			}
				
			$total_justif_cdf += $f->cashSuivis->sum('montant_cdf');
			$total_justif_usd += $f->cashSuivis->sum('montant_usd');
		}
		$a_suivre_cdf = $total_demande_asuiv_cdf - $total_justif_cdf;
		$a_suivre_usd = $total_demande_asuiv_usd - $total_justif_usd;

		return $this->addUser($this->v_path.'rapport',compact('MoisMouvementcompte','mouvements'
		,'monnaie','a_suivre_usd','total_demande_usd','total_justif_usd','a_suivre_cdf','total_demande_cdf','total_justif_cdf'));
	
	}
	
	public function rapport_mensuel_detail_compte(Request $request){
		$id = $request->id;
		$debut = $request->debut;
		$fin = $request->fin;

		$rapport = Compte::with("mouvementComptes.user.cptComptables")->where('id',$id)
		// ->orWhereHas('mouvementComptes', function($q) use($mois){
		// 	$q->whereMonth('date_mouv', $mois);
		// })
		->get()->first();
		
		$secteurs = $this->cpt_secteur_ids();
		$mouvementcomptes = $rapport->mouvementComptes->whereIn('cpt_secteur_id',$secteurs)->sortBy('date_mouv');
		//dd($mouvementcomptes,$rapport);

		return view($this->v_path.'_detail_charge_mensuel', compact('mouvementcomptes','debut','fin') );
		
	}


	public function rapport_mensuel_detail_compte_suivi(Request $request){
		$id = $request->id;
		
		$mouvementcompte = MouvementCompte::with('compte.categorieCompte','cashSuivis.cashSuiviPieces')->find($id);
		return view($this->v_path.'_detail_mouvement', compact('mouvementcompte') );
		
	}
		
	public function rapport_mensuel(Request $request){
		$date_debut = $request->date_debut ?? date("Y-m-01");
		$date_fin = $request->date_fin ?? date("Y-m-d");
		$mois = $request->mois_rapport ?? date("m");
		$mois_rapport = $mois;
		
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$id_cpt_users = $user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray();
		
		$ids = $this->cpt_secteur_ids();
		$compteAsuivre = CptCompteAsuivre::whereIn('cpt_secteur_id',$ids)->get()->groupBy('cpt_secteur_id');
		
		$TAB_RAPPORT = [];
		foreach ($ids  as $sec ) {
			$rap = $this->new_rapport_periodique_cpte_ordinaire($sec,$date_debut,$date_fin);
			// si le secteur en cours est l'ecole
			if($sec==3){
				$mpFraisPaiements = MpFraisPaiement::with('compte','mpFraisClasse')->whereIn('compte_id',$id_cpt_users)->whereBetween('payer_le', [$date_debut,$date_fin])
				->get()
				->groupBy(function($d,$k){ return $d->compte->libelle; })
				->sortKeys();
				if($mpFraisPaiements->count())
					$rap['frais'] = $mpFraisPaiements;
			}
			$TAB_RAPPORT[] = $rap;
			
		}
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		
		$data = compact('compteAsuivre','date_debut','mois_rapport','taux','date_fin','TAB_RAPPORT');
		if($request->compta)
			return view('os.rapport_mensuel',$data);
		return $this->addUser($this->v_path.'rapport_mensuel',$data);
		
		
	}

		
	public function rapport_des_depenses_annuel_mois_par_mois(Request $request){
		$date_debut = $request->date_debut ?? date("Y-m-01");
		$date_fin = $request->date_fin ?? date("Y-m-d");
		
		$data = compact('date_debut','date_fin');
		if(!$date_debut)
		    return $this->addUser($this->v_path.'rapport_sortie_mois_par_mois',$data);
		
		$mois = "";
		$mois_rapport = $mois;
		
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$id_cpt_users = $user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray();
		
		$ids = $this->cpt_secteur_ids();
		$compteAsuivre = CptCompteAsuivre::whereIn('cpt_secteur_id',$ids)->get()->groupBy('cpt_secteur_id');
		
		// mois 
		//$date_debut = "2023-11-23";
		//$date_fin = "2024-07-02";
		$dd = $date_debut;
		$df = date("Y-m-t", strtotime($dd));
		$TAB_RAPPORT = [];
		$grille_mois = [];
		$default_val_mois = ['usd'=>0,'cdf'=>0,'tot_cdf'=>0];
		// la date fin df progress en prenant à chaque fois la date de la fin du mois et celle-ci doit rester inf à la date fin date_fin
		for(;$date_fin > $df; ){
    		$grille_mois[$df] = $default_val_mois;
		    foreach ($ids  as $sec ) {
    			$TAB_RAPPORT[$df] = $this->new_rapport_periodique_cpte_ordinaire($sec,$dd,$df);
    		}
    		$dd = date("Y-m-d", strtotime($df . ' +1 day'));
		    $df = date("Y-m-t", strtotime($dd));
		}
		// si nous sommes sortie alors que la date_fin est != de la df, donc le dernier tour ne s'est pas accompli il faut alors
		// refaire la boucle en considérant df = date_fin
		$df = $date_fin;
		foreach ($ids  as $sec ) {
			$TAB_RAPPORT[$df] = $this->new_rapport_periodique_cpte_ordinaire($sec,$dd,$df);
		}
		$grille_mois[$df]=$default_val_mois;
		$grille_mois["TOTAUX"]=$default_val_mois;
		
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		
		$data = compact('compteAsuivre','date_debut','mois_rapport','taux','date_fin','TAB_RAPPORT','grille_mois');
		
		return $this->addUser($this->v_path.'rapport_sortie_mois_par_mois',$data);
		
		
	}

	
	public function rapport_journalier(Request $request){
		$total_demande = 0; $total_demande_asuiv = 0; $total_justif = 0;$a_suivre = 0;$monnaie="";
		
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$id_cpt_users = $user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray();
		
		$ids = $this->cpt_secteur_ids();
		$date = $request->date ?? date("Y-m-d");
		$TAB_RAPPORT = [];
		foreach ($ids  as $sec ) {
			$rap = $this->new_rapport_periodique_cpte_ordinaire($sec,$date);
			// si le secteur en cours est l'ecole
			if($sec==3){
				$mpFraisPaiements = MpFraisPaiement::with('compte')
				->whereIn('compte_id',$id_cpt_users)
				->where('payer_le', $date)
				->get()
				->groupBy(function($d,$k){ return $d->compte->libelle; })
				->sortKeys();
				if($mpFraisPaiements->count())
					$rap['frais'] = $mpFraisPaiements;
			}
			$TAB_RAPPORT[] = $rap;
			
		}
		$ids = $this->cpt_secteur_ids();
		$compteAsuivre = CptCompteAsuivre::whereIn('cpt_secteur_id',$ids)->get()->groupBy('cpt_secteur_id');
		// dd($ids,$compteAsuivre);
		
		//dd($TAB_RAPPORT);
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		
		$data = compact('compteAsuivre','date','taux','TAB_RAPPORT');
		if($request->compta)
			return view('os.rapport_journalier',$data);
		
		return $this->addUser($this->v_path.'rapport_journalier',$data);
	}

	public function voir_grand_livre_individuel_sous_compte($compte_id,$ids,$MouvementRetour,$ms_annee_scolaire_id=0,$le_compte_parent_id=0){

		$compte = Compte::find($compte_id);
		// on ne doit pas prendre les mouvement fait vers les comptes fils; car ils seront pris a partir des enfants
		$sousComptes = Compte::where('compte_parent_id',$compte_id)->get();
		$sous_compte_id = $sousComptes->map(function ($item, $key) {
			return $item->id;
		})->toArray();
		//dd($sousComptes);
		
		// on prend les entrees du compte principal sauf  les transferts du compte principal vers le compte enfant
		$req = MouvementCpteUtilise::with('mouvementCompte.user.cptComptables','compteFinal','compteInitial')
		->whereHas('mouvementCompte',function($r)use($ids,$ms_annee_scolaire_id ){
			return $r->whereIn('cpt_secteur_id',$ids)
			->where('ms_annee_scolaire_id',$ms_annee_scolaire_id);
		})
		->where('compte_final',$compte_id)
		//->whereNotIn('compte_final',$sous_compte_id)
		->whereRaw(count($sous_compte_id)?(' (compte_initial is null or compte_initial not in ('. implode(',',$sous_compte_id) .') )'):' 1=1 ')
		// on prends les sorties du compte principal sauf les transferts du compte principal vers le compte enfant
		->orWhereHas('mouvementCompte',function($r)use($ids,$ms_annee_scolaire_id ){
			return $r->whereIn('cpt_secteur_id',$ids)
			->where('ms_annee_scolaire_id',$ms_annee_scolaire_id);
		})
		->where('compte_initial',$compte_id)
		//->whereNotIn('compte_initial',$sous_compte_id)
		->whereRaw(count($sous_compte_id)?(' (compte_final is null or compte_final not in ('. implode(',',$sous_compte_id) .') )'):' 1=1 ');
		
		$mouvements = $req->get();
		
		
		//dd($mouvements->filter(function ($value, $key)  {
		//	return $value->compte_final==88 and $value->compte_initial==3;
		//}) ,$sous_compte_id);
		/*$mouvements = $mouvements->map(function ($mouv) {			
			$mouv->setAttribute('parents_ids' , ["initial"=>[],"final"=>[]]);
			return $mouv;
		});*/
		foreach($mouvements as $f){
			$f->setAttribute('parents_ids' , ["initial"=>[],"final"=>[]]);
			if($f->compte_initial== $f->compte_final )continue;
			else if($f->compte_initial==$compte_id ){
				$f->comtpe_final = null;
				$f->comtpeFinal = null;
				if($le_compte_parent_id){
					$t = $f->parents_ids;
					array_push($t["initial"],$le_compte_parent_id);
					$f->setAttribute('parents_ids' ,$t);
			 	}
			}
			else if($f->comtpe_final==$compte_id ){
				$f->compte_initial = null;
				$f->compteInitial = null;
				if($le_compte_parent_id){
					$t = $f->parents_ids;
					array_push($t["final"],$le_compte_parent_id);
					$f->setAttribute('parents_ids' ,$t);
			 	}
			}
			$MouvementRetour->prepend($f);
		}
		// si c'est un compte recette
		if($compte->categorieCompte->id==1 or $compte->categorieCompte->id==2){
			$mpFraisPaiements = MpFraisPaiement::with('compte','mpFraisClasse')
			->whereHas('mpFraisClasse',function($r)use($ms_annee_scolaire_id){
				return $r->where('ms_annee_scolaire_id',$ms_annee_scolaire_id);
			})			
			->where('compte_id',$compte_id)
				->get()
				->groupBy('payer_le');
			// dd($mpFraisPaiements->get("2023-08-25"));
			if($mpFraisPaiements->count()){
				$cpts = collect([]);
				foreach($mpFraisPaiements as $d=>$f){
					$m = new MouvementCompte();
					$cpt = new MouvementCpteUtilise();
					if($le_compte_parent_id){
						$cpt->setAttribute('parents_ids' ,["initial"=>[$le_compte_parent_id],"final"=>[]]);
					}
					else $cpt->setAttribute('parents_ids' ,["initial"=>[],"final"=>[]]);
					// if($compte->id==50 AND $d=="2023-02-24")
					//	dd($le_compte_parent_id,$cpt);
					//$m->parents_ids = ["initial"=>[],"final"=>[]];
					//$m->setAttribute('parents_ids', ["initial"=>[],"final"=>[]]);
					$m->date_mouv = $d;
					$m->libelle = "FRAIS: ".$compte->libelle;
					$cpt->montant = $f->sum('montant_payer');
					$cpt->montant_usd = $f->sum('montant_payer_usd');
					$cpt->montant_cdf = $f->sum('montant_payer_cdf');
					$cpt->mouvementCompte = $m;
					
					$cpt->compte_final = $compte->id;
					$cpt->compteFinal = $compte;
					$cpt->comtpe_initial = null;
					//$cpts[] = $cpt;
					$MouvementRetour->prepend($cpt);
				} 
			}
		}
		//dd($MouvementRetour,$MouvementRetour->first(),$MouvementRetour->last(),$compte,$compte_id);
		//dd($compte,$mouvements,$mouvements->first(),$mouvements->last());
		
		if($sousComptes->count()){
			foreach($sousComptes as $c){
				$MouvementRetour = $this->voir_grand_livre_individuel_sous_compte($c->id,$ids,$MouvementRetour,$ms_annee_scolaire_id,$compte_id);// on trouve le solde de chaque sous compte par recurssivite
			}
		}
		//dd($MouvementRetour->filter(function ($value, $key)  {
		//	return $value->compte_final==88 and $value->compte_initial==3;
		//}) );
		return $MouvementRetour;
		
	}
    private function les_users(){
        $id_ecole = Config::getEcoleId();
		
		return User::with('sysUserRoles')
		->whereHas('sysUserRoles',function($q)use($id_ecole){
			$q->where('ecole_id',$id_ecole);
			return $q;
		})->get();
    }
	public function voir_grand_livre_individuel(Request $request){
		$total_demande = 0; $total_demande_asuiv = 0; $total_justif = 0;$a_suivre = 0;$monnaie="";
		$compte_id = $request->code;
		$personnaliser_mois = $request->mois_personnaliser=="true";
		//dd($personnaliser_mois);
		$compte = Compte::find($compte_id);
		$user_id = \Auth::user()->id; 
		$mes_comptes = User::with('compteEtUsers.compte')->find(	$user_id)->compteEtUsers;
		
		$cpt_secteur_id = $this->cpt_secteur_ids();$request->secteur_id;//
		$ms_annee_scolaire_id= \App\Config::getIdAnnee();
		$mouvements = $this->voir_grand_livre_individuel_sous_compte($compte_id,[$cpt_secteur_id],collect([]),$ms_annee_scolaire_id);
		// dd($mouvements);
	
		$users = $this->les_users(); 
		
		$comptes = Compte::with('compte')->get();
		$secteur = CptSecteur::find($cpt_secteur_id);
		
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		// dd($user_id,$CompteEtUsers);
		$data = compact('personnaliser_mois','mouvements','users','compte','comptes','mes_comptes','taux','secteur');
		//dd($data);
		return $this->addUser($this->v_path.'_grand_livre',$data);
	}
	
	// AFFICHER L'ETAT D'UN COMPTE
	public function affiche_etat_compte(Request $request,$id=0,$sec=0){
		$d1 = $request->date1;
		$d2 = $request->date2??date('Y-m-d');
		return $this->trouver_letat_ducompte($d1,$d2,$id,$sec);
	}

	// FUNSIONNER DEUX COMPTE
	public function fussionner_les_mouvements_de_deux_compte(Request $request){
		$c2 = $request->compte_a_conserver;
		$cpte_a_effacer = $request->compte_a_effacer;
		
		MouvementCpteUtilise::whereIn('compte_initial',$cpte_a_effacer)->update(['compte_initial'=>$c2]);
		MouvementCpteUtilise::whereIn('compte_final',$cpte_a_effacer)->update(['compte_final'=>$c2]);
		return redirect()->back();
	}

	private function solde_compte_recette($d1,$d2,$id,$sec){
		$sold_cpt = ['sc_usd'=>0,'sc_cdf'=>0,'ssc_usd'=>0,'ssc_cdf'=>0,'sc'=>[]];
		
		$recette_frais = Compte::with(['mpFraisPaiements' => function ($q) use ($d1,$d2) {
			if($d1)$q->where('payer_le','>=',$d1);
			$q->where('payer_le','<=',$d2);
		}])->find($id);
		if($recette_frais and $recette_frais->mpFraisPaiements->count()){
			$sold_cpt['sc_cdf'] = $recette_frais->mpFraisPaiements->sum('montant_payer_cdf');
			$sold_cpt['sc_usd'] = $recette_frais->mpFraisPaiements->sum('montant_payer_usd');
		}
		$s = $this->solde_compte_ordinaire($d1,$d2,$id,$sec);
		$sold_cpt['sc_cdf'] += $s['sc_cdf'];
		$sold_cpt['sc_usd'] += $s['sc_usd'];
		//dd($d1,$d2,$recette_frais,$sold_cpt);
		return $sold_cpt;
	}
	
	private function new_rapport_periodique_cpte_ordinaire($sec,$date1,$date2=''){
		$secteur = CptSecteur::find($sec);
		$ecole_id = Config::getEcoleId();
		if($date2=='')
    		$operations = MouvementCpteUtilise::with('mouvementCompte','compteInitial','compteFinal')
    			->whereHas('compteInitial', function($q)use($ecole_id){
    				return $q->where('ecole_id',$ecole_id);
    			})->whereHas('mouvementCompte', function($q)use($date1,$sec){
        			$q->where('date_mouv', $date1)->where('cpt_secteur_id',$sec);
        		})
    			->orWhereHas('compteFinal', function($q)use($ecole_id){
    				return $q->where('ecole_id',$ecole_id);
    			})->whereHas('mouvementCompte', function($q)use($date1,$sec){
        			$q->where('date_mouv', $date1)->where('cpt_secteur_id',$sec);
        		})
    		->get();
		else
    		$operations = MouvementCpteUtilise::with('mouvementCompte','compteInitial','compteFinal')
        		->whereHas('compteInitial', function($q)use($ecole_id){
        				return $q->where('ecole_id',$ecole_id);
        		})->whereHas('mouvementCompte', function($q)use($date1,$date2,$sec){
        			$q->whereBetween('date_mouv', [$date1,$date2])->where('cpt_secteur_id',$sec);
        		})->orWhereHas('compteFinal', function($q)use($ecole_id){
        				return $q->where('ecole_id',$ecole_id);
        		})->whereHas('mouvementCompte', function($q)use($date1,$date2,$sec){
        			$q->whereBetween('date_mouv', [$date1,$date2])->where('cpt_secteur_id',$sec);
        		})
    		->get();
		
		
		// dd($operations);
		$sold_cpt = [];
		if($operations){
			$sold_cpt['s_cdf'] = $operations->sum(function ($c){return $c->compteInitial->montant_cdf??0;});
			$sold_cpt['s_usd'] = $operations->sum(function ($c){return $c->compteInitial->montant_usd??0;});
			$sold_cpt['e_cdf'] = $operations->sum(function ($c){return $c->compteFinal->montant_cdf??0;});
			$sold_cpt['e_usd'] = $operations->sum(function ($c){return $c->compteFinal->montant_usd??0;});
		}
		
		return compact('sold_cpt','operations','secteur');
	}
	
	private function solde_compte_ordinaire($d1,$d2,$id,$sec){
		// compte utilisees lors dun mouvement (soit a l'entree soit a la sortie); on prend toutes les operations sans tenir compte de la date ou du secteur
		$operations = MouvementCpteUtilise::with('mouvementCompte')
		->whereHas('mouvementCompte',function($q)use($d1,$d2,$sec){
			if($d1)
				$q->whereBetween('date_mouv', [$d1,$d2])->where('cpt_secteur_id',$sec);
			else $q->where('date_mouv','<=', $d2)->where('cpt_secteur_id',$sec);
			return $q;
		})
		->where('compte_initial',$id)
		->orWhere('compte_final',$id)
		->whereHas('mouvementCompte',function($q)use($d1,$d2,$sec){
			if($d1)
				$q->whereBetween('date_mouv', [$d1,$d2])->where('cpt_secteur_id',$sec);
			else $q->where('date_mouv','<=', $d2)->where('cpt_secteur_id',$sec);
			return $q;
		});
		// dd($operations->toSql());
		$operations = $operations->get();
		$sold_cpt = ['sc_usd'=>0,'sc_cdf'=>0,'ssc_usd'=>0,'ssc_cdf'=>0,'sc'=>[]];
		// on parcourt toutes les operations et on verifie le secteur avant de considerer le montant sera soit une entree soit une sortie
		// dd($operations); 
		//if($operations->count())
		// and (!$d1 or $cu->mouvementCompte->date_mouv >= $d1) and $cu->mouvementCompte->date_mouv <= $d2
		foreach($operations as $cu){
			/* if($cu and $cu->mouvementCompte->count()){
				$sold_cpt['sc_cdf'] = $cu->mouvementCompte->sum('montant_cdf');
				$sold_cpt['sc_usd'] = $cu->mouvementCompte->sum('montant_usd');
			} */
			if($cu->mouvementCompte and $cu->mouvementCompte->cpt_secteur_id==$sec  ){
				// les sorties
				if($cu->compte_initial==$id){
					$sold_cpt['sc_cdf'] -= $cu->montant_cdf;
					$sold_cpt['sc_usd'] -= $cu->montant_usd;
				}
				// les entrees
				if($cu->compte_final==$id){
					$sold_cpt['sc_cdf'] += $cu->montant_cdf;
					$sold_cpt['sc_usd'] += $cu->montant_usd;
				}
			}
		}
		return $sold_cpt;
	}
	
	public function trouver_letat_ducompte($d1,$d2,$id=0,$sec=0){
		$compte = Compte::with('categorieCompte')->find($id);
		if(!$compte)
			return ['usd'=>0,'cdf'=>0,'sc_usd'=>0,'sc_cdf'=>0,'ssc_usd'=>0,'ssc_cdf'=>0,'sc'=>[],'compte'=>'$compte->libelle'];
		
		if($compte->categorieCompte->id==1)
			$sold_cpt = $this->solde_compte_recette($d1,$d2,$id,$sec);
		else $sold_cpt = $this->solde_compte_ordinaire($d1,$d2,$id,$sec);
		$sold_cpt['compte'] = $compte->libelle;		
		// le solde de tous les sous comptes
		// on trouve tous les sous comptes et on va demander le solde de chacun
		$sousComptes = Compte::where('compte_parent_id',$id)->get();
		if($sousComptes->count()){
			foreach($sousComptes as $c){
				$sold_cpt['sc'][] = $c->id;	
				$s = $this->trouver_letat_ducompte($d1,$d2,$c->id,$sec);// on trouve le solde de chaque sous compte par recurssivite
				$sold_cpt['ssc_usd']+=$s['usd'];
				$sold_cpt['ssc_cdf']+=$s['cdf'];
			}
		}
		$sold_cpt['usd'] = $sold_cpt['sc_usd'] + $sold_cpt['ssc_usd'];
		$sold_cpt['cdf'] = $sold_cpt['sc_cdf'] + $sold_cpt['ssc_cdf'];
		return $sold_cpt;
	}

	public function choisir_compte_atransferer(Request $request){
		$fond = false;
		// dd($request);
		$ecole_id = Config::getEcoleId();
		if($request->has('btn_transfere')){
			$taux = TauxChange::where(compact('ecole_id'))->first();
			$taux = $taux?$taux->usd_cdf:2000;

			$date = $request->date_mouv;
			$cpt1 = $request->compte_initial;
			$cpt2 = $request->compte_final;
			$secteur_id = $request->cpt_secteur_id;
			$montant_cdf = $request->montant_cdf??-1;
			$montant_usd = $request->montant_usd??-1;
			if($montant_usd!=-1 and $montant_cdf==-1)
				$montant_cdf=0;
			if($montant_cdf!=-1 and $montant_usd==-1)
				$montant_usd=0;

			$motif = $request->motif;
			$reste = ['r_cdf'=>$montant_cdf,'r_usd'=> $montant_usd];


			/*$fond = $this->transferer_largent($date,$cpt1,$cpt2,$secteur_id,$reste,0, $motif);
			// $fond['montant_usd']=$montant_usd;
			// $fond['montant_cdf']=$montant_cdf;
			$mnt_1 = ($montant_usd*$taux)+$montant_cdf;
			$mnt_2 = ($fond['sc_usd']*$taux)+$fond['sc_cdf'];
			if($mnt_1==$mnt_2 or ($fond['r_usd']==-1 and $fond['r_cdf']==-1))
				my_flash("TRANSFERT EFFECTUE AVEC SUCCES EN TOTALITE<br>".chiffre($fond['sc_usd'])."$ ET ".chiffre($fond['sc_cdf'])."Fc  ");
			else my_flash("TRANSFERT INACHEVE ".chiffre($mnt_2)."Fc /".chiffre($mnt_1)."Fc
			 (transfere) <br> 
			 SOIENT ".chiffre($fond['sc_usd'])."$ ET ".chiffre($fond['sc_cdf'])."Fc / ".chiffre($montant_usd)."$ ET ".chiffre($montant_cdf)."Fc","warning");
			*/


			// TRANSFERT DES FONDS SANS VERIFICATION
			$this->transferer_largent_sans_verification($date,$cpt1,$cpt2,$secteur_id,$reste,0, $motif);
			my_flash("TRANSFERT EFFECTUE AVEC SUCCES ");
			// =================================================


			 //session()->flash('notification.fond',$fond);
			return redirect()->route('cash.sortie');
		}
		$user_id = \Auth::user()->id;
		$users = $this->les_users(); 
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		$compte = new Compte;
		$ids = $user->compteEtUsers->map(function($e,$k){return $e->compte_id;})->toArray();
		$comptes = Compte::with('compte','categorieCompte')->whereIn('id',$ids)->get();
		
		$ids = $this->cpt_secteur_ids();
		$compteAsuivre = CptCompteAsuivre::with('cptSecteur')->whereIn('cpt_secteur_id',$ids)->get()->groupBy('cpt_secteur_id');
		
		return $this->addUser($this->v_path.'transfert_fond',compact('fond','compteAsuivre','comptes','users','compte','user'));
	}

	private function transferer_largent_sans_verification($date,$cpt1,$cpt2,$secteur_id=0,$reste=[],$mouv_id=0,$motif=null){
		$user_id = \Auth::user()->id;
		// transferet d'argent du compte
		$reste_a_trans=$reste;
		$ecole_id = Config::getEcoleId();
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;
		$compte1 = Compte::with('categorieCompte')->find($cpt1);
		$compte2 = Compte::with('categorieCompte')->find($cpt2);
		$datas = [
			'libelle'=>$motif??("TRANSFERT FOND ".$compte1->libelle),
			'date_mouv'=>$date,
			'ms_annee_scolaire_id'=>\App\Config::getIdAnnee(),
			'description_mouv'=>"TRANFERT DES FOND DU COMPTE ET SOUS COMPTE DE ".$compte1->libelle." VERS (".$compte2->libelle.")  ",
			'faire_suivi'=>0,
			'user_id'=>$user_id,
			'cpt_secteur_id'=>$secteur_id,
		];
		$mouvement = MouvementCompte::create($datas);
		$mouv_id = $mouvement->id;

		if($mntt = ($reste['r_cdf']+($reste['r_usd']*$taux))){
			$datas_c = [
				'montant'=>$mntt,
				'montant_usd'=>$reste['r_usd'],
				'montant_cdf'=>$reste['r_cdf'],
				'taux'=>$taux,
				'compte_initial'=>$cpt1,
				'compte_final'=>$cpt2,
				'mouvement_compte_id' => $mouv_id, 
			];
			// dd($datas_c,$sold_cpt);
			MouvementCpteUtilise::create($datas_c);
		}
	}

	private function transferer_largent($date,$cpt1,$cpt2,$secteur_id=0,$reste=[],$mouv_id=0,$motif=null){
		$sold_cpt = ['sc_cdf'=>0,'sc_usd'=> 0];
		$reste_a_trans=$reste;
		if(($reste_a_trans['r_usd']+$reste_a_trans['r_cdf']) == 0) {// si le reste a transferer est deja a 0
			$sold_cpt['r_cdf'] = $reste_a_trans['r_cdf'];
			$sold_cpt['r_usd'] = $reste_a_trans['r_usd'];
			return $sold_cpt;
		}
		// $date = date('Y-m-d');
		
		$compte1 = Compte::with('categorieCompte')->find($cpt1);
		$compte2 = Compte::with('categorieCompte')->find($cpt2);
		
		if($compte1->categorieCompte->id==1){
			$sold_cpt = $this->trouver_letat_ducompte('',$date,$cpt1,$secteur_id);
			$sold_cpt['sc_cdf'] = $sold_cpt['cdf'];
			$sold_cpt['sc_usd'] = $sold_cpt['usd'];
		}
		else{
			$sold_cpt = $this->trouver_letat_ducompte('',$date,$cpt1,$secteur_id);
			$sold_cpt['sc_cdf'] = $sold_cpt['cdf'];
			$sold_cpt['sc_usd'] = $sold_cpt['usd'];
		}
		// dd( $this->solde_compte_ordinaire('',$date,$cpt1,$secteur_id) ,$this->trouver_letat_ducompte('',$date,$cpt1,$secteur_id));

		$user_id = \Auth::user()->id;
		$ecole_id = Config::getEcoleId();
		// transferet d'argent du compte
		$taux = TauxChange::where(compact('ecole_id'))->first();
		$taux = $taux?$taux->usd_cdf:2000;

		$cash_usd_dispo = $cash_cdf_dispo = false;
		// on verifie si les solde sont positif
		if($sold_cpt['sc_usd']<0 or $sold_cpt['sc_cdf']<0  ){
			// si les cdf sont negatifs alors les usd doivent pouvoir couvrir
			if($sold_cpt['sc_cdf']<0){
				$change_usd = $sold_cpt['sc_cdf']/$taux;
				$cash_usd_dispo = $change_usd < $sold_cpt['sc_usd'];
				$sold_cpt['sc_cdf'] = 0;
				$sold_cpt['sc_usd'] -= $change_usd;
			}
			// sinon si les usd sont negatif alors les francs doivent couvrir
			else if($sold_cpt['sc_usd']<0){
				$change_cdf = $sold_cpt['sc_usd']*$taux;
				$cash_cdf_dispo = $change_cdf < $sold_cpt['sc_cdf'];
				$sold_cpt['sc_usd'] = 0;
				$sold_cpt['sc_cdf'] -= $change_cdf;
			}
		}
		else $cash_usd_dispo = $cash_cdf_dispo = true;
		// si l'un des cashs est dispo
		
		if($cash_cdf_dispo or $cash_usd_dispo){
			if($reste_a_trans['r_usd']!=-1 and $reste_a_trans['r_cdf']!=-1){
				// le fond a retirer est sup au cash en usd
				if($reste_a_trans['r_usd'] >= $sold_cpt['sc_usd']){
					$reste_a_trans['r_usd'] -= $sold_cpt['sc_usd'];
				}
				else{
					$sold_cpt['sc_usd'] = $reste_a_trans['r_usd'];
					$reste_a_trans['r_usd']=0;
				}
				// le fond a retirer est sup au cash en cdf
				if($reste_a_trans['r_cdf'] >= $sold_cpt['sc_cdf']){
					$reste_a_trans['r_cdf'] -= $sold_cpt['sc_cdf'];
				}
				else{
					$sold_cpt['sc_cdf'] = $reste_a_trans['r_cdf'];
					$reste_a_trans['r_cdf']=0;
				}
			}
			//dd( $reste_a_trans ,$sold_cpt);
			if($mouv_id==0){
				$datas = [
					'libelle'=>$motif??("TRANSFERT FOND ".$compte1->code),
					'date_mouv'=>$date,
					'ms_annee_scolaire_id'=>\App\Config::getIdAnnee(),
					'description_mouv'=>"TRANFERT DES FOND DU COMPTE ET SOUS COMPTE DE ".$compte1->libelle." VERS (".$compte2->libelle.")  ",
					'faire_suivi'=>0,
					'user_id'=>$user_id,
					'cpt_secteur_id'=>$secteur_id,
				];
				$mouvement = MouvementCompte::create($datas);
				$mouv_id = $mouvement->id;
			}

			if($mntt = ($sold_cpt['sc_cdf']+($sold_cpt['sc_usd']*$taux))){
				$datas_c = [
					'montant'=>$mntt,
					'montant_usd'=>$sold_cpt['sc_usd'],
					'montant_cdf'=>$sold_cpt['sc_cdf'],
					'taux'=>$taux, 
					'compte_initial'=>$cpt1,
					'compte_final'=>$cpt2,
					'mouvement_compte_id' => $mouv_id, 
				];
				$sold_cpt['r_cdf'] = $reste_a_trans['r_cdf'];
				$sold_cpt['r_usd'] = $reste_a_trans['r_usd'];
				// dd($datas_c,$sold_cpt);
				MouvementCpteUtilise::create($datas_c);
			}
		}
		else{
			$sold_cpt = ['sc_cdf'=>0,'sc_usd'=> 0]; 
		}

		// on trouve tous les sous comptes et on va transferer les fonds de chacun
		$sousComptes = Compte::where('compte_parent_id',$cpt1)->get();
		if(($reste_a_trans['r_usd']+$reste_a_trans['r_cdf'])>0 and $sousComptes->count()){
			foreach($sousComptes as $c){
				if(($reste_a_trans['r_usd']+$reste_a_trans['r_cdf'])==0)
					break;
				$r = $this->transferer_largent($date,$c->id,$cpt2,$secteur_id,$reste_a_trans,$mouv_id);// on trouve le solde de chaque sous compte par recurssivite
				$sold_cpt['sc_usd']+=$r['sc_usd'];
				$sold_cpt['sc_cdf']+=$r['sc_cdf'];

				$reste_a_trans['r_cdf'] = $r['r_cdf'];
				$reste_a_trans['r_usd'] = $r['r_usd'];
			}
		}
		$sold_cpt['r_cdf'] = $reste_a_trans['r_cdf'];
		$sold_cpt['r_usd'] = $reste_a_trans['r_usd'];
		return $sold_cpt;
	}

	
	public function livre_des_compte(Request $request){
		// $cashfichesorties = CashFicheSortie::all();
		$total_demande = 0; $total_demande_asuiv = 0; $total_justif = 0;$a_suivre = 0;$monnaie="";
		//d = CashFicheSortie::with("cashSuivis","cashCategorie")->get();
		$user_id = \Auth::user()->id;
		$ecole_id = Config::getEcoleId();
		$comptes = Compte::with('compte')->where('ecole_id',$ecole_id)->get();
		
		$users = $this->les_users(); 
		$mes_comptes = User::with('compteEtUsers.compte')->find($user_id)->compteEtUsers;
		
		$mes_secteurs = [];
		$cptComptables = CptComptable::with('cptSecteur')->where('user_id',$user_id)->get();
		if($cptComptables){
			$mes_secteurs = $cptComptables->map(function ($item, $key) {
				return $item->cptSecteur;
			});
		}

		$CompteEtUsers=null;

		$ids = $this->cpt_secteur_ids();
		$compteAsuivre = CptCompteAsuivre::whereIn('cpt_secteur_id',$ids)->get()->groupBy('cpt_secteur_id');
		$compte_principaux = Compte::where('compte_parent_id',null)->get();
		// dd($compte_principaux);

		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		// dd($user_id,$CompteEtUsers);
		return $this->addUser($this->v_path.'grand_livre',compact('mes_secteurs','compte_principaux','CompteEtUsers','compteAsuivre','user','users','comptes','mes_comptes'));
	}

	public function synthese_des_compte(Request $request){
	
		return $this->addUser($this->v_path.'synthese_compte');
	}

	public function save_sect_compte_asuivre(Request $request){
		$user_id = \Auth::user()->id;
		$user = User::with('cptComptables.cptSecteur','compteEtUsers.compte')->find($user_id);
		if($user->cptComptables->count()==1)
			$tab_sec = [$user->cptComptables->first()->cpt_secteur_id];
		else $tab_sec = $request->cpt_secteur_id;
		foreach($request->compte_id as $cid){
			foreach($tab_sec as $sid){
				if($request->supprimer){
					$c = CptCompteAsuivre::where(['cpt_secteur_id'=>$sid,'compte_id'=>$cid])->first();
					if($c)
						CptCompteAsuivre::destroy($c->id);
				}
				else CptCompteAsuivre::firstOrCreate(['cpt_secteur_id'=>$sid,'compte_id'=>$cid]);
			}
		}/* 
		if($request->cpt_secteur_id){
		foreach($request->compte_id as $cid){
			foreach($request->cpt_secteur_id as $sid){
				CptCompteAsuivre::firstOrCreate(['cpt_secteur_id'=>$sid,'compte_id'=>$cid]);
			}
		}} */
		return redirect()->back();
	}
	
	public function save_user_compte(Request $request){
		foreach($request->compte_id as $cid){
			foreach($request->user_id as $uid){
				CompteEtUser::firstOrCreate(['compte_id'=>$cid,'user_id'=>$uid]);
			}
		}
		return redirect()->back();
	}
 
	
	public function rapport_journalier_global(Request $request){
		$date_debut = $request->date_debut ?? date("Y-01-01");
		$date_fin = $request->date_fin ?? date("Y-m-d");
		$ids = $this->cpt_secteur_ids();
		$ecole_id = Config::getEcoleId();
		$mpFraisPaiements = MpFraisPaiement::with('mpFraisClasse.msClasse')
		->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		->whereBetween('payer_le', [$date_debut,$date_fin])->get()->groupBy('payer_le');
		
		$operations = MouvementCpteUtilise::with('mouvementCompte','compteInitial','compteFinal')
			->whereHas('compteInitial', function($q)use($ecole_id){
				return $q->where('ecole_id',$ecole_id);
			})->whereHas('mouvementCompte', function($q)use($date_debut,$date_fin){
				return $q->whereBetween('date_mouv', [$date_debut,$date_fin]);
			})
			
			->orWhereHas('compteFinal', function($q)use($ecole_id){
				return $q->where('ecole_id',$ecole_id);
			})->whereHas('mouvementCompte', function($q)use($date_debut,$date_fin){
				return $q->whereBetween('date_mouv', [$date_debut,$date_fin]);
			})
			
			->get()
			->groupBy(function ($item, $key) {
				return $item->mouvementCompte->date_mouv??'----';
			});
		//dd($ecole_id,$operations->first());
		$data = compact('mpFraisPaiements','operations','date_debut','date_fin');
		if($request->compta)
			return view('os.rapport_global',$data);
		return $this->addUser($this->v_path.'rapport_journalier_global',$data);
	
	}

	
	public function rapport_journalier_journal(Request $request){
		$total_demande = 0; $total_demande_asuiv = 0; $total_justif = 0;$a_suivre = 0;$monnaie="";
		$ids = $this->cpt_secteur_ids();
		$date = $request->date_rapport ?? date("Y-m-d");
		// on recupere toutes les operation du jour, sur les paiements et les mouvement ordinaires
		$rapport = Compte::with('categorieCompte','mpFraisPaiements',"mouvementComptes")
		->whereHas('mpFraisPaiements', function($q) use($date){
			$q->where('payer_le', $date);
		})
		->orWhereHas('mouvementComptes', function($q) use($date,$ids){
			$q->where('date_mouv', $date)->whereIn('cpt_secteur_id',$ids);
		})
		->get()
		
		->groupBy(function($d,$k){ return $d->categorieCompte?($d->categorieCompte->entree?'II. ENCAISSEMENTS':'III. DECAISSEMENTS'):"Autres";  })
		->sortKeys();
		foreach($rapport as $c=>$col){
			$col = $col->groupBy(function($d,$k){ return $d->categorieCompte?$d->categorieCompte->categorie:"Autre"; })->sortKeys();
			// dd($col);
			foreach($col as $k=>$v ){
				$v = $v->groupBy('code');
				$col[$k] = $v;
			}
			$rapport[$c]=$col;
		}
		// categorisation par encaissement et decaissement
		$comptes = Compte::with('categorieCompte')->get()->groupBy(function($d,$k){ return ($d->categorieCompte->entree??false)?'II. ENCAISSEMENTS':'III. DECAISSEMENTS'; })
		->sortKeys();
		foreach($comptes as $c=>$col){
			$col = $col->groupBy(function($d,$k){ return $d->categorieCompte?$d->categorieCompte->categorie:"Autre"; })->sortKeys();
			
			foreach($col as $k=>$v ){
				$v = $v->groupBy('code');
				$col[$k] = $v;
			}
			$comptes[$c]=$col;
		}


		$date_rapport = $date;
		$rapportjournalier = RapportJournalier::with('rapportJournalier')->where('date_rapport',$date_rapport)->first();// new RapportJournalier;
		//dd($rapportjournalier);
		if($rapportjournalier and $rapportjournalier->rapportJournalier)
			$report_du_rapport = $rapportjournalier->rapportJournalier;
		else 
			$report_du_rapport = RapportJournalier::where('report_joint',null)
				->where('date_rapport','<',$rapportjournalier->date_rapport??date('Y-m-d'))
				->where('id','<>',$rapportjournalier->id??0)
				->orWhere('report_joint', $rapportjournalier->id??0)
				->first();// new RapportJournalier;
		$next_rapport = RapportJournalier::where('rapport_journalier_id',$rapportjournalier->id??0)->first();
		//dd($report_du_rapport);
		//dd($comptes);
		return $this->addUser($this->v_path.'rapport_journalier',compact('rapport','comptes','rapportjournalier','date_rapport','report_du_rapport','next_rapport'));
	
	}

	
    public function save_rapport_mensuel(Request $request)
	{
				$datas = [
					'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'total_recette_cdf'=>$request->total_recette_cdf,
					'total_recette_usd'=>$request->total_recette_usd,
					'total_aurtre_rec_cdf'=>$request->total_aurtre_rec_cdf,
					'total_aurtre_rec_usd'=>$request->total_aurtre_rec_usd,
					
					'total_charge_cdf'=>$request->total_charge_cdf,
					'total_charge_usd'=>$request->total_charge_usd,
					'total_autre_char_cdf'=>$request->total_autre_char_cdf,
					'total_autre_char_usd'=>$request->total_autre_char_usd,
					'mois_rapport'=>($request->mois_rapport??''),
					'rapport_mensuel_id'=>$request->rapport_mensuel_id,
					'date_debut'=>$request->date_debut,
					'date_fin'=>$request->date_fin,
					
				];
				$rules = [
					'report_cdf'=>'',
					'report_usd'=>'',
					'total_recette_cdf'=>'',
					'total_recette_usd'=>'',
					'total_aurtre_rec_cdf'=>'',
					'total_aurtre_rec_usd'=>'',
										
					'total_charge_cdf'=>'',
					'total_charge_usd'=>'',
					'total_autre_char_cdf'=>'',
					'total_autre_char_usd'=>'',
					'mois_rapport'=>'required',
					'rapport_mensuel_id'=>'',
					'date_debut'=>'required',
					'date_fin'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$rapport = RapportMensuel::create($datas);

				$r = RapportMensuel::find($request->report_joint);
				if($r){
					$r->report_joint = $rapport->id;
					$r->save();
				}
				
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $rapport;
					$id = $rapport->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportmensuel',$rapport);
					return redirect()->back();
				}
				return redirect()->route('rapportmensuels.index');
    }
	public function envoyer_rapport_journalier(Request $request,$view=true){
		$date = $request->date_rapport??date('Y-m-d');
		$path = 'excel-rapport-financier/Rapport-Fin-'.$date.'.xlsx';
		
		Excel::store((new RapportFinExport)->forDate($date), "public/".$path,'local');
		//dd( file_exists(public_path('storage/'.$path))?"coooooooooooooool":"nooooooooooooon" );
		$data["email"] = "chad@esisalama.org";
		$data["title"] = "Rapport Financier ". \App\Config::getEcole();
		$data["body"] = "Bonjour Monsieur,";
		$data["date_rapport"] = $date;
 
		$files = [
			public_path('storage/'.$path)
		];
  
		Mail::send('emails.rapport', $data, function($message)use($data, $files) {
			$message->to($data["email"], $data["email"])
					->subject($data["title"]);
 
			foreach ($files as $file){
				$message->attach($file);
			}
			
		}); 
		if($view)
		return $this->addUser($this->v_path.'email_rapport_journalier',$data);
		return true;
	}
    public function save_rapport_journalier(Request $request)
	{
		
			$datas = [
					'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'total_recette_cdf'=>$request->total_recette_cdf,
					'total_recette_usd'=>$request->total_recette_usd,
					'total_aurtre_rec_cdf'=>$request->total_aurtre_rec_cdf,
					'total_aurtre_rec_usd'=>$request->total_aurtre_rec_usd,
					
					'total_charge_cdf'=>$request->total_charge_cdf,
					'total_charge_usd'=>$request->total_charge_usd,
					'total_autre_char_cdf'=>$request->total_autre_char_cdf,
					'total_autre_char_usd'=>$request->total_autre_char_usd,
					'date_rapport'=>($request->date_rapport??''),
					'rapport_journalier_id'=>$request->rapport_journalier_id,
					
				];
				$rules = [
					'report_cdf'=>'',
					'report_usd'=>'',
					'total_recette_cdf'=>'',
					'total_recette_usd'=>'',
					'total_aurtre_rec_cdf'=>'',
					'total_aurtre_rec_usd'=>'',
										
					'total_charge_cdf'=>'',
					'total_charge_usd'=>'',
					'total_autre_char_cdf'=>'',
					'total_autre_char_usd'=>'',
					'date_rapport'=>'required',
					'rapport_journalier_id'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$rapportjournalier = RapportJournalier::create($datas);

				$r = RapportJournalier::find($request->report_joint);
				if($r){
					$r->report_joint = $rapportjournalier->id;
					$r->save();
				}
				
				// $this->envoyer_rapport_journalier($request,false);

				my_flash("Enregistrement effecté avec succès");

				
				
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $rapportjournalier;
					$id = $rapportjournalier->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportjournalier',$rapportjournalier);
					return redirect()->back();
				}
				return redirect()->route('rapportjournaliers.index');
    }
	
	
	public function rapport_mensuel_entree_sortie(Request $request) {
		// mp_type_frais_id
		// dd($request);
		$mp_type_frais_id = $request->mp_type_frais_id;
		$selected_mpTypeFrais = false;
		$tab = [];
		if($mp_type_frais_id){
			$tab = MpFraisPaiement::with('mpFraisClasse.mpFrais')->selectRaw('id,ms_eleve_id,mp_frais_classe_id,montant_payer,payer_le,MONTH(payer_le) as mois')->get()
			->filter(function($p,$k) use($mp_type_frais_id){
				// dd($p,$k);
				$ok = ($p->mpFraisClasse->mpFrais)??false;
				if($ok)
					return in_array($p->mpFraisClasse->mpFrais->mp_type_frais_id, $mp_type_frais_id );
				return false;
				})
			->groupBy('mois');
			
			$req = MpTypeFrais::where('id',$mp_type_frais_id[0]);
			foreach($mp_type_frais_id as $id){
				$req->orWhere('id',$id);
			}
			$tabF = $req->get();
			$selected_mpTypeFrais = '';
			foreach($tabF as $f){
				$selected_mpTypeFrais.= $f->type.' ';
			}
			// dd();
			
		}			
		//else dd($request);
		//dd($tab,$selected_mpTypeFrais);		
		$mpTypeFraiss = MpTypeFrais::all();
		return $this->addUser($this->v_path.'rapport_mensuel_entree_sortie', compact('tab','selected_mpTypeFrais','mpTypeFraiss') );
	}
		
}

 