<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use \App\Masomwetu\Scholar\MsClasse;
use App\Masomwetu\Scholar\MsPromotion; 
use App\Masomwetu\School\Section;
use \App\Masomwetu\Payment\MpFraisPaiement;


use App\SysUserRole;
use App\Masomwetu\Scholar\MsEleve;
use App\Config;

// le controlleur qui gère l'entrée à toutes les sous applications
class MCommunicationController extends Controller
{
	private $v_path = 'mes_vues.Communication.';
	
	public function index(){
		// dd(substr("testers", -1),substr("testers", 1));
		$ecole_id = Config::getEcoleId();
		$msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get();
		$id = $ecole_id;
		$stock_sms = \DB::table("bulletin_ecoles")->where(compact("id"))->first()->nbr_sms;
		$sms_envoye = \DB::table("mc_sms_ecoles")->where(compact("ecole_id"))->count();
		
		$sections  = Section::all();
		
		$msPromotions = MsPromotion::with('msClasses')
		->whereHas('msClasses',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})->get();
		
		return $this->addUser($this->v_path.'index', compact('msClasses','msPromotions','sections','sms_envoye','stock_sms'));
		
	}
	
	public function envoi_message(Request $request){
		$dest = $request->ms_classe_id;
		$msg = $request->message;
		$liste_num = $request->liste_num;
		if(trim($liste_num ) and $msg)
			online_sms($liste_num,$msg);
		
		$frais = $request->frais;
		if($dest and count($dest)){
			foreach($dest as $d){
				list($cle,$id) = explode('=',$d);
				if($cle=='cl'){
					$id_classe = $id;
					if($frais)
						$this->eleve_avec_frais($id_classe);
					else $this->envoyer_sms_classe($id_classe,$msg);
				}
				else if($cle=='pr'){
					$id_pro = $id;
					$promos = MsPromotion::with('msClasses')->where('id',$id_pro)->first();
					$this->envoi_message_promo($promo,$msg,$frais);				
				}
				else if($cle=='se'){
					$id_section = $id;
					$sec = Section::with('msPromotions.msClasses')->where('id',$id_section)->first();
					$this->envoi_message_section($sec,$msg,$frais);
				}
			}
		}		
		// dd($request);
		return redirect()->route('communication.index');
		return $this->addUser($this->v_path.'index');
	}
	
	private function envoi_message_promo($promo,$msg,$frais=false){
		if($promo){
			$classes = $promo->msClasses;
			foreach($classes as $cl){
				if($frais)
					$this->eleve_avec_frais($cl->id);
				else $this->envoyer_sms_classe($cl->id,$msg);
			}					
		}
	}
	
	private function envoi_message_section($sec,$msg,$frais){
		if($sec){
			$promos = $sec->msPromotions;
			foreach($promos as $pro){
				$this->envoi_message_promo($pro,$msg,$frais);
			}					
		}
	}
	
	public function envoi_resumer_frais_eleve(Request $req){
		$el = MsEleve::findOrFail($req->id);
		if($el){
			$this->eleve_avec_frais($el->ms_classe_id,$el->id);
			return "MESSAGE ENVOYE.";
		}
		else return "CETTE ELEVE N'EXISTE PAS";
	}
	
	private $NumContacter=[];
	public function eleve_avec_frais($id_classe,$id_eleve=0){
		$ecole = Config::getEcole();
		$result = MpFraisPaiement::with('msEleve.tuteur','msEleve.enfant','msEleve.msClasse','mpFraisClasse.mpFrais.mpTypeFrais')
				->groupBy('ms_eleve_id','mp_frais_classe_id')
				->selectRaw('*,sum(montant_payer) as sum')
				->whereHas('msEleve.msClasse', function($q) use($id_classe){								
					$q->where("id",$id_classe);									
				})
				//->where('mp_frais_classe_id',$id_frais_classe)
				->where('ms_eleve_id',($id_eleve==0?'<>':'='),$id_eleve)
				->get()
				->groupBy(function ($p, $key) {
					return $p->msEleve->id;
				});
		
		if($result){
			//$eleves = $classe->msEleves;
			$tab_num = [];
			foreach($result as $paiemenets_eleve){
				$el = $paiemenets_eleve[0]->msEleve;
				$enfant = $paiemenets_eleve[0]->msEleve->enfant;
				$classe = $paiemenets_eleve[0]->msEleve->msClasse;
				$msg = "";
				if($tut = $el->tuteur??false){
					if($num = $tut->telephone){
						$tab_num[$num] = isset($tab_num[$num])?$tab_num[$num]:"";
						foreach($paiemenets_eleve as $p){
							$mnt = $p->sum;
							$frais = $p->mpFraisClasse->mpFrais->mpTypeFrais->type." ".$p->mpFraisClasse->mpFrais->frais;
							$montant = $p->mpFraisClasse->montant;
							$msg.=" $frais: ".($mnt==$montant?"OK":"$mnt/$montant");
						}
						$msg = $ecole.", ".$enfant->nom." ".$enfant->postnom." ".$enfant->prenom." de ".$classe->classe." A DEJA PAYE ".$msg;
						$tab_num[$num] .= $msg;
					}				
				}
			}
			// dd($tab_num);
			foreach($tab_num as $n=>$m)
				online_sms($n,$m);
		}		
	}
	
	function envoyer_sms_classe($id_classe,$msg){
		$classe = MsClasse::with('msEleves.tuteur','msEleves.enfant')->where('id',$id_classe)->get();
		if($classe){
			$eleves = $classe->msEleves;
			foreach($eleves as $el){
				if($tut = $el->tuteur??false){
					if(!in_array($num,$this->NumContacter) ){
						$num = $tut->telephone;
						online_sms($num,$msg);
						$this->NumContacter[]=$num;
					}					
				}
			}
		}		
	}
	
}