<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use \App\Masomwetu\Sys\SysUserRole;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Masomwetu\Scholar\MsEleveDeroger;
use \App\Masomwetu\Scholar\MsDerogation;

use \App\Masomwetu\Allocation\Atelier;
use \App\Masomwetu\Allocation\Materiel;
use \App\Masomwetu\Allocation\EmpruntMateriel;

use \App\Masomwetu\Scholar\MsClasse;
use \App\Masomwetu\Scholar\MsPromotion;
use \App\Masomwetu\Scholar\MsAnneeScolaire;
use \App\Masomwetu\Scholar\MsInscription;
use \App\Masomwetu\Scholar\Tuteur;
use \App\Masomwetu\Scholar\Enfant;
use \App\Masomwetu\Scholar\StatusEnfant;
use \App\Masomwetu\Scholar\ParentEnfant;
use \App\Masomwetu\School\Section;
use \App\Masomwetu\School\ElementDossierEleve;
use \App\Masomwetu\School\DossierEnfant;
use \App\Masomwetu\School\ImgDossierEnfant;
use \App\Masomwetu\School\Religion;

use \App\Masomwetu\Payment\MpFrais;
use \App\Masomwetu\Payment\MpFraisClasse;
use App\Masomwetu\Payment\MpFraisPaiement;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Disciplinary\AbsEleveAbsent; 

use \App\Config;
use \App\Imports\EleveImport;
use \App\Imports\ClasseImport;
use \App\Imports\EleveResultTestImport;
use \App\Exports\PromotionExport;
use \Excel;

use \App\Http\Controllers\MPaymentController;

use Validator,Rule;

// le controlleur qui gère l'entrée à toutes les sous applications
class MScholarController extends Controller
{
	private $v_path = 'mes_vues.Scholar.';
	public function __construct(){
	    if(session( 'test_db') == 'yes' ){
            \DB::setDefaultConnection('mysql2'); 
            // echo "authenti";
            // dd(session( 'test_db'))  ;
        }
	}
    public function accueil(){
		$ecole_id = Config::getEcoleId();
		$id_annee = Config::getIdAnnee();
		//dd($ecole_id,session());
		//dd($id_annee);
		$msClasses = MsClasse::with('msPromotion.section')
		->where('ecole_id',$ecole_id)->get();
		$nombre_classe = $msClasses->count();
		$msClasses = $msClasses->groupBy(function ($classe, $key) {
		                        //if(!$classe->mspromotion)dd($classe); 
								return $classe->mspromotion->section->nom_sec;
							})->sortKeys()->all();
		
		$msEleves = MsEleve::with('msClasse','msPromotion.section')
		->where("ms_annee_scolaire_id",$id_annee)
		->where('ecole_id',$ecole_id)->where('etat','Actif')->get();
		$nombre_eleve = $msEleves->count();
		$msEleves = $msEleves->groupBy(function ($eleve, $key) {
		    //if(!$eleve->mspromotion)dd($eleve);
								return $eleve->mspromotion->section->nom_sec??'PAS DE SECTION';
							})->sortKeys()->all();
							//dd($msClasses,$msEleves);
		$nombre_inscrit = $nombre_eleve;
		return $this->addUser($this->v_path.'accueil', compact('nombre_inscrit','nombre_classe','nombre_eleve','msClasses','msEleves'));
	}
		
	public function datatable_save_role(Request $request ){
	   $t = $request->sys_role_id;
	    foreach($t as $sys_role_id){
	        $user_id = $request->user_id;
	        $actif = $request->actif?1:null;
	        $ecole_id = $request->ecole_id; 
	        $ms_annee_scolaire_id = $request->ms_annee_scolaire_id;
	        $datas = compact('user_id','actif','ecole_id','ms_annee_scolaire_id','sys_role_id');
	        // \DB::table('bulletin_sys_user_roles')->insert($datas);
	        \DB::table('bulletin_sys_user_roles')->updateOrInsert(compact('user_id','sys_role_id','ecole_id'),compact('actif','ms_annee_scolaire_id'));
	    }
	    return redirect()->back();
	}
		
	public function select_classe_ajax(Request $request ){
		$id_annee = Config::getIdAnnee();
		$cle = str_replace(' ','%', $request->q);
		
		$msClasses = MsClasse::with('msPromotion.section')->whereRaw("classe LIKE '%".$cle."%'")
							// ->whereHas('msPromotion.section', function($q) use($cle){								
								// $q->whereRaw("concat( ifnull(nom,''),' ', ifnull(postnom,''),' ',ifnull(prenom,'')) LIKE '%".$cle."%'");									
							// })
							// ->whereHas('mspromotion', function($q) use($id_annee){								
							// 	$q->where("ms_annee_scolaire_id",$id_annee);									
							// })
							// ->limit(5)
							->get();
		$items = [];
		foreach($msClasses as $e){
			$classe = $e->classe.' '.$e->msPromotion->section->nom_sec;
			$attrs['id'] = 'option-eleve-'.$e->id;
			$attrs['id_promo'] = $e->msPromotion->id;
			$items[] = ['id'=>$e->id,'text'=>$classe,'attrs'=>$attrs];
		}
		// dd($items);
		return compact('items');
	}
	
	public function select_parent_ajax(Request $request ){
		$tab_cles = ["p"=>"papa","tp"=>"telephone_pa","pp"=>"profession_pa","m"=>"maman","tm"=>"telephone_ma","pm"=>"profession_ma"];
		$r = explode(",",$request->q);
		$r1 = explode("=",$request->q);
		$req = "";
		if(count($r)>=2 or( count($r1)>=2  and $r=[$request->q])){
			
			foreach($r as $e){
				$t = explode("=",($e));
				if(count($t)==2 and isset( $tab_cles[$c=trim($t[0])] )){
					$req.=$tab_cles[$c]." LIKE '%".trim($t[1])."%' AND ";
				}
				//dd($r,$req);
			}
			$req .= " 1";
		}
		else{
			 $cle = str_replace(' ','%', $request->q);
			 $req = "papa LIKE '%".$cle."%' OR maman LIKE '%".$cle."%' OR telephone_pa LIKE '%".$cle."%' OR telephone_ma LIKE '%".$cle."%'  ";
		}
		//dd($req);
		$parentEnfants = ParentEnfant::whereRaw($req)
							->limit(10)
							->get();
		$items = [];
		foreach($parentEnfants as $e){
			$parent = $e->papa.' '.$e->telephone_pa.' '.$e->profession_pa .' / '.$e->maman.' '.$e->telephone_ma.' '.$e->profession_ma ;
			$attrs['id'] = 'option-parent-'.$e->id;
			 $attrs['p'] = $e->papa;
			 $attrs['tp'] = $e->telephone_pa;
			 $attrs['pp'] = $e->profession_pa;
			 $attrs['pd'] = $e->papa_deceder;
			 $attrs['ap'] = $e->adresse_papa;
			 $attrs['m'] = $e->maman;
			 $attrs['tm'] = $e->telephone_ma;
			 $attrs['mp'] = $e->profession_ma;
			 $attrs['md'] = $e->maman_deceder;
			 $attrs['am'] = $e->adresse_maman;	
			 $attrs['cs'] = $e->parent_separer;		 
			 $items[] = ['id'=>$e->id,'text'=>$parent,'attrs'=>$attrs];
		}
		// dd($items);
		return compact('items');
	}
	
	public function select_tuteur_ajax(Request $request ){
		$cle = str_replace(' ','%', $request->q);
		$tuteurs = Tuteur::whereRaw("nom_tuteur LIKE '%".$cle."%' or telephone LIKE '%".$cle."%'")
					->limit(10)
					->get();
		$items = [];
		foreach($tuteurs as $e){
			$tuteur = $e->nom_tuteur.' '.$e->telephone.' '.$e->adresse  ;
			$attrs['id'] = 'option-tuteur-'.$e->id;
			 	 
			$items[] = ['id'=>$e->id,'text'=>$tuteur,'attrs'=>$attrs];
		}
		// dd($items);
		return compact('items');
	}
	
	public function select_eleve_ajaxx(Request $request ){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$cle = str_replace(' ','%', trim($request->q) );
		if($cle=='' or strlen($cle)<3)
			return "";
		// dd($ecole_id,$id_annee);
		$req="select el.id,classe,matricule,nom,postnom,prenom,genre,nom_sec ,telephone,nom_tuteur,lien_avec_eleve,tuteur_id
		from bulletin_ms_eleves partition (p$ecole_id)  el
        inner join enfants ef on el.enfant_id=ef.id 
        inner join bulletin_ms_classes cl on cl.id = el.ms_classe_id 
        inner join bulletin_ms_promotions p on cl.ms_promotion_id = p.id 
        inner join bulletin_sections s on s.id = p.section_id 
        left join tuteurs t on t.id = el.tuteur_id 
        where el.ms_annee_scolaire_id = $id_annee and el.etat='Actif' and 
        (matricule LIKE '%$cle%' or concat( ifnull(nom,''),' ', ifnull(postnom,''),' ',ifnull(prenom,'')) LIKE '%$cle%' or 
        telephone LIKE '%$cle%' or nom_tuteur LIKE '%$cle%') limit 15;";
		$m = \DB::select($req);
					
		$items = [];
		foreach($m as $e){
			
			$classe = $e->classe;
			$noms = ($e->matricule.' '.$e->nom.' '.$e->postnom.' '.$e->prenom.' '.$e->genre.' '.$classe);
			$attrs['classe'] = $classe.' '.$e->nom_sec;
			$attrs['id'] = "option-eleve-$e->id";
			$attrs['img'] = asset('img/logo.png');
			$attrs['nom'] = $noms;
			$attrs['IDINSC'] = $e->id;
			$attrs['tel'] = ($e->tuteur_id)?$e->telephone:'+243............';
			$attrs['tut'] = ($e->tuteur_id)?$e->nom_tuteur:'';
			$attrs['lien'] = ($e->tuteur_id)?$e->lien_avec_eleve:'';
			$attrs['IDTUT'] = ($e->tuteur_id)?$e->tuteur_id:'null';
			
			// $attrs['classe'] = $e->msClasse->classe.' '.$e->msClasse->msPromotion->section->nom_sec;
			$items[] = ['id'=>$e->id,'text'=>$noms,'attrs'=>$attrs];
		}
		return compact('items');
		/*
		$mseleves = MsEleve::with('enfant','msClasse.msPromotion.section','tuteur')
				->where("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('enfant', function($q) use($cle){								
					$q->whereRaw("matricule LIKE '%".$cle."%'");									
				})
				->orWhere("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('enfant', function($q) use($cle){								
					$q->whereRaw("concat( ifnull(nom,''),' ', ifnull(postnom,''),' ',ifnull(prenom,'')) LIKE '%".$cle."%'");									
				})
				->orWhere("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('msClasse', function($q) use($cle){								
					$q->whereRaw("classe LIKE '%".$cle."%'");									
				})
				->orWhere("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('tuteur', function($q) use($cle){								
					$q->whereRaw("(telephone LIKE '%".$cle."%' or nom_tuteur LIKE '%".$cle."%')");									
				})
			->limit(15)
				 //dd($mseleves->toSql());
				->get();
								
		$items = [];
		foreach($mseleves as $e){
			
			$classe = $e->msClasse->classe;
			$noms = $e->enfant?($e->enfant->matricule.' '.$e->enfant->nom.' '.$e->enfant->postnom.' '.$e->enfant->prenom.' '.$e->enfant->genre.' '.$classe):'A Supprimer';
			$attrs['classe'] = $classe.' '.$e->msClasse->msPromotion->section->nom_sec;
			$attrs['id'] = "option-eleve-$e->id";
			$attrs['img'] = asset('img/logo.png');
			$attrs['nom'] = $noms;
			$attrs['IDINSC'] = $e->id;
			$attrs['tel'] = ($e->tuteur)?$e->tuteur->telephone:'+243............';
			$attrs['tut'] = ($e->tuteur)?$e->tuteur->nom_tuteur:'';
			$attrs['lien'] = ($e->tuteur)?$e->tuteur->lien_avec_eleve:'';
			$attrs['IDTUT'] = ($e->tuteur)?$e->tuteur->id:'null';
			
			// $attrs['classe'] = $e->msClasse->classe.' '.$e->msClasse->msPromotion->section->nom_sec;
			$items[] = ['id'=>$e->id,'text'=>$noms,'attrs'=>$attrs];
		}
		return compact('items');
		*/
	}
	public function select_eleve_ajax(Request $request)
    {
        $id_annee = Config::getIdAnnee();
        $ecole_id = Config::getEcoleId();
    
        $isAll = $request->get('all') === 'yes';
        $cle   = str_replace(' ', '%', trim($request->q ?? ''));
    
        // 🔐 Sécurité : en mode recherche, au moins 3 caractères
        if (!$isAll && (strlen($cle) < 3)) {
            return response()->json(['items' => []]);
        }
    
        /* ================= SQL DE BASE ================= */
        $sql = "
            SELECT 
                el.id,
                el.img,
                classe,
                matricule,
                nom,
                postnom,
                prenom,
                genre,
                nom_sec,
                telephone,
                nom_tuteur,
                lien_avec_eleve,
                tuteur_id,
                1 as ponderation
            FROM bulletin_ms_eleves PARTITION (p$ecole_id) el
            INNER JOIN enfants ef ON el.enfant_id = ef.id
            INNER JOIN bulletin_ms_classes partition (p$ecole_id) cl ON cl.id = el.ms_classe_id
            INNER JOIN bulletin_ms_promotions p ON cl.ms_promotion_id = p.id
            INNER JOIN bulletin_sections s ON s.id = p.section_id
            LEFT JOIN tuteurs t ON t.id = el.tuteur_id
            WHERE el.ms_annee_scolaire_id = $id_annee
              AND el.etat = 'Actif'
        ";
            // LEFT JOIN status_enfants st ON st.id = el.status_enfant_id
    
        /* ================= FILTRES DE RECHERCHE ================= */
        if (!$isAll) {
            $sql .= "
                AND (
                    matricule LIKE '%$cle%' OR
                    CONCAT(IFNULL(nom,''),' ',IFNULL(postnom,''),' ',IFNULL(prenom,'')) LIKE '%$cle%' OR
                    classe LIKE '%$cle%' OR
                    telephone LIKE '%$cle%' OR
                    nom_tuteur LIKE '%$cle%'
                )
                LIMIT 20
            ";
        }
    
        $rows = \DB::select($sql);
    
        /* ================= FORMAT SELECT2 ================= */
        $items = [];
    
        foreach ($rows as $e) {
    
            $noms = trim(
                $e->nom . ' ' .
                $e->postnom . ' ' .
                $e->prenom . ' ' .
                $e->genre 
                // $e->classe
            );
    
            $attrs = [
                'classe' => $e->classe . ' ' . $e->nom_sec,
                'id'     => "option-eleve-$e->id",
                'img'    => asset('storage/mseleve/img/'.$e->img),
                'mat'    => $e->matricule,
                'nom'    => $noms,
                'IDINSC' => $e->id,
                'tel'    => $e->tuteur_id ? $e->telephone : '+243............',
                'tut'    => $e->tuteur_id ? $e->nom_tuteur : '',
                'lien'   => $e->tuteur_id ? $e->lien_avec_eleve : '',
                'pond'   => $e->ponderation,
                'IDTUT'  => $e->tuteur_id ?? 'null',
            ];
    
            $items[] = [
                'id'    => $e->id,
                'text'  => $noms,
                'attrs' => $attrs
            ];
        }
    
        return response()->json(compact('items'));
    }

	
	public function select_inscription_ajax(Request $request ){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		$cle = str_replace(' ','%', trim($request->q) );
		if($cle=='' or strlen($cle)<1)
			return "";
		
		if(!$request->reinsc)
			$mseleve = MsEleve::with('enfant','msPromotion.section','tuteur','msClasse')
				->where("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('enfant', function($q) use($cle){								
					return $q->whereRaw("matricule LIKE '%".$cle."%'");									
				})
				->orWhere("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('enfant', function($q) use($cle){								
					return $q->whereRaw("concat( ifnull(nom,''),' ', ifnull(postnom,''),' ',ifnull(prenom,'')) LIKE '%".$cle."%'");
				})
				->orWhere("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('tuteur', function($q) use($cle){								
					return $q->whereRaw("(telephone LIKE '%".$cle."%' or nom_tuteur LIKE '%".$cle."%')");									
				}) 
				->orWhere("ms_annee_scolaire_id",$id_annee)
				->where("ecole_id",$ecole_id)
				->whereHas('msClasse', function($q) use($cle){								
					return $q->whereRaw("classe LIKE '%".$cle."%'");									
				});
		else $mseleve = MsEleve::with('enfant','msPromotion.section','tuteur','msClasse')
				->whereHas('enfant', function($q) use($cle){								
					return $q->whereRaw("matricule LIKE '%".$cle."%'");									
				})
				->where("ecole_id",$ecole_id)
				//->whereRow("ifnull(e.deliberation_excep,e.deliberation)<>'EXCLU' ")
				->orWhereHas('enfant', function($q) use($cle){								
					return $q->whereRaw("concat( ifnull(nom,''),' ', ifnull(postnom,''),' ',ifnull(prenom,'')) LIKE '%".$cle."%'");
				})
				->where("ecole_id",$ecole_id)
				//->whereRow("ifnull(e.deliberation_excep,e.deliberation)<>'EXCLU' ")
				->orWhereHas('tuteur', function($q) use($cle){								
					return $q->whereRaw("(telephone LIKE '%".$cle."%' or nom_tuteur LIKE '%".$cle."%')");									
				}) 
				//->whereRow("ifnull(e.deliberation_excep,e.deliberation)<>'EXCLU' ")
				->where("ecole_id",$ecole_id)
				->orWhereHas('msClasse', function($q) use($cle){								
					return $q->whereRaw("classe LIKE '%".$cle."%'");									
				});
			$mseleve = $mseleve->limit(15)
				->get()
				->sortBy(function ($insc, $key) {
					$eleve = $insc->msEleves[0]??false;
					if(!$eleve)
						return "";
					return $eleve->enfant->nom.' '.$eleve->enfant->postnom.' '.$eleve->enfant->prenom;
				});
			;
							// dd($msinscription->toSql());
								
		$items = [];
		foreach($mseleve as $e){			
			$class = ($e->msClasse)?' Classe: '.$e->msClasse->classe:' Promotion: '.$e->msPromotion->promotion;
			$noms = $e->enfant?($e->enfant->matricule.' '.$e->enfant->nom.' '.$e->enfant->postnom.' '.$e->enfant->prenom.' '.$e->enfant->genre.' /'.$class):'A Supprimer';
			$attrs['id'] = "option-eleve-$e->id";
			$attrs['img'] = asset('img/logo.png');
			$attrs['nom'] = $noms;
			$attrs['DELI'] = $e->deliberation_excep?$e->deliberation_excep:$e->deliberation??'';
			$attrs['IDELE'] = $e->id;
			$attrs['tel'] = ($e->tuteur)?$e->tuteur->telephone:'+243............';
			$attrs['IDTUT'] = ($e->tuteur)?$e->tuteur->id:'null';
			//if(!$e->msPromotion)dd($e);
			$attrs['classe'] = $class.' '.$e->msPromotion->section->nom_sec;
			$st = (($request->reinsc and $id_annee!=$e->ms_annee_scolaire_id)?" (ANNEE PASSEE)":"");
			$items[] = ['id'=>$e->id,'text'=>$noms.$st,'attrs'=>$attrs];
		} 
		return compact('items');
	}
	
	public function effectifs(Request $request){
	    $id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		if($request->equilibrer){
		    $tab_classe = explode('-',$request->idCls) ;
	        $req = "select count(*) nbr_eleve,count(distinct ms_classe_id)nbr_clas,GROUP_CONCAT(DISTINCT ms_classe_id SEPARATOR ',')ids_clas,ms_promotion_id 
	        from bulletin_ms_eleves partition (p$ecole_id)  where ecole_id=$ecole_id and ms_annee_scolaire_id=$id_annee 
	        and ms_classe_id in (".implode(",",$tab_classe).") 
	        group by ms_promotion_id";
	        $result = \DB::select($req);  
	        // dd($tab_classe,$result);  
	        
    	    $echo = [];
	        foreach($result as $r){
	            $nbr = $r->nbr_eleve; 
	            $id_pro = $r->ms_promotion_id; 
	            $nbr_clas = $r->nbr_clas;
	            $ids_clas = $r->ids_clas;
	            // on va selectionner les  classes de la promotion 
    	        $tab_classes = \DB::select("select GROUP_CONCAT(DISTINCT id SEPARATOR ',')ids_clas from bulletin_ms_classes partition (p$ecole_id)  where ecole_id=$ecole_id and ms_promotion_id=$id_pro ");
	            $ids_clas = $tab_classes[0]->ids_clas;
	            
	            $ids_clas = explode(",",$ids_clas);
	            $nbr_clas = count($ids_clas);
	            $r = array_intersect($ids_clas, $tab_classe);
	                
	            if (!empty($r)) {
                    // on sélectionne toutes les classes de la promotion et on s'assure qu'il y en a plus d'une classe
    	            $tab_eleves = \DB::select("select id from bulletin_ms_eleves partition (p$ecole_id)  where ecole_id=$ecole_id and ms_promotion_id=$id_pro and ms_annee_scolaire_id=$id_annee ");
    	            if($nbr_clas > 1){
    	            // dd($r,$nbr_clas,$tab_eleves); 
    	                $nbr_rest = $nbr%$nbr_clas;
    	                $nbr_eq = ($nbr-$nbr_rest)/$nbr_clas;
    	                // $idt = explode(",",$ids);
    	                $tt = $nbr_eq*$nbr_clas;
    	                // dd($nbr_clas,$tab_eleves);
    	                for($i=0;$i<$tt;$i++){
    	                    $idcl = $ids_clas[$i % $nbr_clas];
    	                    $id_el = $tab_eleves[$i]->id;
    	                    // $echo[] = "$id_el = $idcl ";
    	                    \DB::table("bulletin_ms_eleves")->where('id',$id_el)->update(['ms_classe_id'=>$idcl]);
    	                }
    	            }
	            } else {
	                
                }
	            // dd($echo);
	        }
	        
	    }
		
		$msEleves = MsEleve::with('statusEnfant','enfant','msClasse','msPromotion.section')
							->where('ms_annee_scolaire_id', $id_annee)
							->where('ecole_id', $ecole_id)
							->get();
	    
	// les effectifs pour toute l'école
		$effectif_ecole = [];/*$msEleves->groupBy(function ($msEleve, $key) {
			return $msEleve->enfant->genre??'F';
		});*/
		// dd($effectif_par_status);
		// effectifs par section
		$effectif_section = [];/*$msEleves->groupBy(
															[
																	function ($msEleve, $key) {
																		return $msEleve->msClasse->msPromotion->section->nom_sec;
																	},
																	function ($msEleve, $key) {
																		return $msEleve->enfant->genre??'F';
																	},
															], $preserveKeys = true
															);*/
		// effectifs par classe
		$effectif_classe = $msEleves->groupBy(
			[
					function ($msEleve, $key) {
						return $msEleve->msClasse->msPromotion->section->type_prog.':'.$msEleve->msClasse->msPromotion->section->nom_sec;
					},
					function ($msEleve, $key) {
					    $cl = $msEleve->msClasse;
						return $cl->msPromotion->section->nom_sec.':'.$cl->msPromotion->niveau.'-'.$cl->msPromotion->promotion.':'.$cl->classe;
					},
					function ($msEleve, $key) {
						return $msEleve->enfant->genre??'F';
					},
					function ($msEleve, $key) {
						return $msEleve->etat=='Actif'?'Actif':'Abandon';
					},
			], $preserveKeys = false
			);

        //if($ecole_id==13)
		//dd($msEleves,$effectif_classe,$effectif_classe["PROGRAMME NATIONAL:Secondaire"]);
		
		$effectif_par_status = $msEleves->groupBy(function ($msEleve, $key) {
			return $msEleve->statusEnfant->status??"Autres";
		});
		// dd($effectif_ecole,$effectif_section,$effectif_classe);
		
		return $this->addUser($this->v_path.'effectifs',compact('effectif_par_status','effectif_ecole','effectif_section','effectif_classe'));
	} 

	public function eleves(Request $request){
		$id_annee = \App\Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get();
		// $hr = date('H:i:s');
		// ms_sms('243898920046',str_replace(':','',$hr));
		// dd(str_replace(':','',$hr),'243898920046');
		$msEleves = [];
		$classe = '';
		$id_classe = $request->ms_classe_id;
		if($request->has("select_file")){
			// $this->validate($request,['ms_classe_id' => 'required','select_file' => 'required|mimes:xls,xlsx']);
			foreach($request->file('select_file') as $file){
				if($request->ms_classe_id == 'all'){
					$tab = explode('_',$file->getClientOriginalName());
					$id_classe = $tab[count($tab)-1];//$tab[0];//
				}
				$classe = MsClasse::find($id_classe);
				dd($classe,$classe?true:false);
				Excel::import( new EleveImport($classe), $file); // on importe
			}			
			
		}
			
		if($request->ms_classe_id){
			$classe = MsClasse::with('msPromotion.section')->find($id_classe);
			$msEleves = MsEleve::with('enfant','tuteur','msClasse.msPromotion.section')
										->where('ms_classe_id',$id_classe)
										->where('ms_annee_scolaire_id',$id_annee)
										->get();
										//dd($msEleves);
			$msEleves = $msEleves->sortBy(function ($eleve, $key) {
				return $eleve->enfant?$eleve->enfant->nom.' '.$eleve->enfant->postnom.' '.$eleve->enfant->prenom:'SUP';
			});

			$msEleves = $msEleves->values()->all();
		}
		
		// return redirect()->back();
		return $this->addUser($this->v_path.'eleves',compact('msClasses','msEleves','classe'));
	} 
	
	
	public function eleves_status(Request $request){
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$enfantStatus = StatusEnfant::all();
			
		$msEleves = [];
		$status = false;
			
		if($request->status){
			$status = StatusEnfant::find($request->status);
			$msEleves = MsEleve::with('enfant','msClasse.msPromotion.section')
							->where('ms_annee_scolaire_id', $id_annee)
							->where('ecole_id', $ecole_id)
							->where('status_enfant_id',$request->status)
							->get();
			$msEleves = $msEleves->sortBy(function ($eleve, $key) {
				return $eleve->msClasse->msPromotion->section_id.$eleve->msClasse->classe.$eleve->enfant->nom.$eleve->enfant->postnom.$eleve->enfant->prenom;
			});

			$msEleves = $msEleves->values()->all();
		}
		
		// return redirect()->back();
		return $this->addUser($this->v_path.'eleves_status',compact('enfantStatus','msEleves','status'));
	} 
	
	// ...
	public function fiche_electronique(Request $request){

		$ecole_id = Config::getEcoleId();
		$id_annee = \App\Config::getIdAnnee();

		// $msClasses = MsClasse::with('msPromotion.section')->get();
        // $msClasses = MsClasse::select('*')->raw('PARTITION (p'.$ecole_id.')')->get();
        
        $msClasses = \DB::select("SELECT cl.*,nom_sec,promotion FROM bulletin_ms_classes PARTITION (p$ecole_id) cl inner join bulletin_ms_promotions p on p.id=cl.ms_promotion_id inner join bulletin_sections s on s.id=p.section_id ");
        
        //$employees = \DB::table('bulletin_ms_classes')
        //->join('bulletin_ms_promotions', 'bulletin_ms_classes.ms_promotion_id', '=', 'bulletin_ms_promotions.id')
        //->select('bulletin_ms_classes.*', 'bulletin_ms_promotions.*')->get();
        
        //dd($employees);
        //->selectRaw('SUM(visitors_new) AS new, SUM(visitors_total) AS total')
        // ->raw('PARTITION (p' . $venue_filter . ')')
		$msEleves = [];

		$classes = [];

		$id_classe = [];

		$type_liste = '';

		$excel = false;

		if($request->ms_classe_id){

		    $type_liste = $request->type_liste;

		    $id_classe = $request->ms_classe_id;

			/*$classes = MsClasse::with('msPromotion.section')->whereIn('id',$id_classe)->get()->sortBy(function ($cl, $key) {

				return $cl->msPromotion->section->nom_sec.' '.$cl->classe;

			});*/
			$tab_idcl =  implode(",",$id_classe);
			$classes = \DB::select("SELECT cl.*,nom_sec,promotion FROM bulletin_ms_classes PARTITION (p$ecole_id) cl 
			inner join bulletin_ms_promotions p on p.id=cl.ms_promotion_id 
			inner join bulletin_sections s on s.id=p.section_id where cl.id in ($tab_idcl)
			order by nom_sec,classe");
        
            $reqElv="select matricule,nom,postnom,prenom,genre,classe,doubleur from bulletin_ms_eleves partition(p$ecole_id) el 
            inner join enfants e on el.enfant_id=e.id
            inner join bulletin_ms_classes partition(p$ecole_id) cl on cl.id=el.ms_classe_id 
            where el.ms_annee_scolaire_id= $id_annee and etat='Actif' and el.ms_classe_id in  ($tab_idcl) ";

			if($type_liste=="pres"){
		        $msEleves = collect(\DB::select($reqElv));
		    }

		    elseif($type_liste=="eleve" ){
		        $msEleves = collect(\DB::select($reqElv));
		    }

		    elseif($type_liste=="deliberation" ){

		        $req = "select nom,prenom,postnom,genre,matricule,classe 

		        from `bulletin_ms_eleves` partition(eleves_$id_annee) EL 

		        inner join enfants e on EL.enfant_id=e.id inner join

		        bulletin_ms_classes cl on cl.id=EL.ms_classe_id 

		        where ms_classe_id in (".implode("," ,$id_classe).") and etat='Actif' ";

			    $msEleves = collect(\DB::select($req));

		        /*$msEleves = MsEleve::with('enfant','msClasse')

										->whereIn('ms_classe_id',$id_classe)

										->where(['ms_annee_scolaire_id'=>$id_annee,'etat'=>'Actif'])

										->get();*/

		    }

		    elseif($type_liste=="palma" ){ 

		        $msEleves = MsEleve::with('enfant','msClasse')

										->whereIn('ms_classe_id',$id_classe)

										->where('pourcentage','>=',75)

										->where(['ms_annee_scolaire_id'=>$id_annee,'etat'=>'Actif'])

										->get();

		    }

		    elseif($type_liste=="code_secret"){

		        $msEleves = collect(\DB::select('SELECT * FROM `code_et_matricule` where ms_classe_id in ('.implode(",",$id_classe).') AND  ms_annee_scolaire_id=\''.$id_annee."'"));

		    }

		    else{

			    $msEleves = MsEleve::with('enfant','tuteur','msClasse.msPromotion.section')

										->whereIn('ms_classe_id',$id_classe)

										->where('ms_annee_scolaire_id',$id_annee )

										->where('etat','Actif')

										->get();

		        

		    }

		    if(in_array($type_liste,["deliberation","code_secret","eleve","pres"]))

    		    $msEleves = $msEleves->sortBy(function ($eleve, $key) {

    				return $eleve->nom.' '.$eleve->postnom.' '.$eleve->prenom;

    			})

    			->groupBy(function ($el, $key) {

    				return $el->classe;

    			});

			else 

    			$msEleves = $msEleves->sortBy(function ($eleve, $key) {

    				return $eleve->enfant->nom.' '.$eleve->enfant->postnom.' '.$eleve->enfant->prenom;

    			})
    			->groupBy(function ($el, $key) {

    				return $el->msClasse->classe;

    			});

			//dd($msEleves);

			//$msEleves = $msEleves->values()->all();

		}

		if($excel)return $this->addUser($this->v_path.'fiche_excel');

		// return redirect()->back();

		return $this->addUser($this->v_path.'fiche_electronique',compact('msClasses','msEleves','classes','id_classe','type_liste'));

	}

	
	public function fiche_electroniquee(Request $request){
		$id_annee = \App\Config::getIdAnnee();
		
		$ecole_id = Config::getEcoleId();
		$msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get();
		
		$msEleves = [];
		$classes = [];
		$id_classe=[]; 
		if($request->ms_classe_id){
			$id_classe = $request->ms_classe_id; 
			$classe = MsClasse::with('msPromotion.section')->whereIn('id',$id_classe)->get();//find($id_classe);
			$msEleves = MsEleve::with('enfant','tuteur','msClasse.msPromotion.section')
										->whereIn('ms_classe_id',$id_classe)
										->where('ms_annee_scolaire_id',$id_annee)
										->get(); 
			$msEleves = $msEleves->sortBy(function ($eleve, $key) { 
				return $eleve->enfant->nom.' '.$eleve->enfant->postnom.' '.$eleve->enfant->prenom;
			});

			$msEleves = $msEleves->values()->all();
		}
		$type_liste ='';
		// return redirect()->back();
		return $this->addUser($this->v_path.'fiche_electronique',compact('msClasses','msEleves','classes','id_classe','type_liste'));
	} 
	
	public function imprimer_cartes(Request $request,$id_classe,$bg='-',$css='css1'){
		$msEleves = [];
		$ecole_id = Config::getEcoleId();
		
		$msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get();
		
		$id_annee = \App\Config::getIdAnnee();
		$ids = $request->ids??[];
		if($id_classe){
			// $id_classe = $request->ms_classe_id;
			$pro = MsClasse::where('ecole_id',$ecole_id)->where('id',$id_classe)->first()->msPromotion;
			// $classe = MsClasse::with('msPromotion.section')->find($id_classe);
			$msEleves = MsEleve::with('enfant','tuteur','msClasse.msPromotion.section','parentEnfant')
							//->where('ms_classe_id',$id_classe)
							->where('ecole_id',$ecole_id)
							->where('ms_annee_scolaire_id',$id_annee);
							if(!$request->select_printed_card)
							    $msEleves = $msEleves->whereNull('carte_imprimee_le');;
							
			if($ids)
			    $msEleves = $msEleves->whereIn('ms_classe_id',$ids);
			else 
			    $msEleves = $msEleves->whereHas('msClasse.msPromotion', function($q) use($pro){
									return $q
									->where('section_id', $pro->section_id)
									->where('niveau', $pro->niveau)
									->orWhere('niveau', $pro->niveau+1)
									->where('section_id', $pro->section_id)
									->orWhere('niveau', $pro->niveau-1)
									->where('section_id', $pro->section_id)
									;
							});
			
			$msEleves = $msEleves->get()->sortBy(function ( $msEleve,  $key) {
                                return (($msEleve->img?'1':'2').' ').$msEleve->msClasse->classe.' '.$msEleve->enfant->nom.' '.$msEleve->enfant->postnom.' '.$msEleve->enfant->prenom;
                            });
		}
		// dd($msEleves);
		// $css = $request->css;
		// return redirect()->back();
		return $this->addUser($this->v_path.'imprimer_cartes',compact('msClasses','ids','msEleves','bg','css','id_classe'));
	} 
	public function imprimer_macarte($id,$bg='-',$css='css1'){
		$msEleves = [];
		if($id){
			$msEleves = MsEleve::with('enfant','tuteur','msClasse.msPromotion.msAnneeScolaire.ecole','msClasse.msPromotion.section')
										->where('id',$id)
										->get();
		}
		return $this->addUser($this->v_path.'imprimer_macarte',compact('msEleves','bg','css','id'));
	} 
	
	public function faire_payer_cartes(Request $request){
		$id_annee = Config::getIdAnnee();
        $ecole_id = Config::getEcoleId();
    
        /* ================= SQL DE BASE ================= */
        $sql = "
            SELECT 
                el.id,
                el.img,
                classe,
                matricule,
                nom,
                postnom,
                prenom,
                genre,
                nom_sec,
                telephone,
                nom_tuteur,
                lien_avec_eleve,
                tuteur_id,
                1 as ponderation
            FROM bulletin_ms_eleves PARTITION (p$ecole_id) el
            INNER JOIN enfants ef ON el.enfant_id = ef.id
            INNER JOIN bulletin_ms_classes partition (p$ecole_id) cl ON cl.id = el.ms_classe_id
            INNER JOIN bulletin_ms_promotions p ON cl.ms_promotion_id = p.id
            INNER JOIN bulletin_sections s ON s.id = p.section_id
            LEFT JOIN tuteurs t ON t.id = el.tuteur_id
            WHERE el.ms_annee_scolaire_id = $id_annee
              AND el.etat = 'Actif'
        ";
            // LEFT JOIN status_enfants st ON st.id = el.status_enfant_id
    
        /* ================= FILTRES DE RECHERCHE ================= */
        
    
        $rows = \DB::select($sql);
    
        /* ================= FORMAT SELECT2 ================= */
        $items = [];
    
        foreach ($rows as $e) {
    
            $noms = trim(
                $e->nom . ' ' .
                $e->postnom . ' ' .
                $e->prenom . ' ' .
                $e->genre 
                // $e->classe
            );
    
            $attrs = [
                'classe' => $e->classe . ' ' . $e->nom_sec,
                'id'     => "option-eleve-$e->id",
                'img'    => asset('storage/mseleve/img/'.$e->img),
                'mat'    => $e->matricule,
                'nom'    => $noms,
                'IDINSC' => $e->id,
                'tel'    => $e->tuteur_id ? $e->telephone : '+243............',
                'tut'    => $e->tuteur_id ? $e->nom_tuteur : '',
                'lien'   => $e->tuteur_id ? $e->lien_avec_eleve : '',
                'pond'   => $e->ponderation,
                'IDTUT'  => $e->tuteur_id ?? 'null',
            ];
    
            $items[] = [
                'id'    => $e->id,
                'text'  => $noms,
                'attrs' => $attrs
            ];
        }
        $classes = \DB::select("
            SELECT
                cl.id,
                CONCAT(cl.classe,' ',s.nom_sec) AS libelle
            FROM bulletin_ms_classes partition (p$ecole_id) cl
            INNER JOIN bulletin_ms_promotions p ON p.id = cl.ms_promotion_id
            INNER JOIN bulletin_sections s ON s.id = p.section_id
        ");
        $classesSelect2 = [];

        foreach ($classes as $c) {
            $classesSelect2[] = [
                'id'   => $c->id,
                'text' => $c->libelle
            ];
        }
		
		return $this->addUser($this->v_path.'faire_payer_carte',compact('items', 'classesSelect2'));
	} 
	public function saveOperations(Request $request)
    {
        $data = [];
    
        if ($request->filled(['payer_carte_le', 'montant_carte'])) {
            $data['payer_carte_le'] = $request->payer_carte_le;
            $data['montant_carte']  = $request->montant_carte;
        }
    
        if ($request->filled('carte_remise_le')) {
            $data['carte_remise_le'] = $request->carte_remise_le;
        }
    
        if ($request->filled('rame_papier_deposee_le')) {
            $data['rame_papier_deposee_le'] = $request->rame_papier_deposee_le;
        }
    
        if (empty($data)) {
            return response()->json([
                'status' => 'error',
                'message' => 'Aucune opération sélectionnée'
            ], 422);
        }
    
        \DB::table('bulletin_ms_eleves')
            ->whereIn('id', $request->id_eleves)
            ->update($data + ['updated_at' => now()]);
    
        return response()->json([
            'status' => 'success',
            'message' => 'Opérations enregistrées avec succès'
        ]);
    }
    public function rapportPayerCartes(Request $request)
    {
        $ids = $request->ids;
        $ecole_id = Config::getEcoleId();
    
        $idsSql = implode(',', array_map('intval', $ids));
    
        $sql = "
            SELECT
                el.id,
                CONCAT(ef.nom,' ',ef.postnom,' ',ef.prenom) AS nom,
                el.payer_carte_le,
                el.montant_carte,
                el.carte_remise_le,
                el.rame_papier_deposee_le
            FROM bulletin_ms_eleves PARTITION (p$ecole_id) el
            INNER JOIN enfants ef ON ef.id = el.enfant_id
            WHERE el.id IN ($idsSql)
        ";
    
        return response()->json(\DB::select($sql));
    }
    
    public function xx(Request $request)
    {
        $ids = $request->ids;
        $ops = $request->ops;
        $ecole_id = Config::getEcoleId();
    
        $idsSql = implode(',', array_map('intval', $ids));
    
        $conditions = [];
    
        if (!empty($ops['paiement'])) {
            $conditions[] = "(el.payer_carte_le IS NULL OR el.montant_carte IS NULL)";
        }
    
        if (!empty($ops['remise'])) {
            $conditions[] = "el.carte_remise_le IS NULL";
        }
    
        if (!empty($ops['rame'])) {
            $conditions[] = "el.rame_papier_deposee_le IS NULL";
        }
    
        if (empty($conditions)) {
            return response()->json([]);
        }
    
        $whereOps = implode(' OR ', $conditions);
    
        $sql = "
            SELECT
                el.id,
                CONCAT(ef.nom,' ',ef.postnom,' ',ef.prenom) AS nom,
                el.payer_carte_le,
                el.montant_carte,
                el.carte_remise_le,
                el.rame_papier_deposee_le
            FROM bulletin_ms_eleves PARTITION (p$ecole_id) el
            INNER JOIN enfants ef ON ef.id = el.enfant_id
            WHERE el.id IN ($idsSql)
              AND ($whereOps)
        ";
    
        return response()->json(\DB::select($sql));
    }
    public function rapportPayerCartes_non_enordre(Request $request)
    {
        $eleves  = $request->eleves ?? [];
        $classes = $request->classes ?? [];
        $ops     = $request->ops;
        $ecole_id = Config::getEcoleId();
    
        $where = [];
    
        if (!empty($eleves)) {
            $ids = implode(',', array_map('intval', $eleves));
            $where[] = "el.id IN ($ids)";
        }
    
        if (!empty($classes)) {
            $cls = implode(',', array_map('intval', $classes));
            $where[] = "el.ms_classe_id IN ($cls)";
        }
    
        $opsCond = [];
    
        if (!empty($ops['paiement'])) {
            $opsCond[] = "(el.payer_carte_le IS NULL OR el.montant_carte IS NULL)";
        }
    
        if (!empty($ops['remise'])) {
            $opsCond[] = "el.carte_remise_le IS NULL";
        }
    
        if (!empty($ops['rame'])) {
            $opsCond[] = "el.rame_papier_deposee_le IS NULL";
        }
    
        if (empty($opsCond)) {
            return response()->json([]);
        }
    
        $where[] = '(' . implode(' OR ', $opsCond) . ')';
    
        $sql = "
            SELECT
                el.id,
                CONCAT(ef.nom,' ',ef.postnom,' ',ef.prenom) AS nom,
                el.payer_carte_le,
                el.montant_carte,
                el.carte_remise_le,
                el.rame_papier_deposee_le
            FROM bulletin_ms_eleves PARTITION (p$ecole_id) el
            INNER JOIN enfants ef ON ef.id = el.enfant_id
            WHERE " . implode(' AND ', $where);
    
        return response()->json(\DB::select($sql));
    }
    public function annulerPayerCartes(Request $request)
    {
        $ids = $request->ids ?? [];
        if (!$ids || !is_array($ids)) {
            return response()->json(['success' => false, 'message' => 'Aucun élève sélectionné']);
        }
    
        $paiement = $request->paiement ? true : false;
        $remise = $request->remise ? true : false;
        $rame = $request->rame ? true : false;
    
        $setFields = [];
        if ($paiement) {
            $setFields[] = "payer_carte_le = NULL";
            $setFields[] = "montant_carte = NULL";
        }
        if ($remise) $setFields[] = "carte_remise_le = NULL";
        if ($rame) $setFields[] = "rame_papier_deposee_le = NULL";
    
        if (count($setFields)) {
            $idsString = implode(',', array_map('intval', $ids)); // sécurité
            $sql = "UPDATE bulletin_ms_eleves SET " . implode(',', $setFields) . " WHERE id IN ($idsString)";
            \DB::statement($sql);
        }
    
        // Retourner les élèves mis à jour pour le rapport
        $idsString = implode(',', array_map('intval', $ids));
        $data = \DB::select("
            SELECT el.id, CONCAT(ef.nom,' ',ef.postnom,' ',ef.prenom) as nom,
                   el.payer_carte_le, el.montant_carte, el.carte_remise_le, el.rame_papier_deposee_le
            FROM bulletin_ms_eleves el
            INNER JOIN enfants ef ON el.enfant_id = ef.id
            WHERE el.id IN ($idsString)
        ");
    
        return response()->json(['success' => true, 'data' => $data]);
    }
    public function fairePayerCarterapportElevesOrdre(Request $request) {
        $classes = $request->classes; // array d'IDs ou null
        $ecole_id = Config::getEcoleId();
    
        // Colonnes dynamiques selon cases cochées
        $selectCols = ['el.id', \DB::raw("CONCAT(ef.nom,' ',ef.postnom,' ',ef.prenom) as nom")];
        if($request->paiement) {
            $selectCols[] = 'el.payer_carte_le';
            $selectCols[] = 'el.montant_carte';
        }
        if($request->remise) $selectCols[] = 'el.carte_remise_le';
        if($request->rame) $selectCols[] = 'el.rame_papier_deposee_le';
    
        $whereClause = '';
        if($classes && count($classes)) {
            $whereClause = "WHERE el.ms_classe_id IN (".implode(',', $classes).")";
        }
    
        $data = \DB::select("
            SELECT ".implode(',', $selectCols)."
            FROM bulletin_ms_eleves el
            INNER JOIN enfants ef ON el.enfant_id = ef.id
            $whereClause
            ORDER BY el.ms_classe_id, ef.nom, ef.postnom, ef.prenom
        ");
    
        return ['success' => true, 'data' => $data];
    }




	public function classes(Request $request){
		$ecole_id = Config::getEcoleId();
		$id_annee = \App\Config::getIdAnnee();
		$sections = Section::all();
		$msAnneeScolaires = MsAnneeScolaire::all();
		$msClasses = MsClasse::with('msPromotion.section')->where('ecole_id',$ecole_id)->get();
		$mspromotion = new MsPromotion;
		$msPromotions = MsPromotion::with('section')->get();
		$msclasse = new MsClasse;
		$section = new Section;
		
		return $this->addUser($this->v_path.'classes',compact('section','mspromotion','msAnneeScolaires','sections','msclasse','msClasses','msPromotions'));
	} 	
	public function inscrire(Request $request)
    {
		$tab_frais = $request->id_frais;
		$form_rapide = $request->form_rapide;

		$rules = [];
		$eleve = $classe = $parent = $tuteur = $enfant = $inscription = null;
		$id_paiements = $id_eleves = null;
		$data = AjaxValidator::request_data(
			['matricule','nom','postnom','prenom','genre','datenaiss','lieunaiss',
			'montant','ms_classe_id','nom_tuteur','telephone','adresse','id_enfant','id_tuteur','papa','maman'
			],
			$request
		);
		$id_enfant = $request->id_enfant;
		if($request->has('ms_eleve_id')){
			$id_enfant = MsEleve::find($request->ms_eleve_id)->enfant_id;
			//$rules['ms_eleve_id']='required|numeric';
			//dd($id_enfant);
		}
		else if($id_enfant)$rules['id_enfant']='required|numeric';

		$enfant_existe = $id_enfant;// and !empty($request->id_enfant) and $request->id_enfant!== null;
		$tuteur_existe = $request->has('id_tuteur') and !empty($request->id_tuteur)
		and $request->id_tuteur>0
		and $request->id_tuteur!= 'null'
		and $request->id_tuteur!= ''
		and !is_null($request->id_tuteur);
		$parent_existe = $request->has('parent_enfant_id') and !empty($request->parent_enfant_id)and $request->parent_enfant_id!= '';
		
		// dd($parent_existe,$enfant_existe,$tuteur_existe,$request);
		if( !$enfant_existe ){
			$rules = [
				'matricule'=>$request->matricule?'required|unique:enfants':'',
				'nom'=>'required|min:3',
				'postnom'=>'required|min:3',
				'prenom'=>'required|min:3',
				
				'ms_classe_id'=>'required|numeric',
			];
		}
		else{
			$rules = [
				'ms_classe_id'=>'required|numeric',
			];
		}

		/* if( !is_array($tab_frais) ){
			$rules['Frais_inscription']='required';
		} */
		
		$tuteur=null;
		if( !$tuteur_existe ){
			if($enfant_existe){				
				$eleves = Enfant::with('msEleves.tuteur')->find($id_enfant)->msEleves;
				if($eleves){
					$id_tuteur = $eleves->sortByDesc('ms_annee_scolaire_id')->first()->tuteur_id;
					if($id_tuteur){
						$tuteur_existe = true;
						$tuteur = Tuteur::find($id_tuteur);
					}
				}
			}
			if(!$tuteur_existe and (!$form_rapide)){
				$rules['telephone']='numeric|unique:tuteurs';
				$rules['nom_tuteur']='required|min:3';
			}			
		}
		else if($request->id_tuteur) $tuteur = Tuteur::find($request->id_tuteur);
				
		
		// on exécute les régles de validation sur les données
		$result = AjaxValidator::validate($data,$rules);
		if($result!==true)
			return $result;
		// si toutes les regles réussissent
		\DB::beginTransaction();
		try {
			$msClasse = MsClasse::find($request->ms_classe_id);
				// enregistrement des parents
				if( !$parent_existe and ($request->papa or $request->maman)){
					$ad_mere = $request->adresse_maman;
					$ad_pere = $request->adresse_papa;
					if($request->adresse_parent){
						$ad_mere = $ad_pere = $request->adresse_parent;
					}
					
					$papa_deceder = $request->papa_deceder?$request->papa_deceder_en:false;
					$maman_deceder = $request->maman_deceder?$request->maman_deceder_en:false;
					$parent_separer = $request->parent_separer_en?$request->parent_separer_en:false;

					$parent = ParentEnfant::firstOrCreate(['telephone_pa'=> str_replace(' ','',$request->telephone_pa),'telephone_ma'=> str_replace(' ','',$request->telephone_ma)],[
						'papa'=>$request->papa
						,'profession_pa'=>$request->profession_pa
						,'adresse_papa'=>$ad_pere
						,'papa_deceder'=>$papa_deceder
						,'maman'=>$request->maman						
						,'profession_ma'=>$request->profession_ma
						,'adresse_maman'=>$ad_mere
						,'maman_deceder'=>$maman_deceder
						,'parent_separer'=>$parent_separer
						]
					);
				}
				else if($request->parent_enfant_id) $parent = ParentEnfant::find($request->parent_enfant_id);
								
				// database queries here
				if( !$enfant_existe){
					$enfant = Enfant::create([
					'matricule'=>$request->matricule
					,'nom'=>$request->nom
					,'postnom'=>$request->postnom
					,'prenom'=>$request->prenom
					,'genre'=>$request->genre
					,'datenaiss'=>$request->datenaiss
					,'lieunaiss'=>$request->lieunaiss
					,'parent_enfant_id'=>$parent->id??null
					,'nationalite'=>$request->nationalite
					,]);
					if(!$request->matricule){
						$enfant->update(['matricule'=>($request->nom[0]??'-').($request->postnom[0]??'-').sprintf('%03.d',$enfant->id).'-'.date('y')]);
					}
					
				}
				else {
					$enfant = Enfant::with('msEleves.msPromotion','msEleves.ecole')->find($id_enfant);
					// tester si l'enfant est deja inscrit au cours de cette annee
					$el = $enfant->msEleves->where('ms_annee_scolaire_id',Config::getIdAnnee())->first();
					if($el){
						$message = "<b>$enfant->nom $enfant->postnom $enfant->prenom</b> est déjà inscrit en <b>".$el->msPromotion->promotion." ".$el->ecole->nom_ecole."</b> au cours de cette année";
						$result = "fail";
						return compact('result','message');
						//return [];
					}
					//dd($el);
				}
				
				// enregistrement du tuteur
				if( !$tuteur_existe and $request->nom_tuteur){
					$tuteur = Tuteur::create(['nom_tuteur'=>$request->nom_tuteur
					,'telephone'=> str_replace(' ','',$request->telephone)
					,'adresse'=>$request->adresse
					,'lien_avec_eleve'=>$request->lien_avec_eleve
					,'adresse_mail'=>$request->adresse_mail
					,]);
				}
				
				$datas = [
					'enfant_id'=>$enfant->id,
					'inscrit_le'=>$request->date??date("Y-m-d"),
					'ms_classe_id'=>$msClasse->id,
					'ms_promotion_id'=>$msClasse->ms_promotion_id,
					'ecole_id'=>$msClasse->ecole_id,
					'ms_annee_scolaire_id'=>Config::getIdAnnee(),
					'etat'=>'Actif',
					'status_enfant_id'=>null
					,'classer'=>false
					,'tuteur_id'=>$tuteur->id??null
					,'religion_id'=>$request->religion_id
					,'motivation_eleve'=>$request->motivation_eleve
					,'pro_classe'=>$request->pro_classe
					,'pro_ecole'=>$request->pro_ecole
					,'pourcentage'=>$request->pourcentage
				];
				$eleve = MsEleve::create($datas);
				
				// enregistrement de l'image de l'enfant
				if($eleve and $request->val_img_enfant){					
					$image_array_1 = explode(";", $request->val_img_enfant);	
					$image_array_2 = explode(",", $image_array_1[1]);
					$data = $image_array_2[1];
					$data = str_replace(' ', '+', $data);
					$data = base64_decode($data);
					$n = $eleve->id.'.jpg';
					$folder = 'storage/mseleve/img';
					if(!file_exists($folder))
						mkdir($folder,0777,true);
					file_put_contents("$folder/$n", $data);
					$eleve->img = $n;
					$eleve->save();
					// if($n = chado_saveFile('public/msinscription/img_enfant/','img_enfant',$inscription->id)){
					// 	$inscription->img_enfant = $n;
					// 	$inscription->save();
					// }
				}
				
				// classement direct de l'enfant
				if(false and $request->classer_direct){
					$insc = MsInscription::with('msPromotion.msClasses.msEleves')->find($inscription->id);
					$classes = $insc->msPromotion->msClasses;
					// les classes disponibles dans la promotion
					// trouver celle ou il y a moins de filles ou de garcons
					if($classes->count()){
						$pte_cls = $classes->first();// la 1ere classe
						$moin_el = $pte_cls->mseleves->filter(function ($el, $key) use($enfant){
							return $el->genre == $enfant->genre;
						})->count();
						foreach($classes as $clas){							
							$plus_el = $clas->mseleves->filter(function ($el, $key) use($enfant){
								return $el->genre == $enfant->genre;
							})->count();
							// comparaison des deux effectifs
							if($moin_el > $plus_el){
								$moin_el = $plus_el;
								$pte_cls = $clas;
							}
						}
						$datas = [
							'enfant_id'=>$enfant->id,
							'ms_classe_id'=>$pte_cls->id,
							'inscrit_le'=>date('Y-m-d'),
							'ms_inscription_id'=>$inscription->id,
							'etat'=>'Actif',
							'status_enfant_id'=>1,
						];
						$eleve = MsEleve::create($datas);
						$classe = $pte_cls->classe;
					}
				}
				
				$classe = $msClasse->classe;
				
				// enregistrement des elements du dossier
				$elementDossierEnfants = ElementDossierEleve::all();
				foreach($elementDossierEnfants as $e){
					$id = $e->id;
					if($request->has("document_$id")){
						$dossier = DossierEnfant::create(['element_dossier_eleve_id'=>$id,'ms_eleve_id'=>$eleve->id]);
						if(request()->file('scan_element_dossier_'.$id) and count(request()->file('scan_element_dossier_'.$id))){
							$folder = 'public/imgdossierenfant/scan/';
							foreach(request()->file('scan_element_dossier_'.$id) as $f){
								$datas = [
								'dossier_enfant_id'=>$dossier->id,
								];
								$img = ImgDossierEnfant::create($datas);
								$uploadedFile = $f;
								$filename = false;
								if($uploadedFile){
									$filename = $img->id.'.'.$uploadedFile->getClientOriginalExtension();
									$path = \Storage::disk('local')->putFileAs(
										$folder,
										$uploadedFile,
										$filename
									);
									$img->scan = $filename;
									$img->save();
								}
							}
						}					
					}
				}

				// paiement des litiges
				/* if($arrierer){
					$arrierer = $mp->arrierer_paiement($eleve->enfant_id,0);
					
					$litige = $paiementController->valider_paiement_arrierer_val($eleve->id,
					$request->mp_type_frais_id,
					$request->mp_frais_classe_id,
					$request->montant_cdf??0,$request->montant_usd??0,$send_sms);
				} */
				
				
				// fin paiemebt

				$msg = "Votre enfant $enfant->nom $enfant->postnom $enfant->prenom A ETE inscrit en $classe, au ".\App\Config::getEcole()." ANNEE ".\App\Config::getAnnee();
				if($eleve and is_array($tab_frais) and count($tab_frais)){
					// paiement des frais
					$paiementController = new MPaymentController();
					$return = $paiementController->verifier_eleve_el_payer($request,$eleve->id ,$tab_frais,$send_sms=false);
					$message = count(isset($return['result'])?$return['result']:[])? implode("<hr>",$return['result']):"";
					$id_paiements = [$return['recu']]??[];
					$id_eleves = [$eleve->id];
					$sms_text = implode("; ",$return['sms_text']);
					if($tuteur->telephone??false)
						ms_sms($tuteur->telephone,$msg.' et A PAYE '.$sms_text);
					//return compact('result','message','id_paiements','id_eleves');
				}	
				else if($tuteur->telephone??false){
					$message = "INSCRIPTION FAITE ET AUCUN FRAIS PAYE";
					ms_sms($tuteur->telephone,$msg.' ET N\'A PAYE AUCUN FRAIS');
				}
			\DB::commit();
		} catch (\PDOException $e) {
				// Woopsy
				\DB::rollBack();
				$result = 'fail';
				$message = "Erreur transaction!<br>".$e->errorInfo[2];
				//dd($e->errorInfo[2]);
				return compact('result','message','e');
		}
				
		flash("Enregistrement effecté avec succès");
		$result = 'success';
		$token = csrf_token();
		return compact('result','token','eleve','classe','tuteur','enfant','inscription','id_paiements','id_eleves','message');
		//redirect()->route('enfants.index', compact() );
        //
    }

	public function vider_les_table(){
		/*\DB::select("TRUNCATE enfants;");
		\DB::select("TRUNCATE ms_eleves;");
		\DB::select("TRUNCATE ms_inscriptions;");
		\DB::select("TRUNCATE img_documents; ");
		\DB::select("TRUNCATE img_dossier_enfants;");
		\DB::select("TRUNCATE jour_ouvrables; ");
		\DB::select("TRUNCATE justif_absences; ");
		\DB::select("TRUNCATE md_absences; ");
		\DB::select("TRUNCATE md_commentaires;");
		\DB::select("TRUNCATE md_eleve_renvoyers; ");
		\DB::select("TRUNCATE md_presences; ");
		\DB::select("TRUNCATE md_retards; ");
		\DB::select("TRUNCATE mouvement_comptes;");
		\DB::select("TRUNCATE mp_frais_paiements; ");
		\DB::select("TRUNCATE mp_recus; ");
		\DB::select("TRUNCATE tuteurs;");*/
		return redirect()->back();
	}

	public function supprimer_inscription(Request $request){
		if($request->method()=="POST"){
			$req='';
			if($request->sup_dossier){
				$req = "DELETE FROM `dossier_enfants` WHERE `ms_eleve_id` = $request->sup_dossier ; ";
				\DB::delete($req);
			}
			if($request->sup_parent){
				$req = "DELETE FROM `parent_enfants` WHERE `id` = $request->sup_parent ; ";
				//\DB::select($req);
				\DB::table('parent_enfants')->delete($request->sup_parent);
			}
			if($request->sup_tuteur){
				$req = "DELETE FROM `tuteurs` WHERE `id` = $request->sup_tuteur ; ";
				//\DB::select($req);
				\DB::table('tuteurs')->delete($request->sup_tuteur);
			}
			if($request->sup_enfant){
				$req = "DELETE FROM `enfants` WHERE `id` = '$request->sup_enfant' ;";
				//\DB::select($req);		
				\DB::table('enfants')->delete($request->sup_enfant);
			}
			if($request->sup_paiement){
				\DB::table('mp_frais_paiements')->where('ms_eleve_id', $request->sup_paiement)->delete();
				\DB::table('mp_recus')->where('ms_eleve_id', $request->sup_paiement)->delete();	
			}
			if($request->sup_cotes){
						
				\DB::table('bulletin_mr_cotes')->where('ms_eleve_id', $request->sup_cotes)->delete();	
			}
			if($request->sup_inscription){
				$req = "DELETE FROM `bulletin_ms_eleves` WHERE `id` = $request->sup_inscription ; ";
				
				//\DB::select($req);		
				\DB::table('bulletin_ms_eleves')->delete($request->sup_inscription);			
			}
			return redirect()->back();
		}
		$id = $request->ms_eleve_id;
		$insc = MsEleve::with('dossierEnfants.elementDossierEleve','enfant','msPromotion','msAnneeScolaire','tuteur',
		'enfant.parentEnfant','religion','mpFraisPaiements.mpFraisClasse.mpFrais')->find($request->ms_eleve_id);
		return $this->addUser($this->v_path.'_supprimer_inscription',compact('insc'));
	}

	public function resultat_test_importation(Request $request)
    {
		$excel =  new EleveResultTestImport();
		\Excel::import($excel, $request->file('select_file')); // on importe
		if($excel->error)
			session()->flash('error',$excel->error);
		return  redirect()->back();
	}
	public function allocationmat(Request $request)
    {
        
		// dd(session()->all());
		if($request->method()=="POST"){
			if($request->delete_emprunt){
				$mat = EmpruntMateriel::destroy($request->id);
				
				my_flash("Enregistrement effecté avec succès");
			}
			else if($request->approvisionner_materiel){
				$mat = Materiel::find($request->materiel_id);
				$data['quantite'] = $mat->quantite + $request->quantite;
				if($request->rename != "" )
					$data["materiel"] = $request->rename;
				
				$mat->update($data);
				//return "OK";
				my_flash("Enregistrement effecté avec succès");
			}
			else if($request->ajouter_materiel){
				$data = [					
					'atelier_id'=>$request->atelier_id,  
					'materiel'=>$request->materiel,
					'model'=>$request->model,
					'quantite'=>$request->quantite,
					'observation'=>$request->observation
				];
				Materiel::firstOrCreate($data);
				my_flash("Enregistrement effecté avec succès");
			}
			else if($request->id_eleve and $request->materiel_id){
				$msg='';
				foreach($request->materiel_id as $materiel_id){
					$mat = Materiel::with('empruntMateriels')->find($materiel_id);
					$sotck = $mat->quantite - $mat->empruntMateriels->sum('quantite')+$mat->empruntMateriels->sum('qte_retour');
					foreach($request->id_eleve as $ms_eleve_id){
						if($sotck>=$request->quantite){
							$data = [
								'ms_eleve_id'=>$ms_eleve_id,
								'materiel_id'=>$materiel_id,
								'quantite'=>$request->quantite,
								'date_emprunt'=>$request->date_emprunt,
								//'qte_retour'=>$request->qte_retour,
								//'date_retour'=>$request->date_retour,
								//'img_aller'=>$request->img_aller,
								//'img_retour'=>$request->img_retour,
							];
							EmpruntMateriel::firstOrCreate($data);
							$sotck-=$request->quantite;
						}
						else $msg.="$mat->materile [stock 0 ] impossible d'allouer! <br> ";
					}
					$mat->update(['quantite'=>$sotck]);
				}
				if($msg)
					my_flash($msg,"error");
				else my_flash("Enregistrement effecté avec succès");
			}
			return  redirect()->back();
		}
		$ateliers = Atelier::all();
		$materiels = Materiel::all();
		//dd($materiels);
		$empruntmateriels = EmpruntMateriel::with('materiel','msEleve.enfant')->get();
		return $this->addUser($this->v_path.'allocationmateriels',compact('empruntmateriels','materiels','ateliers'));
	}

	public function derrogation_info(Request $request)
    {
		// 
		$eleves = array();
		$id_frais = $request->id_frais;
		if($request->id_eleves and is_array($request->id_eleves)){
			foreach($request->id_eleves as $id){
				$el = MsEleve::with('enfant','mpFraisPaiements.mpFraisClasse.mpFrais')->find($id);
				$fraisClasse = MpFraisClasse::with('mpFrais')->where('mp_frais_id',$id_frais )->where('ms_classe_id',$el->ms_classe_id )->first();

				$eleves[] = [$el,$fraisClasse];
			}
		}
		return $this->addUser($this->v_path.'_derogation_info',compact('eleves','id_frais'));
	}

	private function derroger($request){
		$data = [
			'motif'=>$request->motif,
			'telephone'=>$request->telephone,
			'date_butoire'=>$request->date_butoire,
			'lien_demandeur'=>$request->lien_demandeur,
			'demandeur'=>$request->demandeur,
			'add_mail'=>$request->add_mail,
			'expirer'=>false,
		];
		$rules = [
			'motif'=>'required',
			'telephone'=>'required',
			'date_butoire'=>'required',
			'lien_demandeur'=>'required',
			'demandeur'=>'required',
			'add_mail'=>'',
			// 'montant'=>'required',
			'expirer'=>'',
		];
		$result = AjaxValidator::validate($data,$rules);
		if($result!==true){
			//dd($result['message']);
			return $result['message'];
			my_flash($result['message'],"error");
			return false;
		}

		$msDerogation = MsDerogation::create($data);
		$montant = $request->montant;
		$id_frais = $request->id_frais;

		foreach($request->id_eleve as $ms_eleve_id){
			$el = MsEleve::with('tuteur')->find($ms_eleve_id);
			$fraisClasse = MpFraisClasse::where('mp_frais_id',$id_frais )->where('ms_classe_id',$el->ms_classe_id )->first();
			$data = [
				'ms_derogation_id'=>$msDerogation->id,
				'ms_eleve_id'=>$ms_eleve_id,
				'mp_frais_classe_id'=>$fraisClasse->id,
				'montant'=>$montant,
			];
			MsEleveDeroger::firstOrCreate($data);
			if(!$el->msInscription->tuteur){
				$tut = Tuteur::firstOrCreate(['telephone'=>$request->telephone],['lien_avec_eleve'=>$request->lien_demandeur,'nom_tuteur'=>$request->demandeur]);
				$el->msInscription->tuteur_id = $tut->id;
				$el->msInscription->save();
			}
		}
		return 'true';
		my_flash('Opération effectée avec succès'); 
	}
	
	private function supprimer_derrogation($request){
		
		$el = MsEleveDeroger::with('msDerogation.msEleveDerogers')->find($request->id);
		if($el)
		MsEleveDeroger::destroy($el->id);
		else 
		my_flash('Enregistrement non existant','error');
		if($el and $el->msDerogation->msEleveDerogers->count()<=1)
			MsDerogation::destroy($el->msDerogation->id);
		return  redirect()->back();
	}
	public function derrogation(Request $request)
    {
		if($request->method()=="POST"){
			if($request->derroger){
				return $this->derroger($request);
			}else if($request->delete_derroger)
				return $this->supprimer_derrogation($request);
			else return 'erreur';
			
		}
		else if($request->print_derrogation)
				return $this->print_derrogation($request);
		
		//
		$id_annee = Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		
		$mpFrais = MpFrais::with('mpFraisClasses.msClasse')
		->whereHas('mpFraisClasses',function($q)use($id_annee,$ecole_id){ return $q
			->whereHas('msClasse',function($q)use($ecole_id){ return $q->where('ecole_id',$ecole_id); })
			->where('ms_annee_scolaire_id',$id_annee); })
		->get();
		$msEleveDerogers = MsEleveDeroger::with('msDerogation','msEleve.enfant')->get()->sortByDesc('id');
		return $this->addUser($this->v_path.'derrogations',compact('msEleveDerogers','mpFrais'));
	}	
	
	public function print_derrogation(Request $request)
    {
		$msEleveDerogers = MsEleveDeroger::with('msDerogation','msEleve.enfant','msEleve.msClasse')->get()
			->sortByDesc(function ($it, $key) {
				return $it->msEleve->enfant->nom.$it->msEleve->enfant->postnom.$it->msEleve->enfant->prenom;
			})
			->groupBy(function ($it, $key) {
				return $it->msEleve->msClasse->classe;//$it->msEleve->enfant->nomm.$it->msEleve->enfant->postnom.$it->msEleve->enfant->prenom;
			})
			->sortKeysDesc();
		return $this->addUser($this->v_path.'derrogations_print',compact('msEleveDerogers'));
	}	
	
	public function resultat_save_preuve_test(Request $request)
    {
		$fail =$msg='';
		$id = $request->ms_inscription_id;
		$insc = MsInscription::find($id);
		if($copie_test = chado_saveFile('public/msinscription/copie_test/','copie_test',$insc->id)){
			$insc->copie_test = $copie_test ;
		}
		if($copie_test = chado_saveFile('public/msinscription/copie_test1/','copie_test1',$insc->id)){
			$insc->copie_test1 = $copie_test ;
		}
			
		$insc->save();
		return compact('id','msg','fail');
		// dd($copie_test );

		$fail ='true';
		$msg = "Document non enregistré au serveur";
		return compact('id','msg','fail');
	}	
	public function ajouter_dossier_eleve(){

	}

	public function fiche_reseignement(Request $request){
		$id = \App\Config::getIdAnnee();
		$ecole_id = Config::getEcoleId();
		$msPromotions = MsPromotion::with(['msClasses'=>function($q)use($ecole_id)
		{return $q->where('ecole_id',$ecole_id);}])
		->get();
		// $msClasses = MsClasse::all();
			$religions = Religion::all();
			$elementDossierEnfants = ElementDossierEleve::all();
			$data = compact(/* 'sysUserRole', */'msPromotions','elementDossierEnfants','religions');
			if($request->has('ms_eleve_id')){
				$DETAIL_INSC = MsEleve::with('dossierEnfants.elementDossierEleve','msPromotion','msAnneeScolaire'
				,'tuteur','enfant.msEleves.msAnneeScolaire','enfant.parentEnfant','religion','msEleveDerogers.msDerogation','msClasse','empruntMateriels.materiel')->find($request->ms_eleve_id);
				$data['DETAIL_INSC'] = $DETAIL_INSC;
				if($request->has('fiche'))
					$data['FICHE'] = true;
				// dd($DETAIL_INSC);
				// dd($data);
				return $this->addUser($this->v_path.'_details_enfant', $data);
			}
			return $this->addUser($this->v_path.'fiche_renseignement', $data);
		
		if ($request->isMethod('get')) {}
	}
	/*$mpfraispaiements = MpFraisPaiement::with(
														'msEleve.enfant',
														'msEleve.msClasse.msPromotion.section',
														'mpFraisClasse.msClasse','mpFraisClasse.mpFrais.mpTypeFrais')
													->where("payer_le" ,'>=',$date1 )
													->where("payer_le" ,'<=',$date2 )
		    ->whereHas('mpFraisClasse.msClasse',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
			//->whereHas('mpFraisClasse',function($q)use($annee_id){return $q->where('ms_annee_scolaire_id',$annee_id);})
		    ->get();
*/
	public function form_inscrire(Request $request){
		if ($request->isMethod('get')) {
		    if($request->has('recherche_id_insc')){
		        $r = \DB::table("inscriptions_eleves")->where("id",$request->recherche_id_insc)->get();
		        if($r)return ["success"=>true,"eleve"=>$r[0]];
		        
		    }
			$id_annee = Config::getIdAnnee();
			$ecole_id = Config::getEcoleId();
			// $mpFrais = MpFrais::All();
			$mpFrais = MpFrais::with('mpFraisClasses.msClasse')
			->whereHas('mpFraisClasses',function($q)use($id_annee,$ecole_id){ return $q
    			->whereHas('msClasse',function($q)use($ecole_id){ return $q->where('ecole_id',$ecole_id); })
    			->where('ms_annee_scolaire_id',$id_annee); })
			->get();/**/
			
			$msPromotions = MsPromotion::with('msClasses')
			->whereHas('msClasses',function($q){ return $q->where('classe','<>',''); })
			//->where('ms_annee_scolaire_id',$id_annee)
			->get();
			$msClasses = MsClasse::with('msPromotion')->where('classe','<>','')->where('ecole_id',$ecole_id)
			//->whereHas('msPromotion',function($q)use($id_annee){ return $q->where('ms_annee_scolaire_id',$id_annee); })
			->get();
			
			$religions = Religion::all();
			$elementDossierEnfants = ElementDossierEleve::all();
			$data = compact(/* 'sysUserRole', */'msPromotions','msClasses','mpFrais','elementDossierEnfants','religions');
			if($request->has('ms_eleve_id')){
				$DETAIL_INSC = MsEleve::with('enfant','msPromotion','msAnneeScolaire','tuteur','enfant.parentEnfant','religion')
				->find($request->ms_eleve_id);
				$data['DETAIL_INSC'] = $DETAIL_INSC;
			}
			//dd($data);
			return $this->addUser($this->v_path.'inscription', $data);
		}
	}
	
	public function eleves_inscrits($ajax=false){
		if($ajax){
			
			$id_annee = Config::getIdAnnee();
			$ecole_id = Config::getEcoleId();
			$cles = str_replace(' ','%', trim($_GET["search"]['value']));
			$w = '';
			if($cles){
				$cles="%$cles%";
				$w = "and concat(ifnull(matricule,''),' ',ifnull(nom,''),' ',ifnull(postnom,''),' ',ifnull(prenom,'')) like '$cles'";
			}
			else $cle=1;

			$count = \DB::select("
			select count(*) total from bulletin_ms_eleves partition (p$ecole_id) i 
			inner join bulletin_ms_promotions p on p.id=i.ms_promotion_id
			where i.ms_annee_scolaire_id=$id_annee and i.ecole_id = $ecole_id 
			");
			
			$where = "
			where 
			i.ms_annee_scolaire_id=$id_annee  and i.ecole_id = $ecole_id 
			$w
			";
			$countV = \DB::select("select count(*) total from bulletin_ms_eleves  partition (p$ecole_id)  i 
			inner join enfants e on e.id = i.enfant_id
			inner join bulletin_ms_promotions p on p.id=i.ms_promotion_id
			$where ");
			$req = "select i.id, matricule, concat(ifnull(nom,''),' ',ifnull(postnom,''),' ',ifnull(prenom,''))identite,promotion,inscrit_le
			,'' montant,nom_tuteur,telephone,test_pourcentage,copie_test,copie_test1
			from bulletin_ms_eleves  partition (p$ecole_id)  i 
			inner join enfants e on e.id = i.enfant_id
			inner join bulletin_ms_promotions p on p.id=i.ms_promotion_id  
			left join tuteurs t on t.id = i.tuteur_id 
			$where  
			-- group by concat(ifnull(nom,''),' ',ifnull(postnom,''),' ',ifnull(prenom,'')) having count(*) = 2 
			limit $_GET[start],$_GET[length]";
			// echo $req; 
			$data = \DB::select($req);
			$dataOk = [];
			$id=1;
			foreach($data as $e){
				$t = [];
				$t[]=$id++;
				$t[]=$e->matricule;
				$t[]=$e->identite;
				$t[]=$e->promotion;
				$t[]=$e->inscrit_le;
				$t[]=$e->montant;
				$t[]=$e->nom_tuteur.' '.$e->telephone;
				$t[]=$e->id;
				$t[]=$e->test_pourcentage??"-";
				$t[]=$e->copie_test;
				$t[]=$e->copie_test1;
				$t[]=$e->id;
				$dataOk[] = $t;
			}
			
			return array(  
                "draw"                    =>     intval($_GET["draw"]),  
                "recordsTotal"          =>      $count[0]->total,  
                "recordsFiltered"     =>     $countV[0]->total,  
                "data"                    =>     $dataOk 
           );
		}
		else $msinscriptions =[];// MsInscription::with('msPromotion.section','enfant','tuteur')->get();
		return $this->addUser($this->v_path.'eleves_inscrits', compact('msinscriptions') );
	}
	
	public function lister_promotions(){
		$ecole_id = Config::getEcoleId();
		$id_annee = Config::getIdAnnee();
		
		$mspromotions = MsPromotion::with('msClasses','msEleves.msAnneeScolaire','section','msEleves.ecole')
		->whereHas('msClasses',function($q)use($ecole_id){return $q->where('ecole_id',$ecole_id);})
		
		->orWhereHas('msEleves',function($q)use($id_annee,$ecole_id){return $q->where('ecole_id',$ecole_id)->where('ms_annee_scolaire_id',$id_annee);})
		
		->get();
		return $this->addUser($this->v_path.'classer_eleves', compact('mspromotions') );
	}
	
	
	public function cartes(Request $request){
		$msEleve = $all = false;
		$id_annee = Config::getIdAnnee();
		if( $request->has('ms_eleve_id') )
			$msEleve = $request->ms_eleve_id;
		// dd($msEleve,$request);
		
		if($msEleve === "-"){
			$all = true;
			$msEleves = MsEleve::with(
									'enfant',
									'tuteur',
									'msClasse.msPromotion.section',
									'msClasse.msPromotion.msAnneeScolaire.ecole')
								->whereHas('msClasse.msPromotion', function($q) use($id_annee){
										$q->where('ms_annee_scolaire_id', $id_annee);
								})->get();
		// dd($msEleve);
		}
		else { 
			$msEleves = MsEleve::with(
									'enfant',
									'msClasse.msPromotion')
								->whereHas('msClasse.msPromotion', function($q) use($id_annee){
										$q->where('ms_annee_scolaire_id', $id_annee);
								})->get();;
			$msEleve = MsEleve::with(
									'enfant',
									'tuteur',
									'msClasse.msPromotion.section',
									'msClasse.msPromotion.msAnneeScolaire.ecole')->find($msEleve);
		}
		// dd($msEleve,$all);
		return $this->addUser($this->v_path.'cartes',compact('msEleve','msEleves','all'));
	} 
	
	
	public function dossiers(Request $request){
		/* $msEleve = new MsEleve();
		$ms_eleve_id = $request->has('ms_eleve_id') ?$request->ms_eleve_id : $ms_eleve_id;
		$msEleve = MsEleve::find($ms_eleve_id);
		
		
		$id_annee = Config::getIdAnnee();
		$msEleves = MsEleve::with('enfant','msInscription','msClasse.msPromotion.section')
							// ->whereHas('msClasse.msPromotion', function($q) use($id_annee){
									// $q->where('ms_annee_scolaire_id', $id_annee);
							// })
							->where('enfant_id', $msEleve->enfant_id)
							->get(); */
		return $this->addUser($this->v_path.'dossiers_eleves');
	}
	
	public function dossier(Request $request ,$ms_eleve_id=0){
		$msEleve = new MsEleve();
		$ms_eleve_id = $request->has('ms_eleve_id') ?$request->ms_eleve_id : $ms_eleve_id;
		$msEleve = MsEleve::find($ms_eleve_id);
		
		
		$id_annee = Config::getIdAnnee();
		$msEleves = MsEleve::with('enfant','msInscription','msClasse.msPromotion.section')
							// ->whereHas('msClasse.msPromotion', function($q) use($id_annee){
									// $q->where('ms_annee_scolaire_id', $id_annee);
							// })
							->where('enfant_id', $msEleve->enfant_id)
							->get();
		return $this->addUser($this->v_path.'dossier_eleve',compact('msEleves','msEleve'));
	}
	
    public function change_image(Request $request)
    {
		if($request->image_eleve and $request->id_eleve){
			$img = chado_saveFile('public/mseleve/img','image_eleve',$request->id_eleve);
			$mseleve = MsEleve::findOrFail($request->id_eleve);
			$mseleve->img = $img ;
			$mseleve->save();
			return redirect()->back();
		}
	}
	
	public function ajax_change_image(Request $request){
		$image = $request->image;


        list($type, $image) = explode(';', $image);
        list(, $image)      = explode(',', $image);
        $image = base64_decode($image);
        $image_name= $request->id_eleve.'.png';

        $path = public_path('storage/mseleve/img/'.$image_name);
        //$path = public_path('storage/mseleve/img/'.$image_name);
        file_put_contents($path, $image);
		$mseleve = MsEleve::findOrFail($request->id_eleve);
		$mseleve->img = $image_name ;
		$mseleve->save();
		
		//$mseleve = MsEleve::findOrFail($request->id_eleve);
		//$mseleve->img = $image_name ;
		//$mseleve->save();

        return response()->json(['status'=>true]);
	}
	
    public function eleve_auth(Request $request)
    {
		// dd($_SERVER);
		$message = '';
		// dd($request->matricule);
		if($request->matricule){
			$enfant = Enfant::where('matricule',$request->matricule)->first();
			if($enfant)
				return redirect()->route('scholar.dossier.matricule',['matricule'=>$request->matricule]);
			else $message = 'Votre Matricule est incorrect';
		}
		return view($this->v_path.'eleve_auth', compact('message') );
	}
	
	
	public function dossier_eleve_carte(MsEleve $eleve ){
		// dd($eleve->enfant->matricule,$eleve);
		return $this->dossier_matricule($eleve->enfant->matricule );
	}
	
	
	public function dossier_matricule($matricule ){
		$id_annee = MsAnneeScolaire::where('etat',1)->first()->id;
		
		$enfant = Enfant::where('matricule',$matricule)->first();
		
		$msEleves = $enfant->msEleves;
		$id_enfant = $enfant->id ;
		// dd($enfant,$msEleves );
		// $msEleve = Enfant::with('msInscription','msClasse.msPromotion.section')->where('matricule',$matricule)->first()->msEleves;//->where('ms_annee_scolaire_id', $id_annee);
		$msEleve = MsEleve::with('enfant','msInscription','msClasse.msPromotion.section')
								->whereHas('msClasse.msPromotion', function($q) use($id_annee){
									$q->where('ms_annee_scolaire_id', $id_annee);
								})
								->whereHas('enfant', function($q) use($id_enfant){
									$q->where('enfant_id', $id_enfant);
								})->first();
		
		if($enfant){
			$msEleves = MsEleve::with('msInscription','msClasse.msPromotion.section')
							->where('enfant_id', $enfant->id)
							->get();
		}
		// dd($msEleve,$msEleves,$id_annee);
		//$msEleves = false;
		
		$eleve = true;
		$lien_dossier = route('scholar.dossier.eleve.carte');
		return $this->addUser($this->v_path.'dossier_eleve',compact('lien_dossier','msEleves','msEleve','eleve'));
	}
	
	public function import_eleves(Request $request){
		$classe = '';
		$id_classe = $request->ms_classe_id;
		if($request->has("select_file")){
			// $this->validate($request,['ms_classe_id' => 'required','select_file' => 'required|mimes:xls,xlsx']);
			foreach($request->file('select_file') as $file){
				$tab = explode('_',$file->getClientOriginalName());
				$tab = explode('(',$tab[count($tab)-1]);
				$id_classe = $tab[0];//$tab[count($tab)-1];//
				
				$classe = $id_classe=='classe'?false: MsClasse::find($id_classe);
				//dd($request);
		
				$excel =  new EleveImport($classe);
				Excel::import($excel, $file); // on importe
				if($excel->error)
					session()->flash('error',$excel->error);
			}			
			
		}
		return redirect()->back();
	}
	
	public function simple_send_sms(Request $request){
		$r = ms_sms($request->tel,$request->sms);
				// return $r;
		return $r?"OK":"erreur envoi";
	}

	public function setEleveTuteur(Request $request){
		$id = $request->tuteur_id;
		$eleve = MsEleve::with('msInscription')->find($request->eleve_id);
		$eleve->msInscription->update(['tuteur_id' => $id]);
		return redirect()->back();
	}
	
	public function message_de_remerciement(Request $request){
		$eleve = MsEleve::with('enfant','msClasse','tuteur')->find($request->eleve_id);
		if($eleve ){
			// dd($eleve);
			if( $eleve->msInscription->tuteur and  $eleve->msInscription->tuteur->telephone){
				$nom = $eleve->enfant->nom.' '.$eleve->enfant->postnom;
				$classe = $eleve->msClasse->classe;
				$ecole = \App\Config::getEcole();
				$msg = "Bonjour chers parents merci pour l'inscription de $nom en $classe AU $ecole";
				$r = ms_sms($eleve->msInscription->tuteur->telephone,$msg);
				//return $r;
				return $r?"OK":"erreur envoi";
			}
			return "Tuteur non existant";
		}
		return "Enfant non existant";
	}
	
	public function sms_masomwetu($matricule,$telephone){
		$ms_annee_scolaire_id = MsAnneeScolaire::where('etat',1)->first()->id;
		$eleve = MsEleve::with('enfant', 'msClasse', 'msInscription.msPromotion', 'tuteur', 'mpFraisPaiements.mpFraisClasse.mpFrais.mpTypeFrais', 'mdCommentaires.motifCommentaire', 'absEleveAbsents.absJour', 'mdRetards')
			->whereHas('enfant', function($q) use($matricule){
				$q->where('matricule', $matricule);
			})
			->whereHas('msInscription.msPromotion', function($q) use($ms_annee_scolaire_id){
				$q->where('ms_annee_scolaire_id', $ms_annee_scolaire_id);
			})
			->whereHas('tuteur', function($q) use($telephone){
				$q->where('telephone', $telephone);
			})
			->get()->first();

		if(!$eleve){
			$e = Enfant::where("matricule",$matricule)->get()->first();
			if($e)
				return "Tuteur non abonné. Nous vous prions de vous faire enregistrer a l'école avant de demander des informations";
			else return "Matricule erronné.";
		}
			// dd($eleve);
		$noms = $eleve->enfant->prenom??$eleve->enfant->nom.' '.$eleve->enfant->postnom;
		$fem = $eleve->enfant->genre=='M'?'':'e';
		$classe = $eleve->msClasse->classe;
		
		$identite = "$noms $classe.";	
		
		$conduite = "";
		if($eleve->absEleveAbsents){
			// dd($eleve->absEleveAbsents);
			$absence	= $eleve->absEleveAbsents->sortByDesc('id')->first();
			$date_jour = date("d/m/Y",strtotime($absence->absJour->date_jour));
			$conduite .= "Absent$fem le $date_jour";
		}
		if($eleve->mdRetards){			
			$retard	= $eleve->mdRetards->sortByDesc('id')->first();
			$nbre_min_retard = $retard->nbre_min_retard;
			$retard_date = date("d/m/Y",strtotime($retard->retard_date));
			
			$conduite .= "en retard de $nbre_min_retard min le $retard_date";
		}
		if($eleve->mdCommentaires){			
			$commentaire = $eleve->mdCommentaires->sortByDesc('coment_date')->first();
			$motif = $commentaire->motifCommentaire->motif;
			$date_com = date("d/m/Y",strtotime($commentaire->coment_date));		
			
			$conduite .= ($conduite?", puis ":"")." interpelé$fem pour $motif le $date_com. ";
		}
		$conduite = $conduite?"Conduite: $conduite":"";
		
		
		$paiement 		= $eleve->mpFraisPaiements->sortByDesc('payer_le')->first();
		$montant_payer 	= $paiement->montant_payer;
		$payer_le 		= date("d/m/Y",strtotime($paiement->payer_le));
		$frais 			= $paiement->mpFraisClasse->mpFrais->frais;
		$devise			= $paiement->mpFraisClasse->mpFrais->devise;
		$type 			= $paiement->mpFraisClasse->mpFrais->mpTypeFrais->type;
		
		$paie = "Dernier paiement $montant_payer"."$devise $type $frais payé le $payer_le.";
		// return ["$identite $paie $conduite"];
		return "$identite $paie $conduite";
	}

	
	public function fiche_excel_import_promotion(){
		$nom = "Masomwetu-grille-promotion";
		return Excel::download((new PromotionExport), $nom.'.xlsx');
		
	}
		
	
	public function import_classe(Request $request){
				
		$this->validate($request,[
				'select_file' => 'required|mimes:xls,xlsx'
			]);
			
		Excel::import(new ClasseImport(), $request->file('select_file'));
		return redirect()->back();
	}
	
	public function datatable_scholar($table="sa_categorie_bulletins"){
		$table_name =  $table;
		return $this->addUser('datatables',compact('table_name'));
	}
	
	public function dette_eleve($ms_eleve_id){
		$el = MsEleve::find($ms_eleve_id);
		$annee = Config::getIdAnnee();
		$mp = new MPaymentController();
		$arrierer = $mp->arrierer_paiement($el->enfant_id,0);
		//dd(compact('annee','arrierer'));
		return view('mes_vues.Payment.partials._dette_eleve',compact('annee','arrierer'));
	}
	
	
    public function updateCartePrint(Request $request)
    {
        $ids = explode(',', $request->ids);
    
        // Mettre à jour le champ carte_print_le à maintenant pour tous les IDs
        MsEleve::whereIn('id', $ids)->update(['carte_imprimee_le' => now()]);
    
        return response()->json(['success' => true, 'updated_ids' => $ids]);
    }

    public function updateCartePrintT(Request $request)
    {
        $request->validate([
            'ids' => 'required|string',
            'can_cancel' => 'nullable|boolean'
        ]);
    
        $ids = array_filter(explode(',', $request->ids));
        $canCancel = $request->can_cancel;
        // dd($canCancel);
        $updated = [
            'printed' => [],
            'cancelled' => [],
            'skipped' => []
        ];
    
        $eleves = MsEleve::whereIn('id', $ids)->get();
    
        foreach ($eleves as $eleve) {
    
            // Cas 1 : jamais imprimée → on marque imprimée
            if (is_null($eleve->carte_imprimee_le )) {
                $eleve->update(['carte_imprimee_le' => now()]);
                $updated['printed'][] = $eleve->id;
                continue;
            }
    
            // Cas 2 : déjà imprimée + autorisation → annulation
            if (!is_null($eleve->carte_imprimee_le) && $canCancel) {
                $eleve->update(['carte_imprimee_le' => null]);
                $updated['cancelled'][] = $eleve->id;
                continue;
            }
    
            // Cas 3 : déjà imprimée sans autorisation → rien
            $updated['skipped'][] = $eleve->id;
        }
    
        return response()->json([
            'success' => true,
            'result' => $updated
        ]);
    }

}