<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use \App\Masomwetu\Sys\SysUserRole;
use \App\Masomwetu\Scholar\MsEleve;
use \App\Masomwetu\Scholar\MsClasse;
use \App\Masomwetu\Scholar\MsPromotion;
use \App\Masomwetu\Scholar\MsAnneeScolaire;
use \App\Masomwetu\Scholar\MsInscription;
use \App\Masomwetu\Scholar\Tuteur;
use \App\Masomwetu\Scholar\Enfant;
use \App\Masomwetu\Scholar\ParentEnfant;
use \App\Masomwetu\School\Section;
use \App\Masomwetu\School\ElementDossierEleve;
use \App\Masomwetu\School\DossierEnfant;
use \App\Masomwetu\School\ImgDossierEnfant;
use \App\Masomwetu\School\Religion;

use App\Masomwetu\Payment\MpFraisPaiement;
use App\Masomwetu\Payment\MpFraisClasse;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Disciplinary\AbsEleveAbsent; 

use \App\Config;
use \App\Imports\EleveImport;
use \App\Imports\ClasseImport;
use \App\Exports\PromotionExport;
use \Excel;

use Validator,Rule;

// le controlleur qui gère l'entrée à toutes les sous applications
class MScholarUpdateController extends Controller
{
	private $v_path = 'mes_vues.Scholar.';
		
    
	public function update_insc_enfant(Request $request)
    {
		// dd($request);
		$enfant = null;
		$data = AjaxValidator::request_data(
			['matricule','nom','postnom','prenom','genre','datenaiss','lieunaiss','nationalite','id_enfant'],
			$request
		);
			$rules = [
				'nom'=>'required|min:3',
				'postnom'=>'required|min:3',
				'prenom'=>'required|min:3',
				'id_enfant'=>'required|numeric',
			];
		\DB::beginTransaction();
		try {
		
			$enfant = Enfant::find($request->id_enfant);
			if($request->matricule!=$enfant->matricule)
				$rules['matricule']='required|unique:enfants';
			//dd($request);
			// on exécute les régles de validation sur les données
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$enfant->update([
				'matricule'=>$request->matricule
				,'nom'=>$request->nom
				,'postnom'=>$request->postnom
				,'prenom'=>$request->prenom
				,'genre'=>$request->genre
				,'datenaiss'=>$request->datenaiss
				,'lieunaiss'=>$request->lieunaiss
				,'nationalite'=>$request->nationalite
				,]);				
				
			\DB::commit();
		} catch (\PDOException $e) {
				\DB::rollBack();
				$result = 'fail';
				$message = "Erreur transaction!<br>".$e->errorInfo[2];
				return compact('result','message','e');
		}
				
		flash("Modification effecté avec succès");
		$result = 'success';
		$token = csrf_token();
		return compact('result','token','enfant');
    }
	
	public function update_insc_classe (Request $request){
		
		$data = AjaxValidator::request_data(
			['montant','motivation_eleve','pro_ecole','pourcentage','ms_promotion_id','ms_classe_id'],
			$request 
		);
			$rules = [
				($request->ms_promotion_id?'ms_promotion_id':'ms_classe_id')=>'required|numeric',
			];
			
	    
			$inscription = MsEleve::find($request->ms_inscription_id);
			$ms_eleve_id = $inscription->id;
			$id_annee = Config::getIdAnnee();
			
			// 1 condition tous les frais de l'ancienne classe déjà payés doivent aussi etre dans la nouvelle classe
			$ancien_mpFraisClasses_et_paiements = MpFraisClasse::with([
    			'mpFraisPaiements' => function($query) use($ms_eleve_id) {
    			  $query->where('ms_eleve_id', $ms_eleve_id);
    			}])->whereHas('mpFraisPaiements',function($q)use($ms_eleve_id){return $q->where('ms_eleve_id',$ms_eleve_id);})->get();
    		
    		$un_frais_nexiste_pas = false;
			foreach($ancien_mpFraisClasses_et_paiements as $mp_frais_classe){
			    
    		    // s'assurer que cet ancien frais existe dans la nouvelle classe
    		    $m_classe_frais_dest = MpFraisClasse::where('ms_classe_id',$request->ms_classe_id)->where('ms_annee_scolaire_id',$id_annee)->where('mp_frais_id',$mp_frais_classe->mp_frais_id)->first();
    		    if(!$m_classe_frais_dest){
    		        $un_frais_nexiste_pas = true;
    		        break;
    		    }
    		}
    		$result = 'success';
		    $msg = "";
    		// si tous les anciens frais existent aussi dans la nouvelle classe, alors on peux juste changer leux mp_frais_classe_id correspondanz
    		if(!$un_frais_nexiste_pas ){
    		    $ms_promotion_id = MsClasse::find($request->ms_classe_id)->ms_promotion_id;
    		    $inscription->update(['ms_classe_id'=>$request->ms_classe_id,"ms_promotion_id"=>$ms_promotion_id]);
    		    foreach($ancien_mpFraisClasses_et_paiements as $mp_frais_classe){
			    
        		    // s'assurer que cet ancien frais existe dans la nouvelle classe
        		    $m_classe_frais_dest = MpFraisClasse::where(['ms_classe_id'=>$request->ms_classe_id,'mp_frais_id'=>$mp_frais_classe->mp_frais_id,'ms_annee_scolaire_id'=>$id_annee])->first();
        		    
        		    $mp_frais_classe_id = $m_classe_frais_dest->id;
    		        $compte_id = $m_classe_frais_dest->compte;
    		        MpFraisPaiement::where('ms_eleve_id',$ms_eleve_id)->where('mp_frais_classe_id',$mp_frais_classe->id)->update(compact('mp_frais_classe_id','compte_id'));
        		}
    		    flash("Modification effecté avec succès");
		    }
			else {
			    $result = 'fail';
    		    $msg = "Certains frais déjà payés par l'élève dans l'ancienne classe ne correspondent dans la nouvelle classe, veuillez supprimer les tous les frais de l'enfant puis reprenez-les dans sa nouvelle classe avec les mêmes dates";
    		    flash($msg);
		    }
    				
    		$token = csrf_token();
    		$message = $msg;
    		return compact('result','token','inscription','message');
    		
    		
    		/** CE CODE EST A SUPPRIMER **/
    		 
		\DB::beginTransaction();
		try {
		
			$inscription = MsEleve::find($request->ms_inscription_id);
			
			// on exécute les régles de validation sur les données
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$inscription->update([
				'motivation_eleve'=>$request->motivation_eleve
				,'pro_classe'=>$request->pro_classe
				,'pro_ecole'=>$request->pro_ecole
				,'pourcentage'=>$request->pourcentage
				,]);				
				
			if(false and $request->ms_classe_id and $inscription->ms_classe_id!=$request->ms_classe_id){
				$inscription->update(['ms_classe_id'=>$request->ms_classe_id]);
				// si on souhaite classer l'enfant
				//classer_direct
				/*if($request->classer_direct and $inscription){
					$insc = MsEleve::with('msPromotion.msClasses.msEleves')->find($inscription->id);
					$classes = $insc->msPromotion->msClasses;
					// les classes disponibles dans la promotion
					// trouver celle ou il y a moins de filles ou de garcons
					if($classes->count()){
						$enfant = $inscription->enfant;
						$pte_cls = $classes->first();// la 1ere classe
						$moin_el = $pte_cls->mseleves->filter(function ($el, $key) use($enfant){
							return $el->genre == $enfant->genre;
						})->count();
						foreach($classes as $clas){							
							$plus_el = $clas->mseleves->filter(function ($el, $key) use($enfant){
								return $el->genre == $enfant->genre;
							})->count();
							// comparaison des deux effectifs
							if($moin_el > $plus_el){
								$moin_el = $plus_el;
								$pte_cls = $clas;
							}
						}
						$datas = [
							'enfant_id'=>$enfant->id,
							'ms_classe_id'=>$pte_cls->id,
							'inscrit_le'=>date('Y-m-d'),
							'ms_inscription_id'=>$inscription->id,
							'etat'=>'Actif',
							'status_enfant_id'=>1,
						];
						$eleve = MsEleve::create($datas);
						$classe = $pte_cls->classe;
						
					}
				}*/
			}
			else if(false and $request->ms_classe_id and count($inscription->msEleves) and $inscription->msEleves[0]->ms_classe_id!=$request->ms_classe_id){
			}
			
			$this->changer_classe_eleve($inscription,$request->ms_classe_id);
			
			\DB::commit();
		} catch (\PDOException $e) {
				\DB::rollBack();
				$result = 'fail';
				$message = "Erreur transaction!<br>".$e->errorInfo[2];
				return compact('result','message','e');
		}
				
		flash("Modification effecté avec succès");
		$result = 'success';
		$token = csrf_token();
		return compact('result','token','inscription');
	}
	
	// changer la classe d'un eleve
	public function changer_classe_eleves(Request $req){
		foreach($req->ms_inscriptions_id as $ms_inscription_id){
			$insc = MsEleve::find($ms_inscription_id);
			$this->changer_classe_eleve($insc,$req->ms_classe_id);
		}
		return redirect()->back();
	}
	
	// changer la classe d'un eleve
	public function changer_classe_eleve(MsEleve $eleve,$ms_classe_id){
		//$eleve = $inscription->msEleves[0];
		$id_annee = Config::getIdAnnee();
		$exclass = MsClasse::find($eleve->ms_classe_id);
		$nwclass = MsClasse::find($ms_classe_id);

		$message='';
		$grp_ancien_paiements = MpFraisPaiement::with('mpFraisClasse.mpFrais')->where('ms_eleve_id',$eleve->id)->get()->groupBy('mp_frais_classe_id');
		foreach($grp_ancien_paiements as $id=>$ancien_paiements){
			// if($exclass->ms_promotion_id==$nwclass->ms_promotion_id){
				$reste = 0;
				$fraisClasse = $ancien_paiements->first()->mpFraisClasse;
				$mp_frais_id = $fraisClasse->mp_frais_id;// ancien frais
				$montant_deja_payer = $ancien_paiements->where('mp_frais_classe_id',$fraisClasse->id)->sum('montant_payer');
				// on va retrouver le meme frais dans sa nouvelle classe
				$fc = MpFraisClasse::where('ms_annee_scolaire_id',$id_annee)->where('ms_classe_id',$ms_classe_id)->where('mp_frais_id',$mp_frais_id)->get()->first();
				if($fc){
					// si le paiement a ete fait en une transaction 
					$nom_frais = $fraisClasse->mpFrais->frais;
					if($ancien_paiements->count()==1)
					{
						$p = $ancien_paiements->first();
						if($montant_deja_payer > $fc->montant){
							$reste = $montant_deja_payer - $fc->montant;
							$reste_usd = $reste/$fraisClasse->taux;
							$date = ' le '.date('d-M, Y',strtotime($p->payer_le));
							
							$montant_payer_cdf = $p->montant_payer_cdf;
							$montant_payer_usd = $p->montant_payer_usd;
							if($p->montant_payer_cdf>$reste){
								$montant_payer_cdf = $p->montant_payer_cdf-$reste;
								$message .= "Nous avons retencher $reste CDF";
							}else if($p->montant_payer_usd>$reste_usd){
								$montant_payer_usd = $p->montant_payer_usd-$reste_usd;
								$message .= "Nous avons retencher $reste_usd USD";
							}
							else {
								$montant_payer_cdf = $fc->montant;
								$montant_payer_usd = 0;
								$message .= "Nous lui avons fait payer $fc->montant pour $nom_frais et lui avait de payer $p->montant_payer_cdf CDF et $p->montant_payer_usd USD";
							}
							
							$p->update(['mp_frais_classe_id'=>$fc->id,'montant_payer'=>$fc->montant
							,'montant_payer_usd'=>$montant_payer_usd,'montant_payer_cdf'=>$montant_payer_cdf]);
						}
						else{
							if($fc)
								$p->update(['mp_frais_classe_id'=>$fc->id]);
							$message .= "Nous avons retenu son paiement de $montant_deja_payer ".$nom_frais;
						}
						//$p->update(['mp_frais_classe_id'=>$fc->id]);
						//$message='';
					}
					else{
						if($montant_deja_payer > $fc->montant){
							$message .= "L'enfant a deja paye plus qu'il n'en faudra pour $nom_frais, vous devrez maitre a jours ses paiement";
						}
						foreach($ancien_paiements as $p){
							$p->update(['mp_frais_classe_id'=>$fc->id]);
							/* if($montant_deja_payer > $fc->montant){
								$reste = $montant_deja_payer - $fc->montant;

							}
							else{
								if($fc)
							} */
							
						}
					}
				}
				else {
					//$result = 'fail';
					$id = $inscription->msEleves[0]->id;
					\DB::select('delete from mp_frais_paiements where ms_eleve_id='.$id);
					$montant = chiffre($montant_deja_payer);
					$date='';
					foreach($ancien_paiements as $p)
						$date .= ($date?', ':'').($p->montant_payer.'CDF le '.date('d-M, Y',strtotime($p->payer_le)));
					$trenche = $ancien_paiements->count()==1?'une tranche':$ancien_paiements->count().' tranches';
					$message.="L'Enfant ne devrait plus payer le frais de: ".$fraisClasse->mpFrais->frais.", rembourssez-lui donc $montant payer en $trenche; le $date";
				}
			//}
			/* else {
				$id = $inscription->msEleves[0]->id;
				\DB::select('delete from mp_frais_paiements where ms_eleve_id='.$id);
			} */
			
		}
		$eleve->update(['ms_classe_id'=>$ms_classe_id]);
		$eleve->update(['ms_promotion_id'=>$eleve->msClasse->ms_promotion_id]);
	}
	
	public function update_insc_tuteur(Request $request){
		// dd($request);
		$eleve = $classe = $tuteur = $enfant = $inscription = null;
		$data = AjaxValidator::request_data(
			['nom_tuteur','telephone','adresse','id_tuteur'],
			$request
		);
		// dd($request->ms_inscription_id);
		$inscription = MsEleve::with('tuteur')->find($request->ms_inscription_id);
		// les règles de validation sur le tuteur sont optionnelles
		$rules['nom_tuteur']='required|min:3';
		$rules['adresse']='required|min:3';
		$rules['lien_avec_eleve']='';
		$rules['adresse_mail']='';
		if($request->add_tuteur=="upd"){
			// $rules['id_tuteur']='required|numeric';

			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$tuteur = $inscription->tuteur;
			if($tuteur->telephone==$request->telephone){
				$tuteur->update(AjaxValidator::request_data( ['nom_tuteur','adresse','lien_avec_eleve','adresse_mail'], $request ));
			}
			else $rules['telephone']='numeric|unique:tuteurs';
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$tuteur->update(AjaxValidator::request_data( ['nom_tuteur','telephone','adresse','lien_avec_eleve','adresse_mail'], $request ));
		}
		else if($request->add_tuteur=="new"){
			$rules['telephone']='numeric|unique:tuteurs';
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$tuteur = Tuteur::create(AjaxValidator::request_data( ['nom_tuteur','telephone','adresse','lien_avec_eleve','adresse_mail'], $request ));
			if($tuteur){
				$inscription->tuteur_id = $tuteur->id;
				$inscription->save();
			}
		}		
		else {
			$rules = $data = [];
			$rules['select_tuteur_id']='required|numeric';
			$data['select_tuteur_id'] = $request->select_tuteur_id;
			
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
				
			$inscription->tuteur_id = $request->select_tuteur_id;
			$inscription->save();
		}		
		flash("Enregistrement effecté avec succès");
		$result = 'success';
		$token = csrf_token();
		return compact('result','token');
		//redirect()->route('enfants.index', compact() );
        //
    }
	
	public function update_insc_religion(Request $request){

		$rules = $data = [];
		$rules['ms_inscription_id']='required|numeric';
		$rules['religion_id']='required|numeric';
		$data['ms_inscription_id'] = $request->ms_inscription_id;
		$data['religion_id'] = $request->religion_id;
		
		$result = AjaxValidator::validate($data,$rules);
		if($result!==true)
			return $result;
		$inscription = MsEleve::find($request->ms_inscription_id);
			
		$inscription->religion_id = $request->religion_id;
		$inscription->save();
		flash("Modification effecté avec succès");
		$result = 'success';
		$token = csrf_token();
		return compact('result','token');
	}
	public function update_insc_parent(Request $request){
		$papa_deceder = ($request->papa_deceder and $request->papa_deceder!=0) ?$request->papa_deceder_en:false;
		$maman_deceder = ($request->maman_deceder and $request->maman_deceder!=0) ?$request->maman_deceder_en:false;
		$parent_separer = ($request->parent_separer_en!="0000")?$request->parent_separer_en:false;
		$inscription = MsEleve::with('tuteur')->find($request->ms_inscription_id);
		$rules['papa']='required|min:3';
		//$rules['telephone_pa']='numeric|unique:parent_enfants';
		$rules['profession_pa']='';
		$rules['adresse_papa']='';
		$rules['papa_deceder']='';
		$rules['maman']='required|min:3';
		//$rules['telephone_ma']='numeric';
		$rules['profession_ma']='';
		$rules['adresse_maman']='';
		$rules['parent_separer']='';
		if($request->add_parent=="upd"){
			$data = AjaxValidator::request_data(
				['papa','maman','parent_enfant_id'],
				$request
			);
				
			$rules['parent_enfant_id']='required|numeric';

			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$parent = ParentEnfant::find($request->parent_enfant_id);

			$data = AjaxValidator::request_data( ['papa','telephone_pa','profession_pa','adresse_papa','maman','telephone_ma','profession_ma','adresse_maman'], $request );
			if($request->adresse_parent){
    			$data['adresse_maman'] = $request->adresse_parent;
    			$data['adresse_papa'] = $request->adresse_parent;
			}
			$data['papa_deceder'] = $papa_deceder;
			$data['maman_deceder'] = $maman_deceder;
			$data['parent_separer'] = $parent_separer;
			$parent->update($data);
		}
		else if($request->add_parent=="new"){
			$data = AjaxValidator::request_data( ['papa','telephone_pa','profession_pa','adresse_papa','maman','telephone_ma','profession_ma','adresse_maman'], $request );
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
			$data['papa_deceder'] = $papa_deceder;
			$data['maman_deceder'] = $maman_deceder;
			$data['parent_separer'] = $parent_separer;
			$p = ParentEnfant::create($data);
			if($p){
				$inscription->enfant->parent_enfant_id = $p->id;
				$inscription->enfant->save();
			}
		}
		else {
			$rules = $data = [];
			$rules['select_parent_enfant_id']='required|numeric';
			$data['select_parent_enfant_id'] = $request->select_parent_enfant_id;
			
			$result = AjaxValidator::validate($data,$rules);
			if($result!==true)
				return $result;
				
			$inscription->enfant->parent_enfant_id = $request->select_parent_enfant_id;
			$inscription->enfant->save();

		}
		flash("Modification effecté avec succès");
		$result = 'success';
		$token = csrf_token();
		return compact('result','token');
	}
	public function update_insc_dossier(Request $request){
		$dossier = DossierEnfant::create(['element_dossier_eleve_id'=>$request->element_dossier_eleve_id_1,'ms_eleve_id'=>$request->ms_inscription_id]);
		if(request()->file('scan_element_dossier_1') and count(request()->file('scan_element_dossier_1'))){
			$folder = 'public/imgdossierenfant/scan/';
			foreach(request()->file('scan_element_dossier_1') as $f){
				$datas = [
				'dossier_enfant_id'=>$dossier->id,
				];
				$img = ImgDossierEnfant::create($datas);
				$uploadedFile = $f;
				$filename = false;
				if($uploadedFile){
					$filename = $img->id.'.'.$uploadedFile->getClientOriginalExtension();
					$path = \Storage::disk('local')->putFileAs(
						$folder,
						$uploadedFile,
						$filename
					);
					$img->scan = $filename;
					$img->save();
				}
			}
		}
		$result = 'success';
		$token = csrf_token();
		return compact('result','token');
	}
	public function update_insc_image(Request $request){
		$inscription = MsEleve::with('tuteur')->find($request->ms_inscription_id);
		$ecole_id = Config::getEcoleId();
		// enregistrement de l'image de l'enfant
		if($inscription and $request->val_img_enfant){					
			$image_array_1 = explode(";", $request->val_img_enfant);	
			$image_array_2 = explode(",", $image_array_1[1]);
			$data = $image_array_2[1];
			$data = str_replace(' ', '+', $data);
			$data = base64_decode($data);
			$n = $ecole_id."_".$inscription->id.'.jpg';
			$folder = 'storage/mseleve/img';
			if(!file_exists($folder))
				mkdir($folder,0777,true);
			file_put_contents("$folder/$n", $data);
			$inscription->img = $n;
			$inscription->save();
			// if($n = chado_saveFile('public/msinscription/img/','img',$inscription->id)){
			// 	$inscription->img = $n;
			// 	$inscription->save();
			// }
			$result = 'success';
			$token = csrf_token();
			return compact('result','token');
		}
	}

	
	public function update_image_brute(Request $request){
		$inscription = MsEleve::find($request->ms_inscription_id);
		// enregistrement de l'image de l'enfant
		if($inscription){
				//dd($request->file());
			$name ='img_enfant';
			if(isset($_FILES[$name])) {  
				$extension = explode('.', $_FILES[$name]['name']);  
				// $new_name = rand() . '.' . $extension[1];  
				$new_name = $inscription->id . '.' . $extension[count($extension)-1];  
				$inscription->img = $new_name;
				$inscription->save();
				$folder = 'storage/mseleve/img';
				if(!file_exists($folder))
					mkdir($folder,0777,true);
				$destination = 'storage/mseleve/img/' . $new_name;
				move_uploaded_file($_FILES[$name]['tmp_name'], $destination);  
				// return $new_name;  
			$result = 'success';
			$token = csrf_token();
			$id=$inscription->id;
			$url= asset('storage/mseleve/img/'.$inscription->img);
			return compact('result','token','id','url');
			}
			// if($img = chado_saveFile('../../storagee/mseleve/img','img',$inscription->id)){
				// $inscription->img = $img;
				// $inscription->save();
			// }
		}
	}
}