<?php

namespace App\Http\Controllers\Masomwetu\Cash;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Cash\CashFicheSortie;
use App\Masomwetu\Cash\CashSuivi;
use App\Masomwetu\Cash\CashCategorie;
use App\Masomwetu\Scholar\MsAnneeScolaire; 
class CashFicheSortiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the cashfichesorties
        $cashfichesorties = CashFicheSortie::all();

        // load the view and pass the cashfichesorties
        return view('Masomwetu.Cash.cashfichesorties.index')
            ->with('cashfichesorties', $cashfichesorties);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/cashfichesorties/create.blade.php)
        $cashfichesortie = new CashFicheSortie;
				$cashCategories = CashCategorie::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
        return view('Masomwetu.Cash.cashfichesorties.create',compact('cashfichesortie','cashCategories','msAnneeScolaires'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'cash_categorie_id'=>$request->cash_categorie_id,
					'motif'=>$request->motif,
					'montant'=>$request->montant,
					'devise'=>$request->devise,
					'demandee_par'=>$request->demandee_par,
					'autorisee_per'=>$request->autorisee_per,
					'date_fiche'=>($request->date_fiche??''),
					'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
				];
				$rules = [
				'cash_categorie_id'=>'required',
					'motif'=>'required',
					'montant'=>'required',
					'devise'=>'required',
					'demandee_par'=>'required',
					'autorisee_per'=>'required',
					'date_fiche'=>'required',
					'ms_annee_scolaire_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$cashfichesortie = CashFicheSortie::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $cashfichesortie->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('cashfichesortie',$cashfichesortie);
					return redirect()->back();
				}return redirect()->route('cashfichesorties.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $cashfichesortie = CashFicheSortie::findOrFail($id);
				return view('Masomwetu.Cash.cashfichesorties.show',compact('cashfichesortie'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $cashfichesortie = CashFicheSortie::findOrFail($id);
				$cashCategories = CashCategorie::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
				return view('Masomwetu.Cash.cashfichesorties.edit',compact('cashfichesortie','cashCategories','msAnneeScolaires'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$cashfichesortie = CashFicheSortie::findOrFail($id);
				$datas = [
				'cash_categorie_id'=>$request->cash_categorie_id,
					'motif'=>$request->motif,
					'montant'=>$request->montant,
					'devise'=>$request->devise,
					'demandee_par'=>$request->demandee_par,
					'autorisee_per'=>$request->autorisee_per,
					'date_fiche'=>($request->date_fiche??''),
					'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
				];
				$rules = [
				'cash_categorie_id'=>'required',
					'motif'=>'required',
					'montant'=>'required',
					'devise'=>'required',
					'demandee_par'=>'required',
					'autorisee_per'=>'required',
					'date_fiche'=>'required',
					'ms_annee_scolaire_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$cashfichesortie->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('cashfichesorties.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        CashFicheSortie::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('cashfichesorties.index');
    }
}
