<?php

namespace App\Http\Controllers\Masomwetu\Cash;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Cash\CashSuivi;
use App\Masomwetu\Cash\CashFicheSortie; 
class CashSuivisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the cashsuivis
        $cashsuivis = CashSuivi::all();

        // load the view and pass the cashsuivis
        return view('Masomwetu.Cash.cashsuivis.index')
            ->with('cashsuivis', $cashsuivis);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/cashsuivis/create.blade.php)
        $cashsuivi = new CashSuivi;
				$cashFicheSorties = CashFicheSortie::all();
        return view('Masomwetu.Cash.cashsuivis.create',compact('cashsuivi','cashFicheSorties'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'cash_fiche_sortie_id'=>$request->cash_fiche_sortie_id,
					'tache'=>$request->tache,
					'montant'=>$request->montant,
					'devise'=>$request->devise,
					'date_suivi'=>($request->date_suivi??''),
				];
				$rules = [
				'cash_fiche_sortie_id'=>'required',
					'tache'=>'required',
					'montant'=>'required',
					'devise'=>'required',
					'date_suivi'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$cashsuivi = CashSuivi::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $cashsuivi->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('cashsuivi',$cashsuivi);
					return redirect()->back();
				}return redirect()->route('cashsuivis.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $cashsuivi = CashSuivi::findOrFail($id);
				return view('Masomwetu.Cash.cashsuivis.show',compact('cashsuivi'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $cashsuivi = CashSuivi::findOrFail($id);
				$cashFicheSorties = CashFicheSortie::all();
				return view('Masomwetu.Cash.cashsuivis.edit',compact('cashsuivi','cashFicheSorties'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$cashsuivi = CashSuivi::findOrFail($id);
				$datas = [
				'cash_fiche_sortie_id'=>$request->cash_fiche_sortie_id,
					'tache'=>$request->tache,
					'montant'=>$request->montant,
					'devise'=>$request->devise,
					'date_suivi'=>($request->date_suivi??''),
				];
				$rules = [
				'cash_fiche_sortie_id'=>'required',
					'tache'=>'required',
					'montant'=>'required',
					'devise'=>'required',
					'date_suivi'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$cashsuivi->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('cashsuivis.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        CashSuivi::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('cashsuivis.index');
    }
}
