<?php

namespace App\Http\Controllers\Masomwetu\Cash;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Cash\McMois;
use App\Masomwetu\Payment\MpFrais; 
class McMoissController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mcmoiss
        $mcmoiss = McMois::all();

        // load the view and pass the mcmoiss
        return view('Masomwetu.Cash.mcmoiss.index')
            ->with('mcmoiss', $mcmoiss);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mcmoiss/create.blade.php)
        $mcmois = new McMois;
        return view('Masomwetu.Cash.mcmoiss.create',compact('mcmois'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'mois'=>$request->mois,
				];
				$rules = [
				'mois'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mcmois = McMois::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mcmois->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mcmois',$mcmois);
					return redirect()->back();
				}return redirect()->route('mcmoiss.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mcmois = McMois::findOrFail($id);
				return view('Masomwetu.Cash.mcmoiss.show',compact('mcmois'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mcmois = McMois::findOrFail($id);
				return view('Masomwetu.Cash.mcmoiss.edit',compact('mcmois'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mcmois = McMois::findOrFail($id);
				$datas = [
				'mois'=>$request->mois,
				];
				$rules = [
				'mois'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mcmois->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mcmoiss.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        McMois::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mcmoiss.index');
    }
}
