<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\Compte;
use App\Masomwetu\Comptabilite\CategorieCompte;
use App\Masomwetu\Comptabilite\MouvementCompte; 
use App\Masomwetu\Comptabilite\CompteEtUser; 
use \App\Config;
class ComptesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the comptes
        $comptes = Compte::all();

        // load the view and pass the comptes
        return view('Masomwetu.Comptabilite.comptes.index')
            ->with('comptes', $comptes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/comptes/create.blade.php)
        $compte = new Compte;
        $comptes = Compte::all();
				$categorieComptes = CategorieCompte::all();
        return view('Masomwetu.Comptabilite.comptes.create',compact('comptes','compte','categorieComptes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'imputation'=>$request->imputation,
					'code'=>$request->code,
					'libelle'=>$request->libelle,
					'pourcentage'=>$request->pourcentage,
					'compte_id'=>$request->compte_id,
					'compte_parent_id'=>$request->compte_parent_id,
					'categorie_compte_id'=>$request->categorie_compte_id,
					'ecole_id'=>Config::getEcoleId(),
				];
				$rules = [
				'imputation'=>'',
					'code'=>'',
					'libelle'=>'required',
					'pourcentage'=>'',
					'compte_id'=>'',
					'compte_parent_id'=>'',
					'categorie_compte_id'=>'required',
					'ecole_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$compte = Compte::create($datas);
				
				$user_id = \Auth::user()->id;
				$datasU=['user_id'=>$user_id,'compte_id'=>$compte->id];
				CompteEtUser::create($datasU);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $compte;
					$id = $compte->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('compte',$compte);
					return redirect()->back();
				}
				return redirect()->route('comptes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $compte = Compte::findOrFail($id);
				return view('Masomwetu.Comptabilite.comptes.show',compact('compte'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $compte = Compte::findOrFail($id);
				$categorieComptes = CategorieCompte::all();
				return view('Masomwetu.Comptabilite.comptes.edit',compact('compte','categorieComptes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$compte = Compte::findOrFail($id);
				$datas = [
				'imputation'=>$request->imputation,
					'code'=>$request->code,
					'libelle'=>$request->libelle,
					'pourcentage'=>$request->pourcentage,
					'compte_id'=>$request->compte_id,
					'categorie_compte_id'=>$request->categorie_compte_id,
				];
				$rules = [
				'imputation'=>'',
					'code'=>'',
					'libelle'=>'required',
					'pourcentage'=>'',
					'compte_id'=>'',
					'categorie_compte_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$compte->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $compte->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('compte',$compte);
					return redirect()->back();
				}
				return redirect()->route('comptes.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        Compte::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('comptes.index');
    }
}
