<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\RapportJournalier;
class RapportJournaliersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the rapportjournaliers
        $rapportjournaliers = RapportJournalier::all();

        // load the view and pass the rapportjournaliers
        return view('Masomwetu.Comptabilite.rapportjournaliers.index')
            ->with('rapportjournaliers', $rapportjournaliers);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/rapportjournaliers/create.blade.php)
        $rapportjournalier = new RapportJournalier;
        return view('Masomwetu.Comptabilite.rapportjournaliers.create',compact('rapportjournalier'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
	{
				$datas = [
					'report_joint'=>$request->report_joint ,
					'total_recette_cdf'=>$request->total_recette_cdf,
					'total_recette_usd'=>$request->total_recette_usd,
					'total_aurtre_rec_cdf'=>$request->total_aurtre_rec_cdf,
					'total_aurtre_rec_usd'=>$request->total_aurtre_rec_usd,
					
					'total_charge_cdf'=>$request->total_charge_cdf,
					'total_charge_usd'=>$request->total_charge_usd,
					'total_autre_char_cdf'=>$request->total_autre_char_cdf,
					'total_autre_char_usd'=>$request->total_autre_char_usd,
					'date_rapport'=>($request->date_rapport??''),
					
				];
				$rules = [
					'report_joint'=>'',
					'total_recette_cdf'=>'',
					'total_recette_usd'=>'',
					'total_aurtre_rec_cdf'=>'',
					'total_aurtre_rec_usd'=>'',
										
					'total_charge_cdf'=>'',
					'total_charge_usd'=>'',
					'total_autre_char_cdf'=>'',
					'total_autre_char_usd'=>'',
					'date_rapport'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$rapportjournalier = RapportJournalier::create($datas);

				$r = RapportJournalier::find($request->report_joint);
				$r->report_joint = $rapportjournalier->id;
				$r->save();
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $rapportjournalier;
					$id = $rapportjournalier->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportjournalier',$rapportjournalier);
					return redirect()->back();
				}
				return redirect()->route('rapportjournaliers.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $rapportjournalier = RapportJournalier::findOrFail($id);
				return view('Masomwetu.Comptabilite.rapportjournaliers.show',compact('rapportjournalier'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $rapportjournalier = RapportJournalier::findOrFail($id);
				return view('Masomwetu.Comptabilite.rapportjournaliers.edit',compact('rapportjournalier'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$rapportjournalier = RapportJournalier::findOrFail($id);
				$datas = [
					'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'total_recette_cdf'=>$request->total_recette_cdf,
					'total_recette_usd'=>$request->total_recette_usd,
					'total_aurtre_rec_cdf'=>$request->total_aurtre_rec_cdf,
					'total_aurtre_rec_usd'=>$request->total_aurtre_rec_usd,
					
					'total_charge_cdf'=>$request->total_charge_cdf,
					'total_charge_usd'=>$request->total_charge_usd,
					'total_autre_char_cdf'=>$request->total_autre_char_cdf,
					'total_autre_char_usd'=>$request->total_autre_char_usd,
					'date_rapport'=>($request->date_rapport??''),
					
				];
				$rules = [
				'report_cdf'=>'',
					'report_usd'=>'',
					'total_recette_cdf'=>'',
					'total_recette_usd'=>'',
					'total_aurtre_rec_cdf'=>'',
					'total_aurtre_rec_usd'=>'',
										
					'total_charge_cdf'=>'',
					'total_charge_usd'=>'',
					'total_autre_char_cdf'=>'',
					'total_autre_char_usd'=>'',
					'date_rapport'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$rapportjournalier->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $rapportjournalier->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportjournalier',$rapportjournalier);
					return redirect()->back();
				}
				return redirect()->route('rapportjournaliers.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        RapportJournalier::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('rapportjournaliers.index');
    }
}
