<?php

namespace App\Http\Controllers\Masomwetu\Comptabilite;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Comptabilite\RapportMensuel;
class RapportMensuelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the rapportmensuels
        $rapportmensuels = RapportMensuel::all();

        // load the view and pass the rapportmensuels
        return view('Masomwetu.Comptabilite.rapportmensuels.index')
            ->with('rapportmensuels', $rapportmensuels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/rapportmensuels/create.blade.php)
        $rapportmensuel = new RapportMensuel;
        return view('Masomwetu.Comptabilite.rapportmensuels.create',compact('rapportmensuel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'encaissement_cdf'=>$request->encaissement_cdf,
					'encaissement_usd'=>$request->encaissement_usd,
					'decaissement_cdf'=>$request->decaissement_cdf,
					'decaissement_usd'=>$request->decaissement_usd,
					'mois_rapport'=>$request->mois_rapport,
					'deja_comptabiliser'=>$request->deja_comptabiliser,
					'date_rapport'=>($request->date_rapport??''),
				];
				$rules = [
				'report_cdf'=>'',
					'report_usd'=>'',
					'encaissement_cdf'=>'',
					'encaissement_usd'=>'',
					'decaissement_cdf'=>'',
					'decaissement_usd'=>'',
					'mois_rapport'=>'required',
					'deja_comptabiliser'=>'required',
					'date_rapport'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$rapportmensuel = RapportMensuel::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $rapportmensuel;
					$id = $rapportmensuel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportmensuel',$rapportmensuel);
					return redirect()->back();
				}
				return redirect()->route('rapportmensuels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $rapportmensuel = RapportMensuel::findOrFail($id);
				return view('Masomwetu.Comptabilite.rapportmensuels.show',compact('rapportmensuel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $rapportmensuel = RapportMensuel::findOrFail($id);
				return view('Masomwetu.Comptabilite.rapportmensuels.edit',compact('rapportmensuel'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$rapportmensuel = RapportMensuel::findOrFail($id);
				$datas = [
				'report_cdf'=>$request->report_cdf,
					'report_usd'=>$request->report_usd,
					'encaissement_cdf'=>$request->encaissement_cdf,
					'encaissement_usd'=>$request->encaissement_usd,
					'decaissement_cdf'=>$request->decaissement_cdf,
					'decaissement_usd'=>$request->decaissement_usd,
					'mois_rapport'=>$request->mois_rapport,
					'deja_comptabiliser'=>$request->deja_comptabiliser,
					'date_rapport'=>($request->date_rapport??''),
				];
				$rules = [
				'report_cdf'=>'',
					'report_usd'=>'',
					'encaissement_cdf'=>'',
					'encaissement_usd'=>'',
					'decaissement_cdf'=>'',
					'decaissement_usd'=>'',
					'mois_rapport'=>'required',
					'deja_comptabiliser'=>'required',
					'date_rapport'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$rapportmensuel->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $rapportmensuel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('rapportmensuel',$rapportmensuel);
					return redirect()->back();
				}
				return redirect()->route('rapportmensuels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        RapportMensuel::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('rapportmensuels.index');
    }
}
