<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Disciplinary\Periode;
use App\Masomwetu\Disciplinary\MotifCommentaire; 
class MdCommentairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdcommentaires
        $mdcommentaires = MdCommentaire::all();

        // load the view and pass the mdcommentaires
        return view('Masomwetu.Disciplinary.mdcommentaires.index')
            ->with('mdcommentaires', $mdcommentaires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdcommentaires/create.blade.php)
        $mdcommentaire = new MdCommentaire;
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
				$motifCommentaires = MotifCommentaire::all();
        return view('Masomwetu.Disciplinary.mdcommentaires.create',compact('mdcommentaire','msEleves','periodes','motifCommentaires'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'coment_date'=>($request->coment_date??''),
					'importance'=>$request->importance,
					'motif_commentaire_id'=>$request->motif_commentaire_id,
					'detail'=>$request->detail,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'coment_date'=>'required',
					'importance'=>'required',
					'motif_commentaire_id'=>'required',
					'detail'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mdcommentaire = MdCommentaire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mdcommentaire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdcommentaire',$mdcommentaire);
					return redirect()->back();
				}return redirect()->route('mdcommentaires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdcommentaire = MdCommentaire::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdcommentaires.show',compact('mdcommentaire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdcommentaire = MdCommentaire::findOrFail($id);
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
				$motifCommentaires = MotifCommentaire::all();
				return view('Masomwetu.Disciplinary.mdcommentaires.edit',compact('mdcommentaire','msEleves','periodes','motifCommentaires'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdcommentaire = MdCommentaire::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'coment_date'=>($request->coment_date??''),
					'importance'=>$request->importance,
					'motif_commentaire_id'=>$request->motif_commentaire_id,
					'detail'=>$request->detail,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'coment_date'=>'required',
					'importance'=>'required',
					'motif_commentaire_id'=>'required',
					'detail'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdcommentaire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mdcommentaires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MdCommentaire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mdcommentaires.index');
    }
}
