<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdMention;
class MdMentionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdmentions
        $mdmentions = MdMention::all();

        // load the view and pass the mdmentions
        return view('Masomwetu.Disciplinary.mdmentions.index')
            ->with('mdmentions', $mdmentions);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdmentions/create.blade.php)
        $mdmention = new MdMention;
        return view('Masomwetu.Disciplinary.mdmentions.create',compact('mdmention'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'borne_sup'=>$request->borne_sup,
					'borne_inf'=>$request->borne_inf,
					'mention'=>$request->mention,
					'description'=>$request->description,
				];
				$rules = [
				'borne_sup'=>'required',
					'borne_inf'=>'required',
					'mention'=>'required',
					'description'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mdmention = MdMention::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mdmention->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdmention',$mdmention);
					return redirect()->back();
				}return redirect()->route('mdmentions.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdmention = MdMention::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdmentions.show',compact('mdmention'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdmention = MdMention::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdmentions.edit',compact('mdmention'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdmention = MdMention::findOrFail($id);
				$datas = [
				'borne_sup'=>$request->borne_sup,
					'borne_inf'=>$request->borne_inf,
					'mention'=>$request->mention,
					'description'=>$request->description,
				];
				$rules = [
				'borne_sup'=>'required',
					'borne_inf'=>'required',
					'mention'=>'required',
					'description'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdmention->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mdmentions.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MdMention::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mdmentions.index');
    }
}
