<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdPresence;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Disciplinary\Periode; 
class MdPresencesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdpresences
        $mdpresences = MdPresence::all();

        // load the view and pass the mdpresences
        return view('Masomwetu.Disciplinary.mdpresences.index')
            ->with('mdpresences', $mdpresences);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdpresences/create.blade.php)
        $mdpresence = new MdPresence;
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
        return view('Masomwetu.Disciplinary.mdpresences.create',compact('mdpresence','msEleves','periodes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'presence_date'=>($request->presence_date??''),
					'nbre_min_retard'=>$request->nbre_min_retard,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'presence_date'=>'required',
					'nbre_min_retard'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mdpresence = MdPresence::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $mdpresence;
					$id = $mdpresence->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdpresence',$mdpresence);
					return redirect()->back();
				}
				return redirect()->route('mdpresences.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdpresence = MdPresence::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdpresences.show',compact('mdpresence'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdpresence = MdPresence::findOrFail($id);
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
				return view('Masomwetu.Disciplinary.mdpresences.edit',compact('mdpresence','msEleves','periodes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdpresence = MdPresence::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'presence_date'=>($request->presence_date??''),
					'nbre_min_retard'=>$request->nbre_min_retard,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'presence_date'=>'required',
					'nbre_min_retard'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdpresence->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $mdpresence->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdpresence',$mdpresence);
					return redirect()->back();
				}
				return redirect()->route('mdpresences.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
				// 
        MdPresence::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('mdpresences.index');
    }
}
