<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Disciplinary\Periode; 
class MdRetardsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mdretards
        $mdretards = MdRetard::all();

        // load the view and pass the mdretards
        return view('Masomwetu.Disciplinary.mdretards.index')
            ->with('mdretards', $mdretards);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mdretards/create.blade.php)
        $mdretard = new MdRetard;
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
        return view('Masomwetu.Disciplinary.mdretards.create',compact('mdretard','msEleves','periodes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'retard_date'=>($request->retard_date??''),
					'nbre_min_retard'=>$request->nbre_min_retard,
					'justif_date'=>($request->justif_date??''),
					'justif_detail'=>$request->justif_detail,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'retard_date'=>'required',
					'nbre_min_retard'=>'required',
					'justif_date'=>'',
					'justif_detail'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mdretard = MdRetard::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mdretard->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mdretard',$mdretard);
					return redirect()->back();
				}return redirect()->route('mdretards.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mdretard = MdRetard::findOrFail($id);
				return view('Masomwetu.Disciplinary.mdretards.show',compact('mdretard'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mdretard = MdRetard::findOrFail($id);
				$msEleves = MsEleve::all();
				$periodes = Periode::all();
				return view('Masomwetu.Disciplinary.mdretards.edit',compact('mdretard','msEleves','periodes'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mdretard = MdRetard::findOrFail($id);
				$datas = [
				'ms_eleve_id'=>$request->ms_eleve_id,
					'periode_id'=>$request->periode_id,
					'retard_date'=>($request->retard_date??''),
					'nbre_min_retard'=>$request->nbre_min_retard,
					'justif_date'=>($request->justif_date??''),
					'justif_detail'=>$request->justif_detail,
				];
				$rules = [
				'ms_eleve_id'=>'required',
					'periode_id'=>'required',
					'retard_date'=>'required',
					'nbre_min_retard'=>'required',
					'justif_date'=>'',
					'justif_detail'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mdretard->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mdretards.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MdRetard::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mdretards.index');
    }
}
