<?php

namespace App\Http\Controllers\Masomwetu\Disciplinary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Disciplinary\Periode;
use App\Masomwetu\Disciplinary\MdCommentaire;
use App\Masomwetu\Disciplinary\MdRetard;
use App\Masomwetu\Disciplinary\MdAbsence; 
class PeriodesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the periodes
        $periodes = Periode::all();

        // load the view and pass the periodes
        return view('Masomwetu.Disciplinary.periodes.index')
            ->with('periodes', $periodes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/periodes/create.blade.php)
        $periode = new Periode;
        return view('Masomwetu.Disciplinary.periodes.create',compact('periode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'periode'=>$request->periode,
					'etat'=>$request->etat,
					'date_debut'=>($request->date_debut??''),
					'date_fin'=>($request->date_fin??''),
				];
				$rules = [
				'periode'=>'required',
					'etat'=>'required',
					'date_debut'=>'required',
					'date_fin'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$periode = Periode::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $periode->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('periode',$periode);
					return redirect()->back();
				}return redirect()->route('periodes.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $periode = Periode::findOrFail($id);
				return view('Masomwetu.Disciplinary.periodes.show',compact('periode'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $periode = Periode::findOrFail($id);
				return view('Masomwetu.Disciplinary.periodes.edit',compact('periode'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$periode = Periode::findOrFail($id);
				$datas = [
				'periode'=>$request->periode,
					'etat'=>$request->etat,
					'date_debut'=>($request->date_debut??''),
					'date_fin'=>($request->date_fin??''),
				];
				$rules = [
				'periode'=>'required',
					'etat'=>'required',
					'date_debut'=>'required',
					'date_fin'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$periode->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('periodes.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Periode::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('periodes.index');
    }
}
