<?php

namespace App\Http\Controllers\Masomwetu\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Payment\MpFrais;
use App\Masomwetu\Payment\MpTypeFrais;
use App\Masomwetu\Scholar\MsAnneeScolaire;
use App\Masomwetu\Cash\McMois;
use App\Masomwetu\Payment\MpFraisClasse; 
class MpFraissController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mpfraiss
        $mpfraiss = MpFrais::all();

        // load the view and pass the mpfraiss
        return view('Masomwetu.Payment.mpfraiss.index')
            ->with('mpfraiss', $mpfraiss);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mpfraiss/create.blade.php)
        $mpfrais = new MpFrais;
				$mpTypeFraiss = MpTypeFrais::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
				$mcMoiss = McMois::all();
        return view('Masomwetu.Payment.mpfraiss.create',compact('mpfrais','mpTypeFraiss','msAnneeScolaires','mcMoiss'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'frais'=>$request->frais,
					'default_montant'=>$request->default_montant,
					'mp_type_frais_id'=>$request->mp_type_frais_id,
					'devise'=>$request->devise,
					'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
					'priorite'=>$request->priorite,
          'mc_mois_id'=>$request->mc_mois_id,
          'date_debut_paiement'=>$request->date_debut_paiement,
          'date_fin_paiement'=>$request->date_fin_paiement,
          'date_butoire'=>$request->date_butoire,
          
          
				];
				$rules = [
				'frais'=>'required',
					'default_montant'=>'required',
					'mp_type_frais_id'=>'required',
					'devise'=>'',
					'ms_annee_scolaire_id'=>'required',
					'priorite'=>'',
					'mc_mois_id'=>'',
          'date_debut_paiement'=>'',
          'date_fin_paiement'=>'',
          'date_butoire'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mpfrais = MpFrais::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mpfrais->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mpfrais',$mpfrais);
					return redirect()->back();
				}return redirect()->route('mpfraiss.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mpfrais = MpFrais::findOrFail($id);
				return view('Masomwetu.Payment.mpfraiss.show',compact('mpfrais'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mpfrais = MpFrais::findOrFail($id);
				$mpTypeFraiss = MpTypeFrais::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
				$mcMoiss = McMois::all();
				return view('Masomwetu.Payment.mpfraiss.edit',compact('mpfrais','mpTypeFraiss','msAnneeScolaires','mcMoiss'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mpfrais = MpFrais::findOrFail($id);
				$datas = [
          'frais'=>$request->frais,
            'default_montant'=>$request->default_montant,
            'mp_type_frais_id'=>$request->mp_type_frais_id,
            'devise'=>$request->devise,
            'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
            'priorite'=>$request->priorite,
            'mc_mois_id'=>$request->mc_mois_id,
            'date_debut_paiement'=>$request->date_debut_paiement,
            'date_fin_paiement'=>$request->date_fin_paiement,
            'date_butoire'=>$request->date_butoire,
            
            
          ];
          $rules = [
          'frais'=>'required',
            'default_montant'=>'required',
            'mp_type_frais_id'=>'required',
            'devise'=>'',
            'ms_annee_scolaire_id'=>'required',
            'priorite'=>'',
            'mc_mois_id'=>'',
            'date_debut_paiement'=>'',
            'date_fin_paiement'=>'',
            'date_butoire'=>'',
          ];
				\Validator::make($datas,$rules)->validate();
				$mpfrais->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mpfraiss.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MpFrais::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mpfraiss.index');
    }
}
