<?php

namespace App\Http\Controllers\Masomwetu\Presence;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Presence\JustifAbsence;
use App\Masomwetu\Presence\Pointage;
use App\Masomwetu\Presence\PrevisionArriveeSortie; 
class JustifAbsencesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the justifabsences
        $justifabsences = JustifAbsence::all();

        // load the view and pass the justifabsences
        return view('Masomwetu.Presence.justifabsences.index')
            ->with('justifabsences', $justifabsences);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/justifabsences/create.blade.php)
        $justifabsence = new JustifAbsence;
        return view('Masomwetu.Presence.justifabsences.create',compact('justifabsence'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'justification'=>$request->justification,
					'abreviation'=>$request->abreviation,
				];
				$rules = [
				'justification'=>'required',
					'abreviation'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$justifabsence = JustifAbsence::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $justifabsence->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('justifabsence',$justifabsence);
					return redirect()->back();
				}return redirect()->route('justifabsences.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $justifabsence = JustifAbsence::findOrFail($id);
				return view('Masomwetu.Presence.justifabsences.show',compact('justifabsence'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $justifabsence = JustifAbsence::findOrFail($id);
				return view('Masomwetu.Presence.justifabsences.edit',compact('justifabsence'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$justifabsence = JustifAbsence::findOrFail($id);
				$datas = [
				'justification'=>$request->justification,
					'abreviation'=>$request->abreviation,
				];
				$rules = [
				'justification'=>'required',
					'abreviation'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$justifabsence->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('justifabsences.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        JustifAbsence::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('justifabsences.index');
    }
}
