<?php

namespace App\Http\Controllers\Masomwetu\Presence;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Presence\PrevisionArriveeSortie;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\Presence\JustifAbsence; 
class PrevisionArriveeSortiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the previsionarriveesorties
        $previsionarriveesorties = PrevisionArriveeSortie::all();

        // load the view and pass the previsionarriveesorties
        return view('Masomwetu.Presence.previsionarriveesorties.index')
            ->with('previsionarriveesorties', $previsionarriveesorties);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/previsionarriveesorties/create.blade.php)
        $previsionarriveesortie = new PrevisionArriveeSortie;
				$personnels = Personnel::all();
				$justifAbsences = JustifAbsence::all();
        return view('Masomwetu.Presence.previsionarriveesorties.create',compact('previsionarriveesortie','personnels','justifAbsences'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'jour_semaine'=>$request->jour_semaine,
					'heure_arrivee'=>$request->heure_arrivee,
					'heure_sortie'=>$request->heure_sortie,
					'observation'=>$request->observation,
					'justif_absence_id'=>$request->justif_absence_id,
					'date_fin_validite'=>($request->date_fin_validite??''),
					'date_debut_validite'=>($request->date_debut_validite??''),
				];
				$rules = [
				'personnel_id'=>'required',
					'jour_semaine'=>'required',
					'heure_arrivee'=>'required',
					'heure_sortie'=>'required',
					'observation'=>'',
					'justif_absence_id'=>'',
					'date_fin_validite'=>'',
					'date_debut_validite'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$previsionarriveesortie = PrevisionArriveeSortie::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $previsionarriveesortie->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('previsionarriveesortie',$previsionarriveesortie);
					return redirect()->back();
				}return redirect()->route('previsionarriveesorties.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $previsionarriveesortie = PrevisionArriveeSortie::findOrFail($id);
				return view('Masomwetu.Presence.previsionarriveesorties.show',compact('previsionarriveesortie'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $previsionarriveesortie = PrevisionArriveeSortie::findOrFail($id);
				$personnels = Personnel::all();
				$justifAbsences = JustifAbsence::all();
				return view('Masomwetu.Presence.previsionarriveesorties.edit',compact('previsionarriveesortie','personnels','justifAbsences'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$previsionarriveesortie = PrevisionArriveeSortie::findOrFail($id);
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'jour_semaine'=>$request->jour_semaine,
					'heure_arrivee'=>$request->heure_arrivee,
					'heure_sortie'=>$request->heure_sortie,
					'observation'=>$request->observation,
					'justif_absence_id'=>$request->justif_absence_id,
					'date_fin_validite'=>($request->date_fin_validite??''),
				];
				$rules = [
				'personnel_id'=>'required',
					'jour_semaine'=>'required',
					'heure_arrivee'=>'required',
					'heure_sortie'=>'required',
					'observation'=>'',
					'justif_absence_id'=>'',
					'date_fin_validite'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$previsionarriveesortie->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('previsionarriveesorties.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        PrevisionArriveeSortie::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('previsionarriveesorties.index');
    }
}
