<?php

namespace App\Http\Controllers\Masomwetu\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Report\MrCoursPromotion;
use App\Masomwetu\Report\MrGroupeCours;
use App\Masomwetu\Scholar\MsPromotion;
use App\Masomwetu\Report\MrCours; 
class MrCoursPromotionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mrcourspromotions
        $mrcourspromotions = MrCoursPromotion::all();

        // load the view and pass the mrcourspromotions
        return view('Masomwetu.Report.mrcourspromotions.index')
            ->with('mrcourspromotions', $mrcourspromotions);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mrcourspromotions/create.blade.php)
        $mrcourspromotion = new MrCoursPromotion;
				$mrGroupeCourss = MrGroupeCours::all();
				$msPromotions = MsPromotion::all();
        return view('Masomwetu.Report.mrcourspromotions.create',compact('mrcourspromotion','mrGroupeCourss','msPromotions'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'intitule_cours'=>$request->intitule_cours,
					'max_periode'=>$request->max_periode,
					'coter_examen'=>$request->coter_examen,
					'num_bulletin'=>$request->num_bulletin,
					'mr_groupe_cours_id'=>$request->mr_groupe_cours_id,
					'ms_promotion_id'=>$request->ms_promotion_id,
				];
				$rules = [
				'intitule_cours'=>'required',
					'max_periode'=>'required',
					'coter_examen'=>'',
					'num_bulletin'=>'required',
					'mr_groupe_cours_id'=>'required',
					'ms_promotion_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mrcourspromotion = MrCoursPromotion::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mrcourspromotion->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mrcourspromotion',$mrcourspromotion);
					return redirect()->back();
				}return redirect()->route('mrcourspromotions.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mrcourspromotion = MrCoursPromotion::findOrFail($id);
				return view('Masomwetu.Report.mrcourspromotions.show',compact('mrcourspromotion'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mrcourspromotion = MrCoursPromotion::findOrFail($id);
				$mrGroupeCourss = MrGroupeCours::all();
				$msPromotions = MsPromotion::all();
				return view('Masomwetu.Report.mrcourspromotions.edit',compact('mrcourspromotion','mrGroupeCourss','msPromotions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mrcourspromotion = MrCoursPromotion::findOrFail($id);
				$datas = [
				'intitule_cours'=>$request->intitule_cours,
					'max_periode'=>$request->max_periode,
					'coter_examen'=>$request->coter_examen,
					'num_bulletin'=>$request->num_bulletin,
					'mr_groupe_cours_id'=>$request->mr_groupe_cours_id,
					'ms_promotion_id'=>$request->ms_promotion_id,
				];
				$rules = [
				'intitule_cours'=>'required',
					'max_periode'=>'required',
					'coter_examen'=>'',
					'num_bulletin'=>'required',
					'mr_groupe_cours_id'=>'required',
					'ms_promotion_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mrcourspromotion->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mrcourspromotions.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MrCoursPromotion::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mrcourspromotions.index');
    }
}
