<?php

namespace App\Http\Controllers\Masomwetu\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Report\MrGroupeCours;
use App\Masomwetu\Report\MrCoursPromotion; 
class MrGroupeCourssController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mrgroupecourss
        $mrgroupecourss = MrGroupeCours::all();

        // load the view and pass the mrgroupecourss
        return view('Masomwetu.Report.mrgroupecourss.index')
            ->with('mrgroupecourss', $mrgroupecourss);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mrgroupecourss/create.blade.php)
        $mrgroupecours = new MrGroupeCours;
        return view('Masomwetu.Report.mrgroupecourss.create',compact('mrgroupecours'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'groupe'=>$request->groupe,
					'num_groupe'=>$request->num_groupe,
				];
				$rules = [
				'groupe'=>'required',
					'num_groupe'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$mrgroupecours = MrGroupeCours::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mrgroupecours->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mrgroupecours',$mrgroupecours);
					return redirect()->back();
				}return redirect()->route('mrgroupecourss.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mrgroupecours = MrGroupeCours::findOrFail($id);
				return view('Masomwetu.Report.mrgroupecourss.show',compact('mrgroupecours'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mrgroupecours = MrGroupeCours::findOrFail($id);
				return view('Masomwetu.Report.mrgroupecourss.edit',compact('mrgroupecours'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mrgroupecours = MrGroupeCours::findOrFail($id);
				$datas = [
				'groupe'=>$request->groupe,
					'num_groupe'=>$request->num_groupe,
				];
				$rules = [
				'groupe'=>'required',
					'num_groupe'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mrgroupecours->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mrgroupecourss.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        MrGroupeCours::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mrgroupecourss.index');
    }
}
