<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaOperationSalaire;
use App\Masomwetu\Salary\SaSalarie;
use App\Masomwetu\Salary\SaRubriqueCategorieBulletin; 
class SaOperationSalairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the saoperationsalaires
        $saoperationsalaires = SaOperationSalaire::all();

        // load the view and pass the saoperationsalaires
        return view('Masomwetu.Salary.saoperationsalaires.index')
            ->with('saoperationsalaires', $saoperationsalaires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/saoperationsalaires/create.blade.php)
        $saoperationsalaire = new SaOperationSalaire;
				$saSalaries = SaSalarie::all();
				$saRubriqueCategorieBulletins = SaRubriqueCategorieBulletin::all();
        return view('Masomwetu.Salary.saoperationsalaires.create',compact('saoperationsalaire','saSalaries','saRubriqueCategorieBulletins'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'sa_salarie_id'=>$request->sa_salarie_id,
					'mois'=>$request->mois,
					'sa_rubrique_categorie_bulletin_id'=>$request->sa_rubrique_categorie_bulletin_id,
					'montant'=>$request->montant,
					'jour'=>($request->jour??''),
				];
				$rules = [
				'sa_salarie_id'=>'required',
					'mois'=>'required',
					'sa_rubrique_categorie_bulletin_id'=>'required',
					'montant'=>'required',
					'jour'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$saoperationsalaire = SaOperationSalaire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $saoperationsalaire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('saoperationsalaire',$saoperationsalaire);
					return redirect()->back();
				}return redirect()->route('saoperationsalaires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $saoperationsalaire = SaOperationSalaire::findOrFail($id);
				return view('Masomwetu.Salary.saoperationsalaires.show',compact('saoperationsalaire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $saoperationsalaire = SaOperationSalaire::findOrFail($id);
				$saSalaries = SaSalarie::all();
				$saRubriqueCategorieBulletins = SaRubriqueCategorieBulletin::all();
				return view('Masomwetu.Salary.saoperationsalaires.edit',compact('saoperationsalaire','saSalaries','saRubriqueCategorieBulletins'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$saoperationsalaire = SaOperationSalaire::findOrFail($id);
				$datas = [
				'sa_salarie_id'=>$request->sa_salarie_id,
					'mois'=>$request->mois,
					'sa_rubrique_categorie_bulletin_id'=>$request->sa_rubrique_categorie_bulletin_id,
					'montant'=>$request->montant,
					'jour'=>($request->jour??''),
				];
				$rules = [
				'sa_salarie_id'=>'required',
					'mois'=>'required',
					'sa_rubrique_categorie_bulletin_id'=>'required',
					'montant'=>'required',
					'jour'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$saoperationsalaire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('saoperationsalaires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaOperationSalaire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('saoperationsalaires.index');
    }
}
