<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaPaiementSalaire;
use App\Masomwetu\Salary\SaRubriquePayeSurBulletin; 
class SaPaiementSalairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sapaiementsalaires
        $sapaiementsalaires = SaPaiementSalaire::all();

        // load the view and pass the sapaiementsalaires
        return view('Masomwetu.Salary.sapaiementsalaires.index')
            ->with('sapaiementsalaires', $sapaiementsalaires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sapaiementsalaires/create.blade.php)
        $sapaiementsalaire = new SaPaiementSalaire;
        return view('Masomwetu.Salary.sapaiementsalaires.create',compact('sapaiementsalaire'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'date_paiement'=>($request->date_paiement??''),
					'periode'=>$request->periode,
					'mois'=>$request->mois,
					'annee'=>$request->annee,
				];
				$rules = [
				'date_paiement'=>'required',
					'periode'=>'required',
					'mois'=>'required',
					'annee'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$sapaiementsalaire = SaPaiementSalaire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sapaiementsalaire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sapaiementsalaire',$sapaiementsalaire);
					return redirect()->back();
				}return redirect()->route('sapaiementsalaires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sapaiementsalaire = SaPaiementSalaire::findOrFail($id);
				return view('Masomwetu.Salary.sapaiementsalaires.show',compact('sapaiementsalaire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sapaiementsalaire = SaPaiementSalaire::findOrFail($id);
				return view('Masomwetu.Salary.sapaiementsalaires.edit',compact('sapaiementsalaire'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sapaiementsalaire = SaPaiementSalaire::findOrFail($id);
				$datas = [
				'date_paiement'=>($request->date_paiement??''),
					'periode'=>$request->periode,
					'mois'=>$request->mois,
					'annee'=>$request->annee,
				];
				$rules = [
				'date_paiement'=>'required',
					'periode'=>'required',
					'mois'=>'required',
					'annee'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sapaiementsalaire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sapaiementsalaires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaPaiementSalaire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sapaiementsalaires.index');
    }
}
