<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaRubriqueCategorieBulletin;
use App\Masomwetu\Salary\SaCategorieBulletin;
use App\Masomwetu\Salary\SaRubriquePaie;
use App\Masomwetu\Salary\SaRubriquePayeSurBulletin;
use App\Masomwetu\Salary\SaOperationSalaire; 
class SaRubriqueCategorieBulletinsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sarubriquecategoriebulletins
        $sarubriquecategoriebulletins = SaRubriqueCategorieBulletin::all();

        // load the view and pass the sarubriquecategoriebulletins
        return view('Masomwetu.Salary.sarubriquecategoriebulletins.index')
            ->with('sarubriquecategoriebulletins', $sarubriquecategoriebulletins);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sarubriquecategoriebulletins/create.blade.php)
        $sarubriquecategoriebulletin = new SaRubriqueCategorieBulletin;
				$saCategorieBulletins = SaCategorieBulletin::all();
				$saRubriquePaies = SaRubriquePaie::all();
        return view('Masomwetu.Salary.sarubriquecategoriebulletins.create',compact('sarubriquecategoriebulletin','saCategorieBulletins','saRubriquePaies'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'sa_categorie_bulletin_id'=>$request->sa_categorie_bulletin_id,
					'sa_rubrique_paie_id'=>$request->sa_rubrique_paie_id,
					'montant_de_base'=>$request->montant_de_base,
					'qte_par_defaut'=>$request->qte_par_defaut,
					'actif'=>$request->actif,
				];
				$rules = [
				'sa_categorie_bulletin_id'=>'required',
					'sa_rubrique_paie_id'=>'required',
					'montant_de_base'=>'',
					'qte_par_defaut'=>'',
					'actif'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$sarubriquecategoriebulletin = SaRubriqueCategorieBulletin::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sarubriquecategoriebulletin->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sarubriquecategoriebulletin',$sarubriquecategoriebulletin);
					return redirect()->back();
				}return redirect()->route('sarubriquecategoriebulletins.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sarubriquecategoriebulletin = SaRubriqueCategorieBulletin::findOrFail($id);
				return view('Masomwetu.Salary.sarubriquecategoriebulletins.show',compact('sarubriquecategoriebulletin'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sarubriquecategoriebulletin = SaRubriqueCategorieBulletin::findOrFail($id);
				$saCategorieBulletins = SaCategorieBulletin::all();
				$saRubriquePaies = SaRubriquePaie::all();
				return view('Masomwetu.Salary.sarubriquecategoriebulletins.edit',compact('sarubriquecategoriebulletin','saCategorieBulletins','saRubriquePaies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sarubriquecategoriebulletin = SaRubriqueCategorieBulletin::findOrFail($id);
				$datas = [
				'sa_categorie_bulletin_id'=>$request->sa_categorie_bulletin_id,
					'sa_rubrique_paie_id'=>$request->sa_rubrique_paie_id,
					'montant_de_base'=>$request->montant_de_base,
					'qte_par_defaut'=>$request->qte_par_defaut,
					'actif'=>$request->actif,
				];
				$rules = [
				'sa_categorie_bulletin_id'=>'required',
					'sa_rubrique_paie_id'=>'required',
					'montant_de_base'=>'',
					'qte_par_defaut'=>'',
					'actif'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sarubriquecategoriebulletin->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sarubriquecategoriebulletins.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaRubriqueCategorieBulletin::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sarubriquecategoriebulletins.index');
    }
}
