<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaRubriquePaie;
use App\Masomwetu\Salary\SaRubriqueCategorieBulletin; 
class SaRubriquePaiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sarubriquepaies
        $sarubriquepaies = SaRubriquePaie::all();

        // load the view and pass the sarubriquepaies
        return view('Masomwetu.Salary.sarubriquepaies.index')
            ->with('sarubriquepaies', $sarubriquepaies);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sarubriquepaies/create.blade.php)
        $sarubriquepaie = new SaRubriquePaie;
        return view('Masomwetu.Salary.sarubriquepaies.create',compact('sarubriquepaie'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'libelle'=>$request->libelle,
					'type'=>$request->type,
					'actif'=>$request->actif,
				];
				$rules = [
				'libelle'=>'required',
					'type'=>'required',
					'actif'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$sarubriquepaie = SaRubriquePaie::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sarubriquepaie->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sarubriquepaie',$sarubriquepaie);
					return redirect()->back();
				}return redirect()->route('sarubriquepaies.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sarubriquepaie = SaRubriquePaie::findOrFail($id);
				return view('Masomwetu.Salary.sarubriquepaies.show',compact('sarubriquepaie'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sarubriquepaie = SaRubriquePaie::findOrFail($id);
				return view('Masomwetu.Salary.sarubriquepaies.edit',compact('sarubriquepaie'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sarubriquepaie = SaRubriquePaie::findOrFail($id);
				$datas = [
				'libelle'=>$request->libelle,
					'type'=>$request->type,
					'actif'=>$request->actif,
				];
				$rules = [
				'libelle'=>'required',
					'type'=>'required',
					'actif'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sarubriquepaie->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sarubriquepaies.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaRubriquePaie::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sarubriquepaies.index');
    }
}
