<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaRubriquePayeSurBulletin;
use App\Masomwetu\Salary\SaSalarie;
use App\Masomwetu\Salary\SaPaiementSalaire;
use App\Masomwetu\Salary\SaRubriqueCategorieBulletin; 
class SaRubriquePayeSurBulletinsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sarubriquepayesurbulletins
        $sarubriquepayesurbulletins = SaRubriquePayeSurBulletin::all();

        // load the view and pass the sarubriquepayesurbulletins
        return view('Masomwetu.Salary.sarubriquepayesurbulletins.index')
            ->with('sarubriquepayesurbulletins', $sarubriquepayesurbulletins);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sarubriquepayesurbulletins/create.blade.php)
        $sarubriquepayesurbulletin = new SaRubriquePayeSurBulletin;
				$saSalaries = SaSalarie::all();
				$saPaiementSalaires = SaPaiementSalaire::all();
				$saRubriqueCategorieBulletins = SaRubriqueCategorieBulletin::all();
        return view('Masomwetu.Salary.sarubriquepayesurbulletins.create',compact('sarubriquepayesurbulletin','saSalaries','saPaiementSalaires','saRubriqueCategorieBulletins'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'sa_salarie_id'=>$request->sa_salarie_id,
					'sa_paiement_salaire_id'=>$request->sa_paiement_salaire_id,
					'sa_rubrique_categorie_bulletin_id'=>$request->sa_rubrique_categorie_bulletin_id,
					'montant'=>$request->montant,
				];
				$rules = [
				'sa_salarie_id'=>'required',
					'sa_paiement_salaire_id'=>'required',
					'sa_rubrique_categorie_bulletin_id'=>'required',
					'montant'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$sarubriquepayesurbulletin = SaRubriquePayeSurBulletin::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sarubriquepayesurbulletin->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sarubriquepayesurbulletin',$sarubriquepayesurbulletin);
					return redirect()->back();
				}return redirect()->route('sarubriquepayesurbulletins.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sarubriquepayesurbulletin = SaRubriquePayeSurBulletin::findOrFail($id);
				return view('Masomwetu.Salary.sarubriquepayesurbulletins.show',compact('sarubriquepayesurbulletin'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sarubriquepayesurbulletin = SaRubriquePayeSurBulletin::findOrFail($id);
				$saSalaries = SaSalarie::all();
				$saPaiementSalaires = SaPaiementSalaire::all();
				$saRubriqueCategorieBulletins = SaRubriqueCategorieBulletin::all();
				return view('Masomwetu.Salary.sarubriquepayesurbulletins.edit',compact('sarubriquepayesurbulletin','saSalaries','saPaiementSalaires','saRubriqueCategorieBulletins'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sarubriquepayesurbulletin = SaRubriquePayeSurBulletin::findOrFail($id);
				$datas = [
				'sa_salarie_id'=>$request->sa_salarie_id,
					'sa_paiement_salaire_id'=>$request->sa_paiement_salaire_id,
					'sa_rubrique_categorie_bulletin_id'=>$request->sa_rubrique_categorie_bulletin_id,
					'montant'=>$request->montant,
				];
				$rules = [
				'sa_salarie_id'=>'required',
					'sa_paiement_salaire_id'=>'required',
					'sa_rubrique_categorie_bulletin_id'=>'required',
					'montant'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sarubriquepayesurbulletin->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sarubriquepayesurbulletins.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaRubriquePayeSurBulletin::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sarubriquepayesurbulletins.index');
    }
}
