<?php

namespace App\Http\Controllers\Masomwetu\Salary;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Salary\SaSalarie;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\Salary\SaCategorieBulletin;
use App\Masomwetu\Salary\SaRubriquePayeSurBulletin;
use App\Masomwetu\Salary\SaOperationSalaire; 
class SaSalariesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sasalaries
        $sasalaries = SaSalarie::all();

        // load the view and pass the sasalaries
        return view('Masomwetu.Salary.sasalaries.index')
            ->with('sasalaries', $sasalaries);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sasalaries/create.blade.php)
        $sasalarie = new SaSalarie;
				$personnels = Personnel::all();
				$saCategorieBulletins = SaCategorieBulletin::all();
        return view('Masomwetu.Salary.sasalaries.create',compact('sasalarie','personnels','saCategorieBulletins'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'sa_categorie_bulletin_id'=>$request->sa_categorie_bulletin_id,
					'actif'=>$request->actif,
				];
				$rules = [
				'personnel_id'=>'required',
					'sa_categorie_bulletin_id'=>'required',
					'actif'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$sasalarie = SaSalarie::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sasalarie->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sasalarie',$sasalarie);
					return redirect()->back();
				}return redirect()->route('sasalaries.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sasalarie = SaSalarie::findOrFail($id);
				return view('Masomwetu.Salary.sasalaries.show',compact('sasalarie'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sasalarie = SaSalarie::findOrFail($id);
				$personnels = Personnel::all();
				$saCategorieBulletins = SaCategorieBulletin::all();
				return view('Masomwetu.Salary.sasalaries.edit',compact('sasalarie','personnels','saCategorieBulletins'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sasalarie = SaSalarie::findOrFail($id);
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'sa_categorie_bulletin_id'=>$request->sa_categorie_bulletin_id,
					'actif'=>$request->actif,
				];
				$rules = [
				'personnel_id'=>'required',
					'sa_categorie_bulletin_id'=>'required',
					'actif'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sasalarie->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sasalaries.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SaSalarie::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sasalaries.index');
    }
}
