<?php

namespace App\Http\Controllers\Masomwetu\Schedule;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Schedule\ScHeure;
use App\Masomwetu\Schedule\ScHoraire; 
class ScHeuresController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the scheures
        $scheures = ScHeure::all();

        // load the view and pass the scheures
        return view('Masomwetu.Schedule.scheures.index')
            ->with('scheures', $scheures);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/scheures/create.blade.php)
        $scheure = new ScHeure;
        return view('Masomwetu.Schedule.scheures.create',compact('scheure'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'jour'=>$request->jour,
					'num'=>$request->num,
					'num_jr'=>$request->num_jr,
				];
				$rules = [
				'jour'=>'required',
					'num'=>'required',
					'num_jr'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$scheure = ScHeure::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $scheure->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('scheure',$scheure);
					return redirect()->back();
				}return redirect()->route('scheures.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $scheure = ScHeure::findOrFail($id);
				return view('Masomwetu.Schedule.scheures.show',compact('scheure'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $scheure = ScHeure::findOrFail($id);
				return view('Masomwetu.Schedule.scheures.edit',compact('scheure'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$scheure = ScHeure::findOrFail($id);
				$datas = [
				'jour'=>$request->jour,
					'num'=>$request->num,
					'num_jr'=>$request->num_jr,
				];
				$rules = [
				'jour'=>'required',
					'num'=>'required',
					'num_jr'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$scheure->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('scheures.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        ScHeure::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('scheures.index');
    }
}
