<?php

namespace App\Http\Controllers\Masomwetu\Schedule;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Schedule\ScHoraire;
use App\Masomwetu\Schedule\ScHeure;
use App\Masomwetu\Report\MrCours;
use App\Masomwetu\Schedule\ScPeriodeHoraire; 
class ScHorairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the schoraires
        $schoraires = ScHoraire::all();

        // load the view and pass the schoraires
        return view('Masomwetu.Schedule.schoraires.index')
            ->with('schoraires', $schoraires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/schoraires/create.blade.php)
        $schoraire = new ScHoraire;
				$scHeures = ScHeure::all();
				$mrCourss = MrCours::all();
				$scPeriodeHoraires = ScPeriodeHoraire::all();
        return view('Masomwetu.Schedule.schoraires.create',compact('schoraire','scHeures','mrCourss','scPeriodeHoraires'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'sc_heure_id'=>$request->sc_heure_id,
					'mr_cours_id'=>$request->mr_cours_id,
					'sc_periode_horaire_id'=>$request->sc_periode_horaire_id,
				];
				$rules = [
				'sc_heure_id'=>'required',
					'mr_cours_id'=>'required',
					'sc_periode_horaire_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$schoraire = ScHoraire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $schoraire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('schoraire',$schoraire);
					return redirect()->back();
				}return redirect()->route('schoraires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $schoraire = ScHoraire::findOrFail($id);
				return view('Masomwetu.Schedule.schoraires.show',compact('schoraire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $schoraire = ScHoraire::findOrFail($id);
				$scHeures = ScHeure::all();
				$mrCourss = MrCours::all();
				$scPeriodeHoraires = ScPeriodeHoraire::all();
				return view('Masomwetu.Schedule.schoraires.edit',compact('schoraire','scHeures','mrCourss','scPeriodeHoraires'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$schoraire = ScHoraire::findOrFail($id);
				$datas = [
				'sc_heure_id'=>$request->sc_heure_id,
					'mr_cours_id'=>$request->mr_cours_id,
					'sc_periode_horaire_id'=>$request->sc_periode_horaire_id,
				];
				$rules = [
				'sc_heure_id'=>'required',
					'mr_cours_id'=>'required',
					'sc_periode_horaire_id'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$schoraire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('schoraires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        ScHoraire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('schoraires.index');
    }
}
