<?php

namespace App\Http\Controllers\Masomwetu\Schedule;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Schedule\ScPeriodeHoraire;
use App\Masomwetu\Schedule\ScHoraire; 
class ScPeriodeHorairesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the scperiodehoraires
        $scperiodehoraires = ScPeriodeHoraire::all();

        // load the view and pass the scperiodehoraires
        return view('Masomwetu.Schedule.scperiodehoraires.index')
            ->with('scperiodehoraires', $scperiodehoraires);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/scperiodehoraires/create.blade.php)
        $scperiodehoraire = new ScPeriodeHoraire;
        return view('Masomwetu.Schedule.scperiodehoraires.create',compact('scperiodehoraire'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'date1'=>($request->date1??''),
					'date2'=>($request->date2??''),
					'actif'=>$request->actif,
				];
				$rules = [
				'date1'=>'required',
					'date2'=>'required',
					'actif'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$scperiodehoraire = ScPeriodeHoraire::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $scperiodehoraire->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('scperiodehoraire',$scperiodehoraire);
					return redirect()->back();
				}return redirect()->route('scperiodehoraires.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $scperiodehoraire = ScPeriodeHoraire::findOrFail($id);
				return view('Masomwetu.Schedule.scperiodehoraires.show',compact('scperiodehoraire'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $scperiodehoraire = ScPeriodeHoraire::findOrFail($id);
				return view('Masomwetu.Schedule.scperiodehoraires.edit',compact('scperiodehoraire'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$scperiodehoraire = ScPeriodeHoraire::findOrFail($id);
				$datas = [
				'date1'=>($request->date1??''),
					'date2'=>($request->date2??''),
					'actif'=>$request->actif,
				];
				$rules = [
				'date1'=>'required',
					'date2'=>'required',
					'actif'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$scperiodehoraire->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('scperiodehoraires.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        ScPeriodeHoraire::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('scperiodehoraires.index');
    }
}
