<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\Scholar\MsEleve;
use App\Masomwetu\Scholar\MsInscription; 
class EnfantsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the enfants
        $enfants = Enfant::all();

        // load the view and pass the enfants
        return view('Masomwetu.Scholar.enfants.index')
            ->with('enfants', $enfants);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/enfants/create.blade.php)
        $enfant = new Enfant;
        return view('Masomwetu.Scholar.enfants.create',compact('enfant'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'matricule'=>$request->matricule,
					'nom'=>$request->nom,
					'postnom'=>$request->postnom,
					'prenom'=>$request->prenom,
					'genre'=>$request->genre,
					'datenaiss'=>($request->datenaiss??''),
					'lieunaiss'=>$request->lieunaiss,
				];
				$rules = [
				'matricule'=>'required',
					'nom'=>'required',
					'postnom'=>'required',
					'prenom'=>'required',
					'genre'=>'required',
					'datenaiss'=>'',
					'lieunaiss'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$enfant = Enfant::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $enfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('enfant',$enfant);
					return redirect()->back();
				}return redirect()->route('enfants.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $enfant = Enfant::findOrFail($id);
				return view('Masomwetu.Scholar.enfants.show',compact('enfant'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $enfant = Enfant::findOrFail($id);
				return view('Masomwetu.Scholar.enfants.edit',compact('enfant'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$enfant = Enfant::findOrFail($id);
				$datas = [
				'matricule'=>$request->matricule,
					'nom'=>$request->nom,
					'postnom'=>$request->postnom,
					'prenom'=>$request->prenom,
					'genre'=>$request->genre,
					'datenaiss'=>($request->datenaiss??''),
					'lieunaiss'=>$request->lieunaiss,
				];
				$rules = [
				'matricule'=>'required',
					'nom'=>'required',
					'postnom'=>'required',
					'prenom'=>'required',
					'genre'=>'required',
					'datenaiss'=>'',
					'lieunaiss'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$enfant->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('enfants.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        Enfant::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('enfants.index');
    }
}
