<?php

namespace App\Http\Controllers\Masomwetu\Scholar;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Scholar\StatusEnfant;
use App\Masomwetu\Scholar\MsEleve; 
class StatusEnfantsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the statusenfants
        $statusenfants = StatusEnfant::all();

        // load the view and pass the statusenfants
        return view('Masomwetu.Scholar.statusenfants.index')
            ->with('statusenfants', $statusenfants);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/statusenfants/create.blade.php)
        $statusenfant = new StatusEnfant;
        return view('Masomwetu.Scholar.statusenfants.create',compact('statusenfant'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'status'=>$request->status,
					'description_statu'=>$request->description_statu,
				];
				$rules = [
				'status'=>'required',
					'description_statu'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$statusenfant = StatusEnfant::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $statusenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('statusenfant',$statusenfant);
					return redirect()->back();
				}return redirect()->route('statusenfants.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $statusenfant = StatusEnfant::findOrFail($id);
				return view('Masomwetu.Scholar.statusenfants.show',compact('statusenfant'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $statusenfant = StatusEnfant::findOrFail($id);
				return view('Masomwetu.Scholar.statusenfants.edit',compact('statusenfant'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$statusenfant = StatusEnfant::findOrFail($id);
				$datas = [
				'status'=>$request->status,
					'description_statu'=>$request->description_statu,
				];
				$rules = [
				'status'=>'required',
					'description_statu'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$statusenfant->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('statusenfants.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        StatusEnfant::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('statusenfants.index');
    }
}
