<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\DossierEnfant;
use App\Masomwetu\Scholar\Enfant;
use App\Masomwetu\School\ImgDossierEnfant; 
class DossierEnfantsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the dossierenfants
        $dossierenfants = DossierEnfant::all();

        // load the view and pass the dossierenfants
        return view('Masomwetu.School.dossierenfants.index')
            ->with('dossierenfants', $dossierenfants);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/dossierenfants/create.blade.php)
        $dossierenfant = new DossierEnfant;
				$enfants = Enfant::all();
        return view('Masomwetu.School.dossierenfants.create',compact('dossierenfant','enfants'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'enfant_id'=>$request->enfant_id,
					'titre_document'=>$request->titre_document,
					'description'=>$request->description,
				];
				$rules = [
				'enfant_id'=>'required',
					'titre_document'=>'required',
					'description'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$dossierenfant = DossierEnfant::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $dossierenfant;
					$id = $dossierenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('dossierenfant',$dossierenfant);
					return redirect()->back();
				}
				return redirect()->route('dossierenfants.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $dossierenfant = DossierEnfant::findOrFail($id);
				return view('Masomwetu.School.dossierenfants.show',compact('dossierenfant'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $dossierenfant = DossierEnfant::findOrFail($id);
				$enfants = Enfant::all();
				return view('Masomwetu.School.dossierenfants.edit',compact('dossierenfant','enfants'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$dossierenfant = DossierEnfant::findOrFail($id);
				$datas = [
				'enfant_id'=>$request->enfant_id,
					'titre_document'=>$request->titre_document,
					'description'=>$request->description,
				];
				$rules = [
				'enfant_id'=>'required',
					'titre_document'=>'required',
					'description'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$dossierenfant->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $dossierenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('dossierenfant',$dossierenfant);
					return redirect()->back();
				}
				return redirect()->route('dossierenfants.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        DossierEnfant::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('dossierenfants.index');
    }
}
