<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\DossierPersonnel;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\School\ImgDocument; 
class DossierPersonnelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the dossierpersonnels
        $dossierpersonnels = DossierPersonnel::all();

        // load the view and pass the dossierpersonnels
        return view('Masomwetu.School.dossierpersonnels.index')
            ->with('dossierpersonnels', $dossierpersonnels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/dossierpersonnels/create.blade.php)
        $dossierpersonnel = new DossierPersonnel;
				$personnels = Personnel::all();
        return view('Masomwetu.School.dossierpersonnels.create',compact('dossierpersonnel','personnels'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'titre_document'=>$request->titre_document,
					'description'=>$request->description,
				];
				$rules = [
				'personnel_id'=>'required',
					'titre_document'=>'required',
					'description'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$dossierpersonnel = DossierPersonnel::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $dossierpersonnel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('dossierpersonnel',$dossierpersonnel);
					return redirect()->back();
				}return redirect()->route('dossierpersonnels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $dossierpersonnel = DossierPersonnel::findOrFail($id);
				return view('Masomwetu.School.dossierpersonnels.show',compact('dossierpersonnel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $dossierpersonnel = DossierPersonnel::findOrFail($id);
				$personnels = Personnel::all();
				return view('Masomwetu.School.dossierpersonnels.edit',compact('dossierpersonnel','personnels'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$dossierpersonnel = DossierPersonnel::findOrFail($id);
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'titre_document'=>$request->titre_document,
					'description'=>$request->description,
				];
				$rules = [
				'personnel_id'=>'required',
					'titre_document'=>'required',
					'description'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$dossierpersonnel->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('dossierpersonnels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
				// 
        DossierPersonnel::destroy($id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('dossierpersonnels.index');
    }
}
