<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\ImgDocument;
use App\Masomwetu\School\DossierPersonnel; 
class ImgDocumentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the imgdocuments
        $imgdocuments = ImgDocument::all();

        // load the view and pass the imgdocuments
        return view('Masomwetu.School.imgdocuments.index')
            ->with('imgdocuments', $imgdocuments);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/imgdocuments/create.blade.php)
        $imgdocument = new ImgDocument;
				$dossierPersonnels = DossierPersonnel::all();
        return view('Masomwetu.School.imgdocuments.create',compact('imgdocument','dossierPersonnels'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'dossier_personnel_id'=>$request->dossier_personnel_id,
				];
				$rules = [
				'dossier_personnel_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$imgdocument = ImgDocument::create($datas);
				if($scan = chado_saveFile('public/imgdocument/scan/','scan',$imgdocument->id)){
					$imgdocument->scan = $scan;
					$imgdocument->save();
				}
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $imgdocument->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('imgdocument',$imgdocument);
					return redirect()->back();
				}return redirect()->route('imgdocuments.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $imgdocument = ImgDocument::findOrFail($id);
				return view('Masomwetu.School.imgdocuments.show',compact('imgdocument'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $imgdocument = ImgDocument::findOrFail($id);
				$dossierPersonnels = DossierPersonnel::all();
				return view('Masomwetu.School.imgdocuments.edit',compact('imgdocument','dossierPersonnels'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$imgdocument = ImgDocument::findOrFail($id);
				$datas = [
				'dossier_personnel_id'=>$request->dossier_personnel_id,
				];
				$rules = [
				'dossier_personnel_id'=>'required',
				];
				
				if($request->check_scan or $request->scan){
					if($request->scan and ($scan = chado_saveFile('public/imgdocument/scan/','scan',$imgdocument->id)))
						$datas['scan'] = $scan;
					else $datas['scan'] = '';
					$rules['scan'] = '';
				}
					
				\Validator::make($datas,$rules)->validate();
				$imgdocument->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('imgdocuments.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
				// 
        ImgDocument::destroy($id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
				my_flash("Suppression effectée","danger");
				return redirect()->route('imgdocuments.index');
    }
}
