<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\ImgDossierEnfant;
use App\Masomwetu\School\DossierEnfant; 
class ImgDossierEnfantsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the imgdossierenfants
        $imgdossierenfants = ImgDossierEnfant::all();

        // load the view and pass the imgdossierenfants
        return view('Masomwetu.School.imgdossierenfants.index')
            ->with('imgdossierenfants', $imgdossierenfants);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/imgdossierenfants/create.blade.php)
        $imgdossierenfant = new ImgDossierEnfant;
				$dossierEnfants = DossierEnfant::all();
        return view('Masomwetu.School.imgdossierenfants.create',compact('imgdossierenfant','dossierEnfants'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'dossier_enfant_id'=>$request->dossier_enfant_id,
				];
				$rules = [
				'dossier_enfant_id'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$imgdossierenfant = ImgDossierEnfant::create($datas);
				if($scan = chado_saveFile('public/imgdossierenfant/scan/','scan',$imgdossierenfant->id)){
					$imgdossierenfant->scan = $scan;
					$imgdossierenfant->save();
				}
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					if($request->redirectTo=="AJAX")
						return $imgdossierenfant;
					$id = $imgdossierenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('imgdossierenfant',$imgdossierenfant);
					return redirect()->back();
				}
				return redirect()->route('imgdossierenfants.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $imgdossierenfant = ImgDossierEnfant::findOrFail($id);
				return view('Masomwetu.School.imgdossierenfants.show',compact('imgdossierenfant'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $imgdossierenfant = ImgDossierEnfant::findOrFail($id);
				$dossierEnfants = DossierEnfant::all();
				return view('Masomwetu.School.imgdossierenfants.edit',compact('imgdossierenfant','dossierEnfants'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$imgdossierenfant = ImgDossierEnfant::findOrFail($id);
				$datas = [
				'dossier_enfant_id'=>$request->dossier_enfant_id,
				];
				$rules = [
				'dossier_enfant_id'=>'required',
				];
				
				if($request->check_scan or $request->scan){
					if($request->scan and ($scan = chado_saveFile('public/imgdossierenfant/scan/','scan',$imgdossierenfant->id)))
						$datas['scan'] = $scan;
					else $datas['scan'] = '';
					$rules['scan'] = '';
				}
					
				\Validator::make($datas,$rules)->validate();
				$imgdossierenfant->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $imgdossierenfant->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('imgdossierenfant',$imgdossierenfant);
					return redirect()->back();
				}
				return redirect()->route('imgdossierenfants.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        ImgDossierEnfant::destroy( $id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
		my_flash("Suppression effectée","danger");
		return redirect()->route('imgdossierenfants.index');
    }
}
