<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\McFonction;
use App\Masomwetu\School\Agent; 
class McFonctionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the mcfonctions
        $mcfonctions = McFonction::all();

        // load the view and pass the mcfonctions
        return view('Masomwetu.School.mcfonctions.index')
            ->with('mcfonctions', $mcfonctions);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/mcfonctions/create.blade.php)
        $mcfonction = new McFonction;
        return view('Masomwetu.School.mcfonctions.create',compact('mcfonction'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'fonction'=>$request->fonction,
					'description'=>$request->description,
				];
				$rules = [
				'fonction'=>'required',
					'description'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$mcfonction = McFonction::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $mcfonction->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('mcfonction',$mcfonction);
					return redirect()->back();
				}return redirect()->route('mcfonctions.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $mcfonction = McFonction::findOrFail($id);
				return view('Masomwetu.School.mcfonctions.show',compact('mcfonction'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $mcfonction = McFonction::findOrFail($id);
				return view('Masomwetu.School.mcfonctions.edit',compact('mcfonction'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$mcfonction = McFonction::findOrFail($id);
				$datas = [
				'fonction'=>$request->fonction,
					'description'=>$request->description,
				];
				$rules = [
				'fonction'=>'required',
					'description'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$mcfonction->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('mcfonctions.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        McFonction::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('mcfonctions.index');
    }
}
