<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\NiveauEtudePersonnel;
use App\Masomwetu\School\Personnel; 
class NiveauEtudePersonnelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the niveauetudepersonnels
        $niveauetudepersonnels = NiveauEtudePersonnel::all();

        // load the view and pass the niveauetudepersonnels
        return view('Masomwetu.School.niveauetudepersonnels.index')
            ->with('niveauetudepersonnels', $niveauetudepersonnels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/niveauetudepersonnels/create.blade.php)
        $niveauetudepersonnel = new NiveauEtudePersonnel;
				$personnels = Personnel::all();
        return view('Masomwetu.School.niveauetudepersonnels.create',compact('niveauetudepersonnel','personnels'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'qualification'=>$request->qualification,
					'diplome_brevet_licence'=>$request->diplome_brevet_licence,
					'annee'=>$request->annee,
					'observation'=>$request->observation,
				];
				$rules = [
				'personnel_id'=>'required',
					'qualification'=>'required',
					'diplome_brevet_licence'=>'required',
					'annee'=>'required',
					'observation'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$niveauetudepersonnel = NiveauEtudePersonnel::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $niveauetudepersonnel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('niveauetudepersonnel',$niveauetudepersonnel);
					return redirect()->back();
				}return redirect()->route('niveauetudepersonnels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $niveauetudepersonnel = NiveauEtudePersonnel::findOrFail($id);
				return view('Masomwetu.School.niveauetudepersonnels.show',compact('niveauetudepersonnel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $niveauetudepersonnel = NiveauEtudePersonnel::findOrFail($id);
				$personnels = Personnel::all();
				return view('Masomwetu.School.niveauetudepersonnels.edit',compact('niveauetudepersonnel','personnels'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$niveauetudepersonnel = NiveauEtudePersonnel::findOrFail($id);
				$datas = [
				'personnel_id'=>$request->personnel_id,
					'qualification'=>$request->qualification,
					'diplome_brevet_licence'=>$request->diplome_brevet_licence,
					'annee'=>$request->annee,
					'observation'=>$request->observation,
				];
				$rules = [
				'personnel_id'=>'required',
					'qualification'=>'required',
					'diplome_brevet_licence'=>'required',
					'annee'=>'required',
					'observation'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$niveauetudepersonnel->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('niveauetudepersonnels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
				// 
        NiveauEtudePersonnel::destroy($id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
				my_flash("Suppression effectée","danger");
				return redirect()->route('niveauetudepersonnels.index');
    }
}
