<?php

namespace App\Http\Controllers\Masomwetu\School;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\School\Personnel;
use App\Masomwetu\Report\MrCoteModifiee;
use App\Masomwetu\Salary\SaSalarie;
use App\Masomwetu\School\Agent;
use App\Masomwetu\School\DossierPersonnel;
use App\Masomwetu\School\NiveauEtudePersonnel;
use App\Masomwetu\Presence\Pointage;
use App\Masomwetu\Presence\PrevisionArriveeSortie; 
class PersonnelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the personnels
        $personnels = Personnel::all();

        // load the view and pass the personnels
        return view('Masomwetu.School.personnels.index')
            ->with('personnels', $personnels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/personnels/create.blade.php)
        $personnel = new Personnel;
        return view('Masomwetu.School.personnels.create',compact('personnel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'noms'=>$request->noms,
					'genre'=>$request->genre,
					'adresse'=>$request->adresse,
					'telephone'=>$request->telephone,
					'adresse_mail'=>$request->adresse_mail,
					'etat_civil'=>$request->etat_civil,
					'date_naissance'=>($request->date_naissance??''),
					'nationalite'=>$request->nationalite,
					'ecole_id'=>$request->ecole_id,
				];
				$rules = [
				'noms'=>'required',
					'genre'=>'required',
					'adresse'=>'',
					'telephone'=>'',
					'adresse_mail'=>'',
					'etat_civil'=>'',
					'date_naissance'=>'',
					'nationalite'=>'',
					'ecole_id'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$personnel = Personnel::create($datas);
				if($image = chado_saveFile('public/personnel/image/','image',$personnel->id)){
					$personnel->image = $image;
					$personnel->save();
				}
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $personnel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('personnel',$personnel);
					return redirect()->back();
				}return redirect()->route('personnels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $personnel = Personnel::findOrFail($id);
				return view('Masomwetu.School.personnels.show',compact('personnel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $personnel = Personnel::findOrFail($id);
				return view('Masomwetu.School.personnels.edit',compact('personnel'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$personnel = Personnel::findOrFail($id);
				$datas = [
				'noms'=>$request->noms,
					'genre'=>$request->genre,
					'adresse'=>$request->adresse,
					'telephone'=>$request->telephone,
					'adresse_mail'=>$request->adresse_mail,
					'etat_civil'=>$request->etat_civil,
					'date_naissance'=>($request->date_naissance??''),
					'nationalite'=>$request->nationalite,
					'ecole_id'=>$request->ecole_id,
				];
				$rules = [
				'noms'=>'required',
					'genre'=>'required',
					'adresse'=>'',
					'telephone'=>'',
					'adresse_mail'=>'',
					'etat_civil'=>'',
					'date_naissance'=>'',
					'nationalite'=>'',
					'ecole_id'=>'',
				];
				
				if($request->check_image or $request->image){
					if($request->image and ($image = chado_saveFile('public/personnel/image/','image',$personnel->id)))
						$datas['image'] = $image;
					else $datas['image'] = '';
					$rules['image'] = '';
				}
					
				\Validator::make($datas,$rules)->validate();
				$personnel->update($datas);
				my_flash("Modification effectée avec succès");
				if ($request->has('redirectTo')){
					$id = $personnel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('personnel',$personnel);
					return redirect()->back();
				}
				return redirect()->route('personnels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
				// 
        Personnel::destroy($id);
		if ($request->has('redirectTo')){
			return \Redirect::to($request->redirectTo);
		}
				my_flash("Suppression effectée","danger");
				return redirect()->route('personnels.index');
    }
}
