<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\SmsConfig;
class SmsConfigsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the smsconfigs
        $smsconfigs = SmsConfig::all();

        // load the view and pass the smsconfigs
        return view('Masomwetu.Sys.smsconfigs.index')
            ->with('smsconfigs', $smsconfigs);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/smsconfigs/create.blade.php)
        $smsconfig = new SmsConfig;
        return view('Masomwetu.Sys.smsconfigs.create',compact('smsconfig'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'active'=>$request->active,
					'ip'=>$request->ip,
					'port'=>$request->port,
				];
				$rules = [
				'active'=>'',
					'ip'=>'required',
					'port'=>'required',
				];
				\Validator::make($datas,$rules)->validate();
				$smsconfig = SmsConfig::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $smsconfig->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('smsconfig',$smsconfig);
					return redirect()->back();
				}return redirect()->route('smsconfigs.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $smsconfig = SmsConfig::findOrFail($id);
				return view('Masomwetu.Sys.smsconfigs.show',compact('smsconfig'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $smsconfig = SmsConfig::findOrFail($id);
				return view('Masomwetu.Sys.smsconfigs.edit',compact('smsconfig'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$smsconfig = SmsConfig::findOrFail($id);
				$datas = [
				'active'=>$request->active,
					'ip'=>$request->ip,
					'port'=>$request->port,
				];
				$rules = [
				'active'=>'',
					'ip'=>'required',
					'port'=>'required',
				];
				
				\Validator::make($datas,$rules)->validate();
				$smsconfig->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('smsconfigs.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SmsConfig::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('smsconfigs.index');
    }
}
