<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\SysAccessLevel;
use App\Masomwetu\Sys\SysZone;
use App\Masomwetu\Sys\SysRole; 
class SysAccessLevelsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sysaccesslevels
        $sysaccesslevels = SysAccessLevel::all();

        // load the view and pass the sysaccesslevels
        return view('Masomwetu.Sys.sysaccesslevels.index')
            ->with('sysaccesslevels', $sysaccesslevels);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sysaccesslevels/create.blade.php)
        $sysaccesslevel = new SysAccessLevel;
				$sysZones = SysZone::all();
				$sysRoles = SysRole::all();
        return view('Masomwetu.Sys.sysaccesslevels.create',compact('sysaccesslevel','sysZones','sysRoles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'sys_zone_id'=>$request->sys_zone_id,
					'sys_role_id'=>$request->sys_role_id,
					'read'=>$request->read,
					'write'=>$request->write,
					'create'=>$request->create,
					'update'=>$request->update,
					'liste'=>$request->liste,
					'delete'=>$request->delete,
				];
				$rules = [
				'sys_zone_id'=>'required',
					'sys_role_id'=>'required',
					'read'=>'',
					'write'=>'',
					'create'=>'',
					'update'=>'',
					'liste'=>'',
					'delete'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$sysaccesslevel = SysAccessLevel::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sysaccesslevel->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sysaccesslevel',$sysaccesslevel);
					return redirect()->back();
				}return redirect()->route('sysaccesslevels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sysaccesslevel = SysAccessLevel::findOrFail($id);
				return view('Masomwetu.Sys.sysaccesslevels.show',compact('sysaccesslevel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sysaccesslevel = SysAccessLevel::findOrFail($id);
				$sysZones = SysZone::all();
				$sysRoles = SysRole::all();
				return view('Masomwetu.Sys.sysaccesslevels.edit',compact('sysaccesslevel','sysZones','sysRoles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sysaccesslevel = SysAccessLevel::findOrFail($id);
				$datas = [
				'sys_zone_id'=>$request->sys_zone_id,
					'sys_role_id'=>$request->sys_role_id,
					'read'=>$request->read,
					'write'=>$request->write,
					'create'=>$request->create,
					'update'=>$request->update,
					'liste'=>$request->liste,
					'delete'=>$request->delete,
				];
				$rules = [
				'sys_zone_id'=>'required',
					'sys_role_id'=>'required',
					'read'=>'',
					'write'=>'',
					'create'=>'',
					'update'=>'',
					'liste'=>'',
					'delete'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sysaccesslevel->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sysaccesslevels.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SysAccessLevel::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sysaccesslevels.index');
    }
}
