<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\SysRole;
use App\Masomwetu\Sys\SysAccessLevel;
use App\Masomwetu\Sys\SysUserRole; 
class SysRolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sysroles
        $sysroles = SysRole::all();

        // load the view and pass the sysroles
        return view('Masomwetu.Sys.sysroles.index')
            ->with('sysroles', $sysroles);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sysroles/create.blade.php)
        $sysrole = new SysRole;
        return view('Masomwetu.Sys.sysroles.create',compact('sysrole'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'role'=>$request->role,
					'code'=>$request->code,
					'role_desc'=>$request->role_desc,
				];
				$rules = [
				'role'=>'required',
					'code'=>'required',
					'role_desc'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$sysrole = SysRole::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sysrole->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sysrole',$sysrole);
					return redirect()->back();
				}return redirect()->route('sysroles.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sysrole = SysRole::findOrFail($id);
				return view('Masomwetu.Sys.sysroles.show',compact('sysrole'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sysrole = SysRole::findOrFail($id);
				return view('Masomwetu.Sys.sysroles.edit',compact('sysrole'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sysrole = SysRole::findOrFail($id);
				$datas = [
				'role'=>$request->role,
					'code'=>$request->code,
					'role_desc'=>$request->role_desc,
				];
				$rules = [
				'role'=>'required',
					'code'=>'required',
					'role_desc'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sysrole->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sysroles.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SysRole::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sysroles.index');
    }
}
