<?php

namespace App\Http\Controllers\Masomwetu\Sys;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Masomwetu\Sys\SysUserRole;
use App\Masomwetu\Sys\User;
use App\Masomwetu\Sys\SysRole;
use App\Masomwetu\Scholar\MsAnneeScolaire; 
class SysUserRolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
				// get all the sysuserroles
        $sysuserroles = SysUserRole::all();

        // load the view and pass the sysuserroles
        return view('Masomwetu.Sys.sysuserroles.index')
            ->with('sysuserroles', $sysuserroles);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
				// load the create form (app/views/sysuserroles/create.blade.php)
        $sysuserrole = new SysUserRole;
				$users = User::all();
				$sysRoles = SysRole::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
        return view('Masomwetu.Sys.sysuserroles.create',compact('sysuserrole','users','sysRoles','msAnneeScolaires'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
				// 
				$datas = [
				'user_id'=>$request->user_id,
					'sys_role_id'=>$request->sys_role_id,
					'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
					'actif'=>$request->actif,
					'date_desactif'=>($request->date_desactif??''),
				];
				$rules = [
				'user_id'=>'required',
					'sys_role_id'=>'required',
					'ms_annee_scolaire_id'=>'required',
					'actif'=>'required',
					'date_desactif'=>'',
				];
				\Validator::make($datas,$rules)->validate();
				$sysuserrole = SysUserRole::create($datas);
				
				my_flash("Enregistrement effecté avec succès");
				if ($request->has('redirectTo')){
					$id = $sysuserrole->id;
					$url = str_replace('__id__', $id, $request->redirectTo);
					return \Redirect::to($url);
				}
				if ($request->has('keep_the_form')){
					if ($request->has('keep_form_data'))
						flash_set_form_data('sysuserrole',$sysuserrole);
					return redirect()->back();
				}return redirect()->route('sysuserroles.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
				// 
        $sysuserrole = SysUserRole::findOrFail($id);
				return view('Masomwetu.Sys.sysuserroles.show',compact('sysuserrole'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
				// 
        $sysuserrole = SysUserRole::findOrFail($id);
				$users = User::all();
				$sysRoles = SysRole::all();
				$msAnneeScolaires = MsAnneeScolaire::all();
				return view('Masomwetu.Sys.sysuserroles.edit',compact('sysuserrole','users','sysRoles','msAnneeScolaires'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
				// 
				$sysuserrole = SysUserRole::findOrFail($id);
				$datas = [
				'user_id'=>$request->user_id,
					'sys_role_id'=>$request->sys_role_id,
					'ms_annee_scolaire_id'=>$request->ms_annee_scolaire_id,
					'actif'=>$request->actif,
					'date_desactif'=>($request->date_desactif??''),
				];
				$rules = [
				'user_id'=>'required',
					'sys_role_id'=>'required',
					'ms_annee_scolaire_id'=>'required',
					'actif'=>'required',
					'date_desactif'=>'',
				];
				
				\Validator::make($datas,$rules)->validate();
				$sysuserrole->update($datas);
				my_flash("Modification effectée avec succès");
				return redirect()->route('sysuserroles.show',$id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
				// 
        SysUserRole::destroy($id);
				my_flash("Suppression effectée","danger");
				return redirect()->route('sysuserroles.index');
    }
}
